/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.problems;

import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.problems.Problem;
import com.intellij.problems.ProblemListener;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WolfTheProblemSolverImpl
extends WolfTheProblemSolver {
    private final Map<VirtualFile, ProblemFileInfo> myProblems;
    private final Collection<VirtualFile> myCheckingQueue;
    private final Project myProject;
    private final List<Condition<VirtualFile>> myFilters;
    private boolean myFiltersLoaded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemove(@NotNull VirtualFile problemFile) {
        ProblemFileInfo old;
        if (problemFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(0);
        }
        Object object = this.myProblems;
        synchronized (object) {
            old = this.myProblems.remove(problemFile);
        }
        object = this.myCheckingQueue;
        synchronized (object) {
            this.myCheckingQueue.remove(problemFile);
        }
        if (old != null) {
            ((ProblemListener)this.myProject.getMessageBus().syncPublisher(ProblemListener.TOPIC)).problemsDisappeared(problemFile);
        }
    }

    public WolfTheProblemSolverImpl(@NotNull Project project, @NotNull PsiManager psiManager, @NotNull VirtualFileManager virtualFileManager) {
        if (project == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(1);
        }
        if (psiManager == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(2);
        }
        if (virtualFileManager == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(3);
        }
        this.myProblems = new THashMap();
        this.myCheckingQueue = new THashSet(10);
        this.myFilters = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myFiltersLoaded = false;
        this.myProject = project;
        PsiTreeChangeAdapter changeListener = new PsiTreeChangeAdapter(){

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.childrenChanged(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.childrenChanged(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.childrenChanged(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.childrenChanged(event);
            }

            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.childrenChanged(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(5);
                }
                WolfTheProblemSolverImpl.this.clearSyntaxErrorFlag(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/problems/WolfTheProblemSolverImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)changeListener);
        VirtualFileListener virtualFileListener = new VirtualFileListener(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.onDeleted(event.getFile());
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.onDeleted(event.getFile());
            }

            private void onDeleted(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (file2.isDirectory()) {
                    WolfTheProblemSolverImpl.this.clearInvalidFiles();
                } else {
                    WolfTheProblemSolverImpl.this.doRemove(file2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/problems/WolfTheProblemSolverImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onDeleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        virtualFileManager.addVirtualFileListener(virtualFileListener, (Disposable)this.myProject);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (fileStatusManager != null) {
            fileStatusManager.addFileStatusListener(new FileStatusListener(){

                public void fileStatusesChanged() {
                    WolfTheProblemSolverImpl.this.clearInvalidFiles();
                }

                public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                    if (virtualFile == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    this.fileStatusesChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/codeInsight/problems/WolfTheProblemSolverImpl$3", "fileStatusChanged"));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInvalidFiles() {
        VirtualFile[] virtualFileArray = this.myProblems;
        synchronized (this.myProblems) {
            VirtualFile[] files2 = VfsUtilCore.toVirtualFileArray(this.myProblems.keySet());
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (VirtualFile problemFile : files2) {
                if (problemFile.isValid() && this.isToBeHighlighted(problemFile)) continue;
                this.doRemove(problemFile);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSyntaxErrorFlag(@NotNull PsiTreeChangeEvent event) {
        PsiFile file2;
        if (event == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(4);
        }
        if ((file2 = event.getFile()) == null) {
            return;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            ProblemFileInfo info = this.myProblems.get(virtualFile);
            if (info != null) {
                info.hasSyntaxErrors = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCheckingIfVincentSolvedProblemsYet(@NotNull ProgressIndicator progress, @NotNull ProgressableTextEditorHighlightingPass pass) throws ProcessCanceledException {
        ArrayList<VirtualFile> files2;
        if (progress == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(5);
        }
        if (pass == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(6);
        }
        if (!this.myProject.isOpen()) {
            return;
        }
        Collection<VirtualFile> collection = this.myCheckingQueue;
        synchronized (collection) {
            files2 = new ArrayList<VirtualFile>(this.myCheckingQueue);
        }
        long progressLimit = files2.stream().filter(VirtualFile::isValid).mapToLong(VirtualFile::getLength).sum();
        pass.setProgressLimit(progressLimit);
        for (VirtualFile virtualFile : files2) {
            progress.checkCanceled();
            if (virtualFile == null) break;
            if (!virtualFile.isValid() || this.orderVincentToCleanTheCar(virtualFile, progress)) {
                this.doRemove(virtualFile);
            }
            if (!virtualFile.isValid()) continue;
            pass.advanceProgress(virtualFile.getLength());
        }
    }

    private boolean orderVincentToCleanTheCar(@NotNull VirtualFile file2, @NotNull ProgressIndicator progressIndicator) throws ProcessCanceledException {
        if (file2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(7);
        }
        if (progressIndicator == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(8);
        }
        if (!this.isToBeHighlighted(file2)) {
            this.clearProblems(file2);
            return true;
        }
        if (this.hasSyntaxErrors(file2)) {
            return false;
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (this.willBeHighlightedAnyway(file2)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile == null) {
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return false;
        }
        final AtomicReference error = new AtomicReference();
        final AtomicBoolean hasErrorElement = new AtomicBoolean();
        try {
            GeneralHighlightingPass pass = new GeneralHighlightingPass(this.myProject, psiFile, document, 0, document.getTextLength(), false, new ProperTextRange(0, document.getTextLength()), null, HighlightInfoProcessor.getEmpty()){

                @Override
                protected HighlightInfoHolder createInfoHolder(@NotNull PsiFile file2) {
                    if (file2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return new HighlightInfoHolder(file2, new HighlightInfoFilter[0]){

                        @Override
                        public boolean add(@Nullable HighlightInfo info) {
                            if (info != null && info.getSeverity() == HighlightSeverity.ERROR) {
                                error.set(info);
                                hasErrorElement.set(myHasErrorElement);
                                throw new ProcessCanceledException();
                            }
                            return super.add(info);
                        }
                    };
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/problems/WolfTheProblemSolverImpl$4", "createInfoHolder"));
                }
            };
            pass.collectInformation(progressIndicator);
        }
        catch (ProcessCanceledException e) {
            if (error.get() != null) {
                ProblemImpl problem = new ProblemImpl(file2, (HighlightInfo)error.get(), hasErrorElement.get());
                this.reportProblems(file2, Collections.singleton(problem));
            }
            return false;
        }
        this.clearProblems(file2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSyntaxErrors(VirtualFile file2) {
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            ProblemFileInfo info = this.myProblems.get(file2);
            return info != null && info.hasSyntaxErrors;
        }
    }

    private boolean willBeHighlightedAnyway(VirtualFile file2) {
        FileEditor[] selectedEditors;
        for (FileEditor editor : selectedEditors = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()) {
            if (!(editor instanceof TextEditor)) continue;
            Document document = ((TextEditor)editor).getEditor().getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile(document);
            if (psiFile == null || !Comparing.equal((Object)file2, (Object)psiFile.getVirtualFile())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProblemFilesBeneath(@NotNull Condition<VirtualFile> condition) {
        if (condition == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(9);
        }
        if (!this.myProject.isOpen()) {
            return false;
        }
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            if (!this.myProblems.isEmpty()) {
                for (VirtualFile problemFile : this.myProblems.keySet()) {
                    if (!problemFile.isValid() || !condition.value((Object)problemFile)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public boolean hasProblemFilesBeneath(@NotNull Module scope) {
        if (scope == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(10);
        }
        return this.hasProblemFilesBeneath((Condition<VirtualFile>)((Condition)virtualFile -> {
            if (scope == null) {
                WolfTheProblemSolverImpl.$$$reportNull$$$0(27);
            }
            return ModuleUtilCore.moduleContainsFile((Module)scope, (VirtualFile)virtualFile, (boolean)false);
        }));
    }

    public void addProblemListener(@NotNull WolfTheProblemSolver.ProblemListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(11);
        }
        if (parentDisposable == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(12);
        }
        this.myProject.getMessageBus().connect(parentDisposable).subscribe(ProblemListener.TOPIC, (Object)listener2);
    }

    public void registerFileHighlightFilter(final @NotNull Condition<VirtualFile> filter, @NotNull Disposable parentDisposable) {
        if (filter == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(13);
        }
        if (parentDisposable == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(14);
        }
        this.myFilters.add(filter);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                WolfTheProblemSolverImpl.this.myFilters.remove(filter);
            }
        });
    }

    public void queue(VirtualFile suspiciousFile) {
        if (!this.isToBeHighlighted(suspiciousFile)) {
            return;
        }
        this.doQueue(suspiciousFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueue(@NotNull VirtualFile suspiciousFile) {
        if (suspiciousFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(15);
        }
        Collection<VirtualFile> collection = this.myCheckingQueue;
        synchronized (collection) {
            this.myCheckingQueue.add(suspiciousFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProblemFile(VirtualFile virtualFile) {
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            return this.myProblems.containsKey(virtualFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isToBeHighlighted(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return false;
        }
        List<Condition<VirtualFile>> list2 = this.myFilters;
        synchronized (list2) {
            if (!this.myFiltersLoaded) {
                this.myFiltersLoaded = true;
                this.myFilters.addAll(Arrays.asList(Extensions.getExtensions((ExtensionPointName)FILTER_EP_NAME, (AreaInstance)this.myProject)));
            }
        }
        for (Condition condition : this.myFilters) {
            ProgressManager.checkCanceled();
            if (!condition.value((Object)virtualFile)) continue;
            return true;
        }
        return false;
    }

    public void weHaveGotProblems(@NotNull VirtualFile virtualFile, @NotNull List<Problem> problems) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(16);
        }
        if (problems == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(17);
        }
        if (problems.isEmpty()) {
            return;
        }
        if (!this.isToBeHighlighted(virtualFile)) {
            return;
        }
        this.weHaveGotNonIgnorableProblems(virtualFile, problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void weHaveGotNonIgnorableProblems(@NotNull VirtualFile virtualFile, @NotNull List<Problem> problems) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(18);
        }
        if (problems == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(19);
        }
        if (problems.isEmpty()) {
            return;
        }
        boolean fireListener = false;
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            ProblemFileInfo storedProblems = this.myProblems.get(virtualFile);
            if (storedProblems == null) {
                storedProblems = new ProblemFileInfo();
                this.myProblems.put(virtualFile, storedProblems);
                fireListener = true;
            }
            storedProblems.problems.addAll(problems);
        }
        this.doQueue(virtualFile);
        if (fireListener) {
            ((ProblemListener)this.myProject.getMessageBus().syncPublisher(ProblemListener.TOPIC)).problemsAppeared(virtualFile);
        }
    }

    public void clearProblems(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(20);
        }
        this.doRemove(virtualFile);
    }

    public Problem convertToProblem(@Nullable VirtualFile virtualFile, int line, int column, @NotNull String[] message) {
        if (message == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(21);
        }
        if (virtualFile == null || virtualFile.isDirectory() || virtualFile.getFileType().isBinary()) {
            return null;
        }
        HighlightInfo info = (HighlightInfo)ReadAction.compute(() -> {
            if (message == null) {
                WolfTheProblemSolverImpl.$$$reportNull$$$0(26);
            }
            TextRange textRange = WolfTheProblemSolverImpl.getTextRange(virtualFile, line, column);
            String description = StringUtil.join((String[])message, (String)"\n");
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        });
        if (info == null) {
            return null;
        }
        return new ProblemImpl(virtualFile, info, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportProblems(@NotNull VirtualFile file2, @NotNull Collection<Problem> problems) {
        boolean fireChanged;
        boolean hasProblemsBefore;
        if (file2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(22);
        }
        if (problems == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(23);
        }
        if (problems.isEmpty()) {
            this.clearProblems(file2);
            return;
        }
        if (!this.isToBeHighlighted(file2)) {
            return;
        }
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            ProblemFileInfo oldInfo = this.myProblems.remove(file2);
            hasProblemsBefore = oldInfo != null;
            ProblemFileInfo newInfo = new ProblemFileInfo();
            this.myProblems.put(file2, newInfo);
            for (Problem problem : problems) {
                newInfo.problems.add(problem);
                ProblemFileInfo problemFileInfo = newInfo;
                problemFileInfo.hasSyntaxErrors = problemFileInfo.hasSyntaxErrors | ((ProblemImpl)problem).isSyntaxOnly();
            }
            fireChanged = hasProblemsBefore && !oldInfo.equals(newInfo);
        }
        this.doQueue(file2);
        if (!hasProblemsBefore) {
            ((ProblemListener)this.myProject.getMessageBus().syncPublisher(ProblemListener.TOPIC)).problemsAppeared(file2);
        } else if (fireChanged) {
            ((ProblemListener)this.myProject.getMessageBus().syncPublisher(ProblemListener.TOPIC)).problemsChanged(file2);
        }
    }

    @NotNull
    private static TextRange getTextRange(@NotNull VirtualFile virtualFile, int line, int column) {
        Document document;
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(24);
        }
        if (line > (document = FileDocumentManager.getInstance().getDocument(virtualFile)).getLineCount()) {
            line = document.getLineCount();
        }
        line = line <= 0 ? 0 : line - 1;
        int offset = document.getLineStartOffset(line) + (column <= 0 ? 0 : column - 1);
        TextRange textRange = new TextRange(offset, offset);
        if (textRange == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(25);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFileManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pass";
                break;
            }
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 10: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspiciousFile";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/problems/WolfTheProblemSolverImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/problems/WolfTheProblemSolverImpl";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doRemove";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clearSyntaxErrorFlag";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startCheckingIfVincentSolvedProblemsYet";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "orderVincentToCleanTheCar";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasProblemFilesBeneath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addProblemListener";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerFileHighlightFilter";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doQueue";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "weHaveGotProblems";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "weHaveGotNonIgnorableProblems";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "clearProblems";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblem";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "reportProblems";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTextRange";
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$convertToProblem$1";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasProblemFilesBeneath$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProblemFileInfo {
        private final Collection<Problem> problems = new THashSet();
        private boolean hasSyntaxErrors;

        private ProblemFileInfo() {
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProblemFileInfo that = (ProblemFileInfo)o;
            return this.hasSyntaxErrors == that.hasSyntaxErrors && this.problems.equals(that.problems);
        }

        public int hashCode() {
            int result2 = this.problems.hashCode();
            result2 = 31 * result2 + (this.hasSyntaxErrors ? 1 : 0);
            return result2;
        }
    }
}

