/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.KdbxEncryption;
import com.intellij.credentialStore.kdbx.KdbxHeaderKt;
import com.intellij.credentialStore.kdbx.KdbxKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/credentialStore/kdbx/Salsa20Encryption;", "Lcom/intellij/credentialStore/kdbx/KdbxEncryption;", "key", "", "([B)V", "getKey", "()[B", "salsa20", "Lorg/bouncycastle/crypto/engines/Salsa20Engine;", "decrypt", "encryptedText", "encrypt", "decryptedText", "intellij.platform.credentialStore"})
public final class Salsa20Encryption
implements KdbxEncryption {
    private final Salsa20Engine salsa20;
    @NotNull
    private final byte[] key;

    @Override
    @NotNull
    public byte[] decrypt(@NotNull byte[] encryptedText) {
        Intrinsics.checkParameterIsNotNull((Object)encryptedText, (String)"encryptedText");
        byte[] output = new byte[encryptedText.length];
        this.salsa20.processBytes(encryptedText, 0, encryptedText.length, output, 0);
        return output;
    }

    @Override
    @NotNull
    public byte[] encrypt(@NotNull byte[] decryptedText) {
        Intrinsics.checkParameterIsNotNull((Object)decryptedText, (String)"decryptedText");
        byte[] output = new byte[decryptedText.length];
        this.salsa20.processBytes(decryptedText, 0, decryptedText.length, output, 0);
        return output;
    }

    @Override
    @NotNull
    public byte[] getKey() {
        return this.key;
    }

    public Salsa20Encryption(@NotNull byte[] key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.key = key;
        this.salsa20 = new Salsa20Engine();
        KeyParameter keyParameter = new KeyParameter(KdbxHeaderKt.sha256MessageDigest().digest(this.getKey()));
        this.salsa20.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, KdbxKt.access$getSALSA20_IV$p()));
    }
}

