/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.MessagePool;
import com.intellij.icons.AllIcons;
import com.intellij.ui.LayeredIcon;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;

class IdeErrorsIcon
extends JLabel {
    private final LayeredIcon myIcon;
    private final boolean myEnableBlink;
    private Future myBlinker;

    IdeErrorsIcon(boolean enableBlink) {
        this.myEnableBlink = enableBlink;
        this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.myIcon = new LayeredIcon(new Icon[]{AllIcons.Ide.FatalError, AllIcons.Ide.FatalError_read, AllIcons.Ide.EmptyFatalError}){

            public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
                super.paintIcon(c, g, x, y);
            }

            public synchronized void setLayerEnabled(int layer, boolean enabled) {
                super.setLayerEnabled(layer, enabled);
            }
        };
        this.setIcon((Icon)this.myIcon);
    }

    void setState(MessagePool.State state2) {
        switch (state2) {
            case UnreadErrors: {
                this.myIcon.setLayerEnabled(0, true);
                this.myIcon.setLayerEnabled(1, false);
                this.myIcon.setLayerEnabled(2, false);
                this.startBlinker();
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.setToolTipText(DiagnosticBundle.message("error.notification.tooltip", new Object[0]));
                break;
            }
            case ReadErrors: {
                this.stopBlinker();
                this.myIcon.setLayerEnabled(0, false);
                this.myIcon.setLayerEnabled(1, true);
                this.myIcon.setLayerEnabled(2, false);
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.setToolTipText(DiagnosticBundle.message("error.notification.tooltip", new Object[0]));
                break;
            }
            case NoErrors: {
                this.stopBlinker();
                this.myIcon.setLayerEnabled(0, false);
                this.myIcon.setLayerEnabled(1, false);
                this.myIcon.setLayerEnabled(2, true);
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.setToolTipText(null);
            }
        }
        this.repaint();
    }

    private synchronized void startBlinker() {
        if (this.myEnableBlink && this.myBlinker == null) {
            this.myBlinker = JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(){
                private boolean enabled = false;

                @Override
                public void run() {
                    IdeErrorsIcon.this.myIcon.setLayerEnabled(0, this.enabled);
                    IdeErrorsIcon.this.myIcon.setLayerEnabled(1, false);
                    IdeErrorsIcon.this.myIcon.setLayerEnabled(2, !this.enabled);
                    IdeErrorsIcon.this.repaint();
                    this.enabled = !this.enabled;
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    private synchronized void stopBlinker() {
        if (this.myBlinker != null) {
            this.myBlinker.cancel(true);
            this.myBlinker = null;
        }
    }
}

