/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UnifiedEditorRangeHighlighter {
    @NotNull
    private final List<Element> myPieces;

    public UnifiedEditorRangeHighlighter(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(0);
        }
        this.myPieces = new ArrayList<Element>();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, false);
        if (model == null) {
            return;
        }
        model.processRangeHighlightersOverlappingWith(0, document.getTextLength(), (Processor<? super RangeHighlighterEx>)((Processor)marker -> {
            int newStart = marker.getStartOffset();
            int newEnd = marker.getEndOffset();
            this.myPieces.add(new Element((RangeHighlighterEx)marker, newStart, newEnd));
            return true;
        }));
    }

    public UnifiedEditorRangeHighlighter(@Nullable Project project, @NotNull Document document1, @NotNull Document document2, @NotNull List<HighlightRange> ranges) {
        if (document1 == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(1);
        }
        if (document2 == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(2);
        }
        if (ranges == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(3);
        }
        this.myPieces = new ArrayList<Element>();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        MarkupModelEx model1 = (MarkupModelEx)DocumentMarkupModel.forDocument(document1, project, false);
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument(document2, project, false);
        this.init(model1, model2, ranges);
    }

    private void init(@Nullable MarkupModelEx model1, @Nullable MarkupModelEx model2, @NotNull List<HighlightRange> ranges) {
        if (ranges == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(4);
        }
        for (HighlightRange range2 : ranges) {
            if (range2.getSide().isLeft()) {
                if (model1 == null) continue;
                this.processRange(model1, range2);
                continue;
            }
            if (model2 == null) continue;
            this.processRange(model2, range2);
        }
    }

    private void processRange(@NotNull MarkupModelEx model, @NotNull HighlightRange range2) {
        if (model == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(5);
        }
        if (range2 == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(6);
        }
        TextRange base = range2.getBase();
        TextRange changed = range2.getChanged();
        int changedLength = changed.getEndOffset() - changed.getStartOffset();
        model.processRangeHighlightersOverlappingWith(changed.getStartOffset(), changed.getEndOffset(), (Processor<? super RangeHighlighterEx>)((Processor)marker -> {
            int relativeStart = Math.max(marker.getStartOffset() - changed.getStartOffset(), 0);
            int relativeEnd = Math.min(marker.getEndOffset() - changed.getStartOffset(), changedLength);
            int newStart = base.getStartOffset() + relativeStart;
            int newEnd = base.getStartOffset() + relativeEnd;
            if (newEnd - newStart <= 0) {
                return true;
            }
            this.myPieces.add(new Element((RangeHighlighterEx)marker, newStart, newEnd));
            return true;
        }));
    }

    public static void erase(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(7);
        }
        MarkupModel model = DocumentMarkupModel.forDocument(document, project, true);
        model.removeAllHighlighters();
    }

    public void apply(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(8);
        }
        MarkupModel model = DocumentMarkupModel.forDocument(document, project, true);
        for (Element piece : this.myPieces) {
            RangeHighlighterEx delegate = piece.getDelegate();
            if (!delegate.isValid()) continue;
            RangeHighlighter highlighter = model.addRangeHighlighter(piece.getStart(), piece.getEnd(), delegate.getLayer(), delegate.getTextAttributes(), delegate.getTargetArea());
            highlighter.setEditorFilter(delegate.getEditorFilter());
            highlighter.setCustomRenderer(delegate.getCustomRenderer());
            highlighter.setErrorStripeMarkColor(delegate.getErrorStripeMarkColor());
            highlighter.setErrorStripeTooltip(delegate.getErrorStripeTooltip());
            highlighter.setGutterIconRenderer(delegate.getGutterIconRenderer());
            highlighter.setLineMarkerRenderer(delegate.getLineMarkerRenderer());
            highlighter.setLineSeparatorColor(delegate.getLineSeparatorColor());
            highlighter.setThinErrorStripeMark(delegate.isThinErrorStripeMark());
            highlighter.setLineSeparatorPlacement(delegate.getLineSeparatorPlacement());
            highlighter.setLineSeparatorRenderer(delegate.getLineSeparatorRenderer());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document2";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processRange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "erase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Element {
        @NotNull
        private final RangeHighlighterEx myDelegate;
        private final int myStart;
        private final int myEnd;

        public Element(@NotNull RangeHighlighterEx delegate, int start, int end) {
            if (delegate == null) {
                Element.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
            this.myStart = start;
            this.myEnd = end;
        }

        @NotNull
        public RangeHighlighterEx getDelegate() {
            RangeHighlighterEx rangeHighlighterEx = this.myDelegate;
            if (rangeHighlighterEx == null) {
                Element.$$$reportNull$$$0(1);
            }
            return rangeHighlighterEx;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter$Element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter$Element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

