/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.CompositePrintable;
import com.intellij.execution.testframework.DeferingPrinter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Key;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.config.AbstractProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestsOutputConsolePrinter
implements Printer,
Disposable {
    private final ConsoleView myConsole;
    private final TestConsoleProperties myProperties;
    private final AbstractTestProxy myUnboundOutputRoot;
    private AbstractTestProxy myCurrentTest;
    private final DeferingPrinter myPausedPrinter;
    private boolean myPaused;
    private int myMarkOffset;
    private final TestFrameworkPropertyListener<Boolean> myPropertyListener;

    public TestsOutputConsolePrinter(@NotNull BaseTestsOutputConsoleView testsOutputConsoleView, TestConsoleProperties properties, AbstractTestProxy unboundOutputRoot) {
        if (testsOutputConsoleView == null) {
            TestsOutputConsolePrinter.$$$reportNull$$$0(0);
        }
        this.myPausedPrinter = new DeferingPrinter();
        this.myPaused = false;
        this.myMarkOffset = 0;
        this.myPropertyListener = new TestFrameworkPropertyListener<Boolean>(){

            @Override
            public void onChanged(Boolean value) {
                if (!value.booleanValue()) {
                    TestsOutputConsolePrinter.this.myMarkOffset = 0;
                }
            }
        };
        this.myConsole = testsOutputConsoleView.getConsole();
        this.myProperties = properties;
        this.myUnboundOutputRoot = unboundOutputRoot;
        this.myProperties.addListener(TestConsoleProperties.SCROLL_TO_STACK_TRACE, this.myPropertyListener);
    }

    public ConsoleView getConsole() {
        return this.myConsole;
    }

    public boolean isPaused() {
        return this.myPaused;
    }

    public void pause(boolean doPause) {
        this.myPaused = doPause;
        if (!doPause) {
            this.myPausedPrinter.printAndForget(this);
        }
    }

    @Override
    public void print(String text2, ConsoleViewContentType contentType) {
        this.myConsole.print(text2, contentType);
    }

    @Override
    public void onNewAvailable(@NotNull Printable printable) {
        if (printable == null) {
            TestsOutputConsolePrinter.$$$reportNull$$$0(1);
        }
        if (this.myPaused) {
            printable.printOn(this.myPausedPrinter);
        } else {
            printable.printOn(this);
        }
    }

    public void updateOnTestSelected(AbstractTestProxy test) {
        if (this.myCurrentTest == test) {
            return;
        }
        if (this.myCurrentTest != null) {
            this.myCurrentTest.setPrinter(null);
        }
        this.myMarkOffset = 0;
        Runnable clearRunnable = () -> this.myConsole.clear();
        if (test == null) {
            this.myCurrentTest = null;
            CompositePrintable.invokeInAlarm(clearRunnable);
            return;
        }
        this.myCurrentTest = test;
        this.myCurrentTest.setPrinter(this);
        Runnable scrollRunnable = () -> this.scrollToBeginning();
        AbstractTestProxy currentProxyOrRoot = this.getCurrentProxyOrRoot();
        CompositePrintable.invokeInAlarm(clearRunnable);
        currentProxyOrRoot.printOn(this);
        currentProxyOrRoot.printFromFrameworkOutputFile(this);
        CompositePrintable.invokeInAlarm(scrollRunnable);
    }

    private AbstractTestProxy getCurrentProxyOrRoot() {
        return this.isRoot() && this.myUnboundOutputRoot != null ? this.myUnboundOutputRoot : this.myCurrentTest;
    }

    public boolean isCurrent(CompositePrintable printable) {
        return this.myCurrentTest == printable || this.isRoot();
    }

    private boolean isRoot() {
        return this.isRoot(this.myCurrentTest);
    }

    private boolean isRoot(@Nullable AbstractTestProxy proxy) {
        return proxy != null && proxy.getParent() == this.myUnboundOutputRoot;
    }

    @Override
    public void printHyperlink(String text2, HyperlinkInfo info) {
        this.myConsole.printHyperlink(text2, info);
    }

    @Override
    public void mark() {
        if (TestConsoleProperties.SCROLL_TO_STACK_TRACE.value((AbstractProperty.AbstractPropertyContainer)this.myProperties)) {
            this.myMarkOffset = this.myConsole.getContentSize();
        }
    }

    public void dispose() {
        this.myProperties.removeListener(TestConsoleProperties.SCROLL_TO_STACK_TRACE, this.myPropertyListener);
    }

    public boolean canPause() {
        return this.myCurrentTest != null && this.myCurrentTest.isInProgress();
    }

    protected void scrollToBeginning() {
        this.myConsole.performWhenNoDeferredOutput(() -> {
            AbstractTestProxy currentProxyOrRoot = this.getCurrentProxyOrRoot();
            if (currentProxyOrRoot != null && !currentProxyOrRoot.isInProgress()) {
                this.myConsole.scrollTo(this.myMarkOffset);
            }
        });
    }

    @Override
    public void printWithAnsiColoring(@NotNull String text2, @NotNull Key processOutputType) {
        if (text2 == null) {
            TestsOutputConsolePrinter.$$$reportNull$$$0(2);
        }
        if (processOutputType == null) {
            TestsOutputConsolePrinter.$$$reportNull$$$0(3);
        }
        if (this.myConsole instanceof TerminalExecutionConsole) {
            this.print(text2, ConsoleViewContentType.getConsoleViewType((Key)processOutputType));
        } else {
            Printer.super.printWithAnsiColoring(text2, processOutputType);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsOutputConsoleView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutputType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/ui/TestsOutputConsolePrinter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onNewAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "printWithAnsiColoring";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

