/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class FileParentDirMacro
extends Macro {
    @Override
    public String getName() {
        return "FileParentDir";
    }

    @Override
    public String getDescription() {
        return IdeBundle.message((String)"macro.file.parent.directory", (Object[])new Object[0]);
    }

    @Override
    public String expand(DataContext dataContext, String ... args) throws Macro.ExecutionCancelledException {
        VirtualFile vFile;
        if (args.length == 0 || StringUtil.isEmpty((String)args[0])) {
            return this.expand(dataContext);
        }
        String param = args[0];
        for (vFile = FileParentDirMacro.getVirtualDirOrParent(dataContext); vFile != null && !param.equalsIgnoreCase(vFile.getName()); vFile = vFile.getParent()) {
        }
        return FileParentDirMacro.parentPath(vFile);
    }

    @Override
    public String expand(DataContext dataContext) {
        VirtualFile vFile = FileParentDirMacro.getVirtualDirOrParent(dataContext);
        return FileParentDirMacro.parentPath(vFile);
    }

    private static String parentPath(@Nullable VirtualFile vFile) {
        if (vFile != null) {
            vFile = vFile.getParent();
        }
        return vFile != null ? FileParentDirMacro.getPath(vFile) : null;
    }
}

