/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nullable;

public enum NavBarKeyboardCommand {
    LEFT(37),
    RIGHT(39),
    HOME(36),
    END(35),
    DOWN(40),
    UP(38),
    ENTER(10),
    NAVIGATE(115),
    ESCAPE(27);

    private final KeyStroke myKeyStroke;

    private NavBarKeyboardCommand(int keyCode) {
        this.myKeyStroke = KeyStroke.getKeyStroke(keyCode, 0);
    }

    public KeyStroke getKeyStroke() {
        return this.myKeyStroke;
    }

    @Nullable
    public static NavBarKeyboardCommand fromString(String name) {
        if (name != null) {
            for (NavBarKeyboardCommand command : NavBarKeyboardCommand.values()) {
                if (!command.name().equals(name)) continue;
                return command;
            }
        }
        return null;
    }
}

