/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompoundProjectViewNodeDecorator
implements ProjectViewNodeDecorator {
    private static final ProjectViewNodeDecorator EMPTY = new CompoundProjectViewNodeDecorator(new ProjectViewNodeDecorator[0]);
    private static final Key<ProjectViewNodeDecorator> KEY = Key.create((String)"ProjectViewNodeDecorator");
    private static final Logger LOG = Logger.getInstance(CompoundProjectViewNodeDecorator.class);
    private final ProjectViewNodeDecorator[] decorators;

    @NotNull
    public static ProjectViewNodeDecorator get(@Nullable Project project) {
        if (project == null || project.isDisposed()) {
            ProjectViewNodeDecorator projectViewNodeDecorator = EMPTY;
            if (projectViewNodeDecorator == null) {
                CompoundProjectViewNodeDecorator.$$$reportNull$$$0(0);
            }
            return projectViewNodeDecorator;
        }
        ProjectViewNodeDecorator provider = (ProjectViewNodeDecorator)project.getUserData(KEY);
        if (provider != null) {
            ProjectViewNodeDecorator projectViewNodeDecorator = provider;
            if (projectViewNodeDecorator == null) {
                CompoundProjectViewNodeDecorator.$$$reportNull$$$0(1);
            }
            return projectViewNodeDecorator;
        }
        provider = new CompoundProjectViewNodeDecorator((ProjectViewNodeDecorator[])EP_NAME.getExtensions((AreaInstance)project));
        project.putUserData(KEY, (Object)provider);
        ProjectViewNodeDecorator projectViewNodeDecorator = provider;
        if (projectViewNodeDecorator == null) {
            CompoundProjectViewNodeDecorator.$$$reportNull$$$0(2);
        }
        return projectViewNodeDecorator;
    }

    public CompoundProjectViewNodeDecorator(ProjectViewNodeDecorator ... decorators) {
        if (decorators == null) {
            CompoundProjectViewNodeDecorator.$$$reportNull$$$0(3);
        }
        this.decorators = decorators;
    }

    @Override
    public void decorate(ProjectViewNode node, PresentationData data) {
        this.forEach(decorator -> decorator.decorate(node, data));
    }

    @Override
    public void decorate(PackageDependenciesNode node, ColoredTreeCellRenderer cellRenderer) {
        this.forEach(decorator -> decorator.decorate(node, cellRenderer));
    }

    private void forEach(@NotNull Consumer<ProjectViewNodeDecorator> consumer) {
        if (consumer == null) {
            CompoundProjectViewNodeDecorator.$$$reportNull$$$0(4);
        }
        for (ProjectViewNodeDecorator decorator : this.decorators) {
            try {
                consumer.accept(decorator);
            }
            catch (IndexNotReadyException exception) {
                throw new ProcessCanceledException((Throwable)exception);
            }
            catch (ProcessCanceledException exception) {
                throw exception;
            }
            catch (Exception exception) {
                LOG.warn("unexpected error in " + decorator, (Throwable)exception);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/CompoundProjectViewNodeDecorator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorators";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/CompoundProjectViewNodeDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

