/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.os;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class OsVersionUsageCollector
extends ApplicationUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        Set<UsageDescriptor> set2 = OsVersionUsageCollector.getDescriptors();
        if (set2 == null) {
            OsVersionUsageCollector.$$$reportNull$$$0(0);
        }
        return set2;
    }

    @NotNull
    public static Set<UsageDescriptor> getDescriptors() {
        UsageDescriptor descriptor2;
        if (SystemInfo.isLinux) {
            String version = OsVersionUsageCollector.getLinuxOSVersion();
            descriptor2 = new UsageDescriptor("Linux/" + version, 1);
        } else {
            descriptor2 = new UsageDescriptor(UsageDescriptorKeyValidator.ensureProperKey(SystemInfo.OS_NAME + "." + SystemInfo.OS_VERSION), 1);
        }
        Set<UsageDescriptor> set2 = Collections.singleton(descriptor2);
        if (set2 == null) {
            OsVersionUsageCollector.$$$reportNull$$$0(1);
        }
        return set2;
    }

    @NotNull
    public static String getLinuxOSVersion() {
        Version version;
        String releaseId = null;
        String releaseVersion = null;
        try (Stream<String> lines22 = Files.lines(Paths.get("/etc/os-release", new String[0]));){
            Map<String, String> releases = lines22.map(line -> StringUtil.split((String)line, (String)"=")).filter(parts -> parts.size() == 2).collect(Collectors.toMap(parts -> (String)parts.get(0), parts -> StringUtil.unquoteString((String)((String)parts.get(1)))));
            releaseId = releases.get("ID");
            releaseVersion = releases.get("VERSION_ID");
        }
        catch (IOException lines22) {
            // empty catch block
        }
        if (releaseId == null) {
            releaseId = "unknown";
        }
        if (releaseVersion == null && (version = Version.parseVersion((String)(releaseVersion = SystemInfo.OS_VERSION))) != null) {
            releaseVersion = version.toCompactString();
        }
        String string = releaseId + " " + releaseVersion;
        if (string == null) {
            OsVersionUsageCollector.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupId() {
        if ("statistics.os.version" == null) {
            OsVersionUsageCollector.$$$reportNull$$$0(3);
        }
        return "statistics.os.version";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/statistic/collectors/fus/os/OsVersionUsageCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinuxOSVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

