/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineNumberListener;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnnotationPresentation
implements TextAnnotationPresentation {
    @NotNull
    private final FileAnnotation myFileAnnotation;
    @NotNull
    private final UpToDateLineNumberProvider myUpToDateLineNumberProvider;
    @Nullable
    private final AnnotationSourceSwitcher mySwitcher;
    private final ArrayList<AnAction> myActions;
    @NotNull
    private final Disposable myDisposable;
    private boolean myDisposed;

    AnnotationPresentation(@NotNull FileAnnotation fileAnnotation, @NotNull UpToDateLineNumberProvider upToDateLineNumberProvider, @Nullable AnnotationSourceSwitcher switcher, @NotNull Disposable disposable) {
        if (fileAnnotation == null) {
            AnnotationPresentation.$$$reportNull$$$0(0);
        }
        if (upToDateLineNumberProvider == null) {
            AnnotationPresentation.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            AnnotationPresentation.$$$reportNull$$$0(2);
        }
        this.myActions = new ArrayList();
        this.myDisposed = false;
        this.myUpToDateLineNumberProvider = upToDateLineNumberProvider;
        this.myFileAnnotation = fileAnnotation;
        this.mySwitcher = switcher;
        this.myDisposable = disposable;
    }

    @Override
    public EditorFontType getFontType(int line) {
        VcsRevisionNumber revision = this.myFileAnnotation.originalRevision(line);
        VcsRevisionNumber currentRevision = this.myFileAnnotation.getCurrentRevision();
        return currentRevision != null && currentRevision.equals(revision) ? EditorFontType.BOLD : EditorFontType.PLAIN;
    }

    @Override
    public ColorKey getColor(int line) {
        if (this.mySwitcher == null) {
            return AnnotationSource.LOCAL.getColor();
        }
        return this.mySwitcher.getAnnotationSource(line).getColor();
    }

    @Override
    public List<AnAction> getActions(int line) {
        int correctedNumber = this.myUpToDateLineNumberProvider.getLineNumber(line);
        for (AnAction action : this.myActions) {
            LineNumberListener listener2;
            UpToDateLineNumberListener upToDateListener = (UpToDateLineNumberListener)ObjectUtils.tryCast((Object)action, UpToDateLineNumberListener.class);
            if (upToDateListener != null) {
                upToDateListener.consume((Object)correctedNumber);
            }
            if ((listener2 = (LineNumberListener)ObjectUtils.tryCast((Object)action, LineNumberListener.class)) == null) continue;
            listener2.consume((Object)line);
        }
        return this.myActions;
    }

    @NotNull
    public List<AnAction> getActions() {
        ArrayList<AnAction> arrayList = this.myActions;
        if (arrayList == null) {
            AnnotationPresentation.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void addAction(AnAction action) {
        this.myActions.add(action);
    }

    public void addAction(AnAction action, int index) {
        this.myActions.add(index, action);
    }

    @Override
    public void gutterClosed() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAnnotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upToDateLineNumberProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/AnnotationPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotationPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

