/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.util.Consumer;
import com.intellij.util.io.URLUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Verifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlainTextSplitter
extends BaseSplitter {
    private static final PlainTextSplitter INSTANCE = new PlainTextSplitter();
    public static final int DELAY = 500;
    @NonNls
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(\\s|\b)");
    @NonNls
    private static final Pattern MAIL = Pattern.compile("([\\p{L}0-9\\.\\-\\_\\+]+@([\\p{L}0-9\\-\\_]+(\\.)?)+(com|net|[a-z]{2})?)");

    public static PlainTextSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text2, @NotNull TextRange range2, Consumer<TextRange> consumer) {
        if (range2 == null) {
            PlainTextSplitter.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)text2)) {
            return;
        }
        String substring = range2.substring(text2).replace('\b', '\n').replace('\f', '\n');
        if (Verifier.checkCharacterData((String)SPLIT_PATTERN.matcher(StringUtil.newBombedCharSequence((CharSequence)substring, (long)500L)).replaceAll("")) != null) {
            return;
        }
        TextSplitter ws = TextSplitter.getInstance();
        int from = range2.getStartOffset();
        Matcher matcher = SPLIT_PATTERN.matcher(StringUtil.newBombedCharSequence((CharSequence)range2.substring(text2), (long)500L));
        while (true) {
            String word;
            TextRange wRange;
            PlainTextSplitter.checkCancelled();
            if (matcher.find()) {
                TextRange found = PlainTextSplitter.matcherRange(range2, matcher);
                int till = found.getStartOffset();
                if (PlainTextSplitter.badSize(from, till)) continue;
                wRange = new TextRange(from, till);
                word = wRange.substring(text2);
                from = found.getEndOffset();
            } else {
                wRange = new TextRange(from, range2.getEndOffset());
                word = wRange.substring(text2);
            }
            List<TextRange> toCheck = word.contains("@") ? PlainTextSplitter.excludeByPattern(text2, wRange, MAIL, 0) : (word.contains("://") ? PlainTextSplitter.excludeByPattern(text2, wRange, URLUtil.URL_PATTERN, 0) : Collections.singletonList(wRange));
            for (TextRange r : toCheck) {
                ws.split(text2, r, consumer);
            }
            if (matcher.hitEnd()) break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spellchecker/inspections/PlainTextSplitter", "split"));
    }
}

