/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.MergedChange;
import com.intellij.vcs.log.impl.MergedChangeDiffRequestProvider;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsLogChangesBrowser
extends ChangesBrowserBase
implements Disposable {
    @NotNull
    private static final String EMPTY_SELECTION_TEXT = "Select commit to view details";
    @NotNull
    private final Project myProject;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final Function<CommitId, VcsShortCommitDetails> myDataGetter;
    @NotNull
    private final VcsLogUiProperties.PropertiesChangeListener myListener;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @NotNull
    private final List<Change> myChanges;
    @NotNull
    private final Map<CommitId, Set<Change>> myChangesToParents;
    @NotNull
    private final Wrapper myToolbarWrapper;
    @Nullable
    private Runnable myModelUpdateListener;

    public VcsLogChangesBrowser(@NotNull Project project, @NotNull MainVcsLogUiProperties uiProperties, @NotNull Function<CommitId, VcsShortCommitDetails> getter, @NotNull Disposable parent) {
        if (project == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(0);
        }
        if (uiProperties == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(1);
        }
        if (getter == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(3);
        }
        super(project, false, false);
        this.myRoots = ContainerUtil.newHashSet();
        this.myChanges = ContainerUtil.newArrayList();
        this.myChangesToParents = ContainerUtil.newHashMap();
        this.myProject = project;
        this.myUiProperties = uiProperties;
        this.myDataGetter = getter;
        this.myListener = new VcsLogUiProperties.PropertiesChangeListener(){

            @Override
            public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
                if (property == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS.equals(property)) {
                    VcsLogChangesBrowser.this.myViewer.rebuildTree();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$1", "onPropertyChanged"));
            }
        };
        this.myUiProperties.addChangeListener(this.myListener);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myToolbarWrapper = new Wrapper(this.getToolbar().getComponent());
        this.init();
        this.getViewerScrollPane().setBorder(IdeBorderFactory.createBorder((int)2));
        this.myViewer.setEmptyText(EMPTY_SELECTION_TEXT);
        this.myViewer.rebuildTree();
    }

    @Override
    @NotNull
    protected JComponent createToolbarComponent() {
        Wrapper wrapper2 = this.myToolbarWrapper;
        if (wrapper2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(4);
        }
        return wrapper2;
    }

    public void setToolbarHeightReferent(@NotNull JComponent referent) {
        if (referent == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(5);
        }
        this.myToolbarWrapper.setVerticalSizeReferent(referent);
    }

    public void setModelUpdateListener(@Nullable Runnable runnable2) {
        this.myModelUpdateListener = runnable2;
    }

    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myListener);
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        List list2 = ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.ChangesBrowser.Toolbar")});
        if (list2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        List list2 = ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.ChangesBrowser.Popup")});
        if (list2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public void resetSelectedDetails() {
        this.myChanges.clear();
        this.myChangesToParents.clear();
        this.myRoots.clear();
        this.myViewer.setEmptyText("");
        this.myViewer.rebuildTree();
        if (this.myModelUpdateListener != null) {
            this.myModelUpdateListener.run();
        }
    }

    public void setSelectedDetails(@NotNull List<VcsFullCommitDetails> detailsList) {
        if (detailsList == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(8);
        }
        this.myChanges.clear();
        this.myChangesToParents.clear();
        this.myRoots.clear();
        this.myRoots.addAll(ContainerUtil.map(detailsList, detail -> detail.getRoot()));
        if (detailsList.isEmpty()) {
            this.myViewer.setEmptyText(EMPTY_SELECTION_TEXT);
        } else if (detailsList.size() == 1) {
            VcsFullCommitDetails detail2 = (VcsFullCommitDetails)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(detailsList));
            this.myChanges.addAll(detail2.getChanges());
            if (detail2.getParents().size() > 1) {
                for (int i = 0; i < detail2.getParents().size(); ++i) {
                    THashSet changesSet = ContainerUtil.newIdentityTroveSet((Collection)detail2.getChanges(i));
                    this.myChangesToParents.put(new CommitId((Hash)detail2.getParents().get(i), detail2.getRoot()), (Set<Change>)changesSet);
                }
            }
            if (this.myChanges.isEmpty() && detail2.getParents().size() > 1) {
                this.myViewer.getEmptyText().setText("No merged conflicts.").appendSecondaryText("Show changes to parents", VcsLogUiUtil.getLinkAttributes(), e -> this.myUiProperties.set(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS, true));
            } else {
                this.myViewer.setEmptyText("");
            }
        } else {
            ArrayList changes = ContainerUtil.newArrayList();
            List detailsListReversed = ContainerUtil.reverse(detailsList);
            for (VcsFullCommitDetails detail3 : detailsListReversed) {
                changes.addAll(detail3.getChanges());
            }
            this.myChanges.addAll(CommittedChangesTreeBrowser.zipChanges(changes));
            this.myViewer.setEmptyText("");
        }
        this.myViewer.rebuildTree();
        if (this.myModelUpdateListener != null) {
            this.myModelUpdateListener.run();
        }
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        MyTreeModelBuilder builder2 = new MyTreeModelBuilder();
        builder2.setChanges(this.myChanges, null);
        if (this.isShowChangesFromParents() && !this.myChangesToParents.isEmpty()) {
            if (this.myChanges.isEmpty()) {
                builder2.addEmptyTextNode("No merged conflicts");
            }
            for (CommitId commitId : this.myChangesToParents.keySet()) {
                Collection changesFromParent = this.myChangesToParents.get(commitId);
                if (changesFromParent.isEmpty()) continue;
                builder2.addChangesFromParentNode(changesFromParent, commitId);
            }
        }
        DefaultTreeModel defaultTreeModel = builder2.build();
        if (defaultTreeModel == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(9);
        }
        return defaultTreeModel;
    }

    private boolean isShowChangesFromParents() {
        return this.myUiProperties.exists(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS) && this.myUiProperties.get(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS) != false;
    }

    @NotNull
    public List<Change> getDirectChanges() {
        List<Change> list2 = this.myChanges;
        if (list2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public List<Change> getSelectedChanges() {
        List<Change> list2 = VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
        if (list2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @NotNull
    public List<Change> getAllChanges() {
        List<Change> list2 = VcsTreeModelData.all((JTree)((Object)this.myViewer)).userObjects(Change.class);
        if (list2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(13);
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            AbstractVcs vcs = this.getVcs();
            if (vcs == null) {
                return null;
            }
            return vcs.getKeyInstanceMethod();
        }
        return super.getData(dataId);
    }

    @Nullable
    private AbstractVcs getVcs() {
        List allVcs = ContainerUtil.mapNotNull(this.myRoots, root -> ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(root));
        if (allVcs.size() == 1) {
            return (AbstractVcs)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)allVcs));
        }
        Set selectedVcs = ChangesUtil.getAffectedVcses(this.getSelectedChanges(), (Project)this.myProject);
        if (selectedVcs.size() == 1) {
            return (AbstractVcs)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)selectedVcs));
        }
        return null;
    }

    @Override
    @Nullable
    public ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject) {
        MergedChange mergedChange;
        if (userObject == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(14);
        }
        if (userObject instanceof MergedChange && (mergedChange = (MergedChange)((Object)userObject)).getSourceChanges().size() == 2) {
            return new MergedChangeDiffRequestProvider.MyProducer(this.myProject, mergedChange);
        }
        if (userObject instanceof Change) {
            Change change = (Change)userObject;
            CommitId parentId = null;
            for (CommitId commitId : this.myChangesToParents.keySet()) {
                if (!this.myChangesToParents.get(commitId).contains(change)) continue;
                parentId = commitId;
                break;
            }
            if (parentId != null) {
                RootTag tag = new RootTag(parentId.getHash(), this.getText(parentId));
                Map<Key, Object> context = Collections.singletonMap(ChangeDiffRequestProducer.TAG_KEY, tag);
                return ChangeDiffRequestProducer.create(this.myProject, change, context);
            }
            return ChangeDiffRequestProducer.create(this.myProject, change);
        }
        return null;
    }

    @NotNull
    private String getText(@NotNull CommitId commitId) {
        if (commitId == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(15);
        }
        String text2 = "Changes to " + commitId.getHash().toShortString();
        VcsShortCommitDetails detail = (VcsShortCommitDetails)this.myDataGetter.fun((Object)commitId);
        if (!(detail instanceof LoadingDetails) || detail instanceof IndexedDetails) {
            text2 = text2 + " " + StringUtil.shortenTextWithEllipsis((String)detail.getSubject(), (int)50, (int)0);
        }
        String string = text2;
        if (string == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsList";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupMenuActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectChanges";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setToolbarHeightReferent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedDetails";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestProducer";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RootTag {
        @NotNull
        private final Hash myCommit;
        @NotNull
        private final String myText;

        public RootTag(@NotNull Hash commit, @NotNull String text2) {
            if (commit == null) {
                RootTag.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                RootTag.$$$reportNull$$$0(1);
            }
            this.myCommit = commit;
            this.myText = text2;
        }

        public String toString() {
            return this.myText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RootTag tag = (RootTag)o;
            return Objects.equals(this.myCommit, tag.myCommit);
        }

        public int hashCode() {
            return Objects.hash(this.myCommit);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "commit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$RootTag";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ChangesBrowserParentNode
    extends ChangesBrowserNode {
        protected ChangesBrowserParentNode(CommitId commitId) {
            if (commitId == null) {
                ChangesBrowserParentNode.$$$reportNull$$$0(0);
            }
            super(VcsLogChangesBrowser.this.getText(commitId));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$ChangesBrowserParentNode", "<init>"));
        }
    }

    private static class ChangesBrowserEmptyTextNode
    extends ChangesBrowserNode {
        protected ChangesBrowserEmptyTextNode(@NotNull String text2) {
            if (text2 == null) {
                ChangesBrowserEmptyTextNode.$$$reportNull$$$0(0);
            }
            super(text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$ChangesBrowserEmptyTextNode", "<init>"));
        }
    }

    private class MyTreeModelBuilder
    extends TreeModelBuilder {
        public MyTreeModelBuilder() {
            super(VcsLogChangesBrowser.this.myProject, VcsLogChangesBrowser.this.getGrouping());
        }

        public void addEmptyTextNode(@NotNull String text2) {
            if (text2 == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(0);
            }
            ChangesBrowserEmptyTextNode textNode = new ChangesBrowserEmptyTextNode(text2);
            textNode.markAsHelperNode();
            this.myModel.insertNodeInto(textNode, this.myRoot, this.myRoot.getChildCount());
        }

        public void addChangesFromParentNode(@NotNull Collection<Change> changes, @NotNull CommitId commitId) {
            if (changes == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(1);
            }
            if (commitId == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(2);
            }
            ChangesBrowserParentNode parentNode = new ChangesBrowserParentNode(commitId);
            parentNode.markAsHelperNode();
            this.myModel.insertNodeInto(parentNode, this.myRoot, this.myRoot.getChildCount());
            for (Change change : changes) {
                this.insertChangeNode(change, parentNode, this.createChangeNode(change, null));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$MyTreeModelBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addEmptyTextNode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangesFromParentNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

