/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.codeInsight.intentions.SpecifyTypeInPy3AnnotationsIntention;
import com.jetbrains.python.codeInsight.intentions.TypeIntention;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyAnnotateTypesIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.add.type.hints.for.function.family", new Object[0]);
        if (string == null) {
            PyAnnotateTypesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            PyAnnotateTypesIntention.$$$reportNull$$$0(1);
        }
        if (!(file2 instanceof PyFile) || file2 instanceof PyDocstringFile) {
            return false;
        }
        PsiElement elementAt = PyUtil.findNonWhitespaceAtOffset(file2, editor.getCaretModel().getOffset());
        if (elementAt == null) {
            return false;
        }
        PyFunction function = this.findSuitableFunction(elementAt);
        if (function != null) {
            this.setText(PyBundle.message("INTN.add.type.hints.for.function", function.getName()));
            return true;
        }
        return false;
    }

    @Nullable
    public PyFunction findSuitableFunction(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            PyAnnotateTypesIntention.$$$reportNull$$$0(2);
        }
        return TypeIntention.findSuitableFunction(elementAt, input -> true);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PyFunction function;
        PsiElement elementAt;
        if (project == null) {
            PyAnnotateTypesIntention.$$$reportNull$$$0(3);
        }
        if ((elementAt = PyUtil.findNonWhitespaceAtOffset(file2, editor.getCaretModel().getOffset())) != null && (function = this.findSuitableFunction(elementAt)) != null) {
            PyAnnotateTypesIntention.annotateTypes(editor, function);
        }
    }

    public static void annotateTypes(Editor editor, PyFunction function) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)function)) {
            return;
        }
        WriteAction.run(() -> {
            if (PyAnnotateTypesIntention.isPy3k(function.getContainingFile())) {
                PyAnnotateTypesIntention.generatePy3kTypeAnnotations(function.getProject(), editor, function);
            } else {
                PyAnnotateTypesIntention.generateTypeCommentAnnotations(function.getProject(), function);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateTypeCommentAnnotations(Project project, PyFunction function) {
        StringBuilder replacementTextBuilder = new StringBuilder("# type: (");
        PyParameter[] params = function.getParameterList().getParameters();
        ArrayList templates = Lists.newArrayList();
        for (int i = 0; i < params.length; ++i) {
            if (params[i].isSelf()) continue;
            String type = SpecifyTypeInPy3AnnotationsIntention.parameterType(params[i]);
            templates.add(Pair.create((Object)replacementTextBuilder.length(), (Object)type));
            replacementTextBuilder.append(type);
            if (i >= params.length - 1) continue;
            replacementTextBuilder.append(", ");
        }
        replacementTextBuilder.append(") -> ");
        String returnType = SpecifyTypeInPy3AnnotationsIntention.returnType(function);
        templates.add(Pair.create((Object)replacementTextBuilder.length(), (Object)returnType));
        replacementTextBuilder.append(returnType);
        PyStatementList statements = function.getStatementList();
        String indentation = PyIndentUtil.getElementIndent((PsiElement)statements);
        replacementTextBuilder.insert(0, indentation);
        replacementTextBuilder.insert(0, "\n");
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        Document document = manager.getDocument(function.getContainingFile());
        if (document != null) {
            PyFunction element;
            PsiElement beforeStatements = statements.getPrevSibling();
            int offset = beforeStatements.getTextRange().getStartOffset();
            if (":".equals(beforeStatements.getText())) {
                ++offset;
            }
            try {
                document.insertString(offset, (CharSequence)replacementTextBuilder.toString());
            }
            finally {
                manager.commitDocument(document);
            }
            for (element = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(function); element != null && !element.getText().contains(replacementTextBuilder.toString()); element = element.getParent()) {
            }
            if (element != null) {
                TemplateBuilder builder2 = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)element);
                for (Pair template : templates) {
                    builder2.replaceRange(TextRange.from((int)(offset - element.getTextRange().getStartOffset() + replacementTextBuilder.toString().indexOf(35) + (Integer)template.first), (int)((String)template.second).length()), (String)template.second);
                }
                PyAnnotateTypesIntention.startTemplate(project, element, builder2);
            }
        }
    }

    private static void startTemplate(Project project, PsiElement callable, TemplateBuilder builder2) {
        Template template = ((TemplateBuilderImpl)builder2).buildInlineTemplate();
        int offset = callable.getTextRange().getStartOffset();
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, callable.getContainingFile().getVirtualFile(), offset);
        Editor targetEditor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor2, true);
        if (targetEditor != null) {
            targetEditor.getCaretModel().moveToOffset(offset);
            TemplateManager.getInstance(project).startTemplate(targetEditor, template);
        }
    }

    private static boolean isPy3k(PsiFile file2) {
        return !LanguageLevel.forElement((PsiElement)file2).isPython2();
    }

    private static void generatePy3kTypeAnnotations(@NotNull Project project, Editor editor, @NotNull PyFunction function) {
        int i;
        if (project == null) {
            PyAnnotateTypesIntention.$$$reportNull$$$0(4);
        }
        if (function == null) {
            PyAnnotateTypesIntention.$$$reportNull$$$0(5);
        }
        TemplateBuilder builder2 = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)function);
        PyExpression returnType = SpecifyTypeInPy3AnnotationsIntention.annotateReturnType(project, function, false);
        if (returnType != null) {
            builder2.replaceElement((PsiElement)returnType, returnType.getText());
        }
        PyParameter[] params = function.getParameterList().getParameters();
        for (i = params.length - 1; i >= 0; --i) {
            if (!(params[i] instanceof PyNamedParameter) || params[i].isSelf()) continue;
            params[i] = SpecifyTypeInPy3AnnotationsIntention.annotateParameter(project, editor, (PyNamedParameter)params[i], false);
        }
        for (i = params.length - 1; i >= 0; --i) {
            PyExpression annotationValue;
            if (!(params[i] instanceof PyNamedParameter) || params[i].isSelf()) continue;
            params[i] = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(params[i]);
            PyAnnotation annotation = ((PyNamedParameter)params[i]).getAnnotation();
            if (annotation == null || (annotationValue = annotation.getValue()) == null) continue;
            builder2.replaceElement((PsiElement)annotationValue, annotationValue.getText());
        }
        PyAnnotateTypesIntention.startTemplate(project, function, builder2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyAnnotateTypesIntention";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyAnnotateTypesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableFunction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePy3kTypeAnnotations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

