/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.stdlib.PyNamedTupleType;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeHintGenerationUtil {
    public static final String TYPE_COMMENT_PREFIX = "# type: ";

    private PyTypeHintGenerationUtil() {
    }

    public static void insertStandaloneAttributeTypeComment(@NotNull PyTargetExpression target2, @NotNull TypeEvalContext context, AnnotationInfo info, boolean startTemplate) {
        PyClass pyClass;
        if (target2 == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(1);
        }
        if ((pyClass = target2.getContainingClass()) == null) {
            throw new IllegalArgumentException("Target '" + target2.getText() + "' in not contained in a class definition");
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)target2)) {
            return;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(target2.getProject());
        LanguageLevel langLevel = LanguageLevel.forElement(target2);
        String assignedValue = langLevel.isAtLeast(LanguageLevel.PYTHON30) ? "..." : "None";
        String declarationText = target2.getName() + " = " + assignedValue + " " + TYPE_COMMENT_PREFIX + info.getAnnotationText();
        PyAssignmentStatement declaration = generator.createFromText(langLevel, PyAssignmentStatement.class, declarationText);
        PsiElement anchorBefore = PyTypeHintGenerationUtil.findPrecedingAnchorForAttributeDeclaration(pyClass);
        WriteAction.run(() -> {
            PyAssignmentStatement inserted;
            PsiComment insertedComment;
            if (context == null) {
                PyTypeHintGenerationUtil.$$$reportNull$$$0(35);
            }
            if (target2 == null) {
                PyTypeHintGenerationUtil.$$$reportNull$$$0(36);
            }
            if ((insertedComment = PyUtil.as((inserted = (PyAssignmentStatement)pyClass.getStatementList().addAfter(declaration, anchorBefore)).getLastChild(), PsiComment.class)) == null) {
                return;
            }
            PyTypeHintGenerationUtil.addImportsForTypeAnnotations(info.getTypes(), context, target2.getContainingFile());
            insertedComment = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(insertedComment);
            if (startTemplate && insertedComment != null) {
                PyTypeHintGenerationUtil.openEditorAndAddTemplateForTypeComment(insertedComment, info.getAnnotationText(), info.getTypeRanges());
            }
        });
    }

    public static void insertStandaloneAttributeAnnotation(@NotNull PyTargetExpression target2, @NotNull TypeEvalContext context, @NotNull AnnotationInfo info, boolean startTemplate) {
        LanguageLevel langLevel;
        if (target2 == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(3);
        }
        if (info == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(4);
        }
        if ((langLevel = LanguageLevel.forElement(target2)).isOlderThan(LanguageLevel.PYTHON36)) {
            throw new IllegalArgumentException("Target '" + target2.getText() + "' doesn't belong to Python 3.6+ project: " + (Object)((Object)langLevel));
        }
        PyClass pyClass = target2.getContainingClass();
        if (pyClass == null) {
            throw new IllegalArgumentException("Target '" + target2.getText() + "' in not contained in a class definition");
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)target2)) {
            return;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(target2.getProject());
        String declarationText = target2.getName() + ": " + info.getAnnotationText();
        PyTypeDeclarationStatement declaration = generator.createFromText(langLevel, PyTypeDeclarationStatement.class, declarationText);
        PsiElement anchorBefore = PyTypeHintGenerationUtil.findPrecedingAnchorForAttributeDeclaration(pyClass);
        WriteAction.run(() -> {
            if (info == null) {
                PyTypeHintGenerationUtil.$$$reportNull$$$0(32);
            }
            if (context == null) {
                PyTypeHintGenerationUtil.$$$reportNull$$$0(33);
            }
            if (target2 == null) {
                PyTypeHintGenerationUtil.$$$reportNull$$$0(34);
            }
            PyTypeDeclarationStatement inserted = (PyTypeDeclarationStatement)pyClass.getStatementList().addAfter(declaration, anchorBefore);
            PyTypeHintGenerationUtil.addImportsForTypeAnnotations(info.getTypes(), context, target2.getContainingFile());
            inserted = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(inserted);
            if (startTemplate && inserted != null) {
                PyTypeHintGenerationUtil.openEditorAndAddTemplateForAnnotation(inserted);
            }
        });
    }

    @Nullable
    private static PsiElement findPrecedingAnchorForAttributeDeclaration(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(5);
        }
        PyStatement firstStatement = pyClass.getStatementList().getStatements()[0];
        PyStringLiteralExpression classDocstring = pyClass.getDocStringExpression();
        if (firstStatement instanceof PyExpressionStatement && classDocstring == ((PyExpressionStatement)firstStatement).getExpression()) {
            return firstStatement;
        }
        return null;
    }

    public static void insertVariableAnnotation(@NotNull PyTargetExpression target2, @Nullable TypeEvalContext context, @NotNull AnnotationInfo info, boolean startTemplate) {
        ThrowableComputable addOrUpdateAnnotatedStatement;
        LanguageLevel langLevel;
        if (target2 == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(6);
        }
        if (info == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(7);
        }
        if ((langLevel = LanguageLevel.forElement(target2)).isOlderThan(LanguageLevel.PYTHON36)) {
            throw new IllegalArgumentException("Target '" + target2.getText() + "' doesn't belong to Python 3.6+ project: " + (Object)((Object)langLevel));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)target2)) {
            return;
        }
        Project project = target2.getProject();
        if (PyTypeHintGenerationUtil.canUseInlineAnnotation(target2)) {
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
            PyAssignmentStatement assignment = (PyAssignmentStatement)target2.getParent();
            SmartPsiElementPointer pointer = manager.createSmartPsiElementPointer((PsiElement)assignment);
            addOrUpdateAnnotatedStatement = () -> {
                if (target2 == null) {
                    PyTypeHintGenerationUtil.$$$reportNull$$$0(28);
                }
                if (info == null) {
                    PyTypeHintGenerationUtil.$$$reportNull$$$0(29);
                }
                PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)target2, (Consumer<Document>)((Consumer)document -> {
                    if (target2 == null) {
                        PyTypeHintGenerationUtil.$$$reportNull$$$0(30);
                    }
                    if (info == null) {
                        PyTypeHintGenerationUtil.$$$reportNull$$$0(31);
                    }
                    document.insertString(target2.getTextRange().getEndOffset(), (CharSequence)(": " + info.getAnnotationText()));
                }));
                return (PyAnnotationOwner)pointer.getElement();
            };
        } else {
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            String declarationText = target2.getName() + ": " + info.getAnnotationText();
            PyTypeDeclarationStatement declaration = generator.createFromText(langLevel, PyTypeDeclarationStatement.class, declarationText);
            PyStatement statement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)target2, PyStatement.class);
            assert (statement != null);
            addOrUpdateAnnotatedStatement = () -> (PyAnnotationOwner)statement.getParent().addBefore((PsiElement)declaration, (PsiElement)statement);
        }
        WriteAction.run(() -> {
            PyAnnotationOwner createdAnnotationOwner;
            if (info == null) {
                PyTypeHintGenerationUtil.$$$reportNull$$$0(26);
            }
            if (target2 == null) {
                PyTypeHintGenerationUtil.$$$reportNull$$$0(27);
            }
            if ((createdAnnotationOwner = (PyAnnotationOwner)addOrUpdateAnnotatedStatement.compute()) == null) {
                return;
            }
            if (context != null) {
                PyTypeHintGenerationUtil.addImportsForTypeAnnotations(info.getTypes(), context, target2.getContainingFile());
            }
            createdAnnotationOwner = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(createdAnnotationOwner);
            if (startTemplate && createdAnnotationOwner != null) {
                PyTypeHintGenerationUtil.openEditorAndAddTemplateForAnnotation(createdAnnotationOwner);
            }
        });
    }

    private static void openEditorAndAddTemplateForAnnotation(@NotNull PyAnnotationOwner annotated) {
        if (annotated == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(8);
        }
        assert (annotated.isValid());
        assert (annotated.getAnnotationValue() != null);
        Project project = annotated.getProject();
        int initialCaretOffset = annotated.getTextRange().getStartOffset();
        VirtualFile updatedVirtualFile = annotated.getContainingFile().getVirtualFile();
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, updatedVirtualFile, initialCaretOffset);
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor2, true);
        if (editor != null) {
            editor.getCaretModel().moveToOffset(initialCaretOffset);
            TemplateBuilder templateBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)annotated);
            String annotation = annotated.getAnnotationValue();
            String replacementText = ApplicationManager.getApplication().isUnitTestMode() ? "[" + annotation + "]" : annotation;
            templateBuilder.replaceElement((PsiElement)annotated.getAnnotation().getValue(), replacementText);
            templateBuilder.run(editor, true);
        }
    }

    private static boolean canUseInlineAnnotation(@NotNull PyTargetExpression target2) {
        PyAssignmentStatement assignment;
        if (target2 == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(9);
        }
        return (assignment = PyUtil.as(target2.getParent(), PyAssignmentStatement.class)) != null && assignment.getRawTargets().length == 1 && assignment.getLeftHandSideExpression() == target2;
    }

    public static void insertVariableTypeComment(@NotNull PyTargetExpression target2, TypeEvalContext context, @NotNull AnnotationInfo info, boolean startTemplate) {
        ThrowableRunnable insertComment;
        PsiElement insertionAnchor;
        if (target2 == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(10);
        }
        if (info == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(11);
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)target2)) {
            return;
        }
        String typeCommentText = "  # type: " + info.getAnnotationText();
        PyStatement statement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)target2, PyStatement.class);
        if (statement instanceof PyAssignmentStatement) {
            insertionAnchor = statement.getLastChild();
        } else if (statement instanceof PyWithStatement) {
            insertionAnchor = PyUtil.getHeaderEndAnchor((PyStatementListContainer)((Object)statement));
        } else if (statement instanceof PyForStatement) {
            insertionAnchor = PyUtil.getHeaderEndAnchor(((PyForStatement)statement).getForPart());
        } else {
            throw new IllegalArgumentException("Target expression must belong to an assignment, \"with\" statement or \"for\" loop");
        }
        if (insertionAnchor instanceof PsiComment) {
            String combinedTypeCommentText = typeCommentText + " " + insertionAnchor.getText();
            PsiElement lastNonComment = PyPsiUtils.getPrevNonCommentSibling(insertionAnchor, true);
            int startOffset = lastNonComment.getTextRange().getEndOffset();
            int endOffset = insertionAnchor.getTextRange().getEndOffset();
            insertComment = () -> {
                if (target2 == null) {
                    PyTypeHintGenerationUtil.$$$reportNull$$$0(25);
                }
                PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)target2, (Consumer<Document>)((Consumer)document -> document.replaceString(startOffset, endOffset, (CharSequence)combinedTypeCommentText)));
            };
        } else if (insertionAnchor != null) {
            int offset = insertionAnchor.getTextRange().getEndOffset();
            insertComment = () -> {
                if (target2 == null) {
                    PyTypeHintGenerationUtil.$$$reportNull$$$0(24);
                }
                PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)target2, (Consumer<Document>)((Consumer)document -> document.insertString(offset, (CharSequence)typeCommentText)));
            };
        } else {
            return;
        }
        WriteAction.run(() -> {
            if (target2 == null) {
                PyTypeHintGenerationUtil.$$$reportNull$$$0(22);
            }
            if (info == null) {
                PyTypeHintGenerationUtil.$$$reportNull$$$0(23);
            }
            insertComment.run();
            PsiComment insertedComment = target2.getTypeComment();
            if (insertedComment == null) {
                return;
            }
            PyTypeHintGenerationUtil.addImportsForTypeAnnotations(info.getTypes(), context, target2.getContainingFile());
            insertedComment = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(insertedComment);
            if (startTemplate && insertedComment != null) {
                PyTypeHintGenerationUtil.openEditorAndAddTemplateForTypeComment(insertedComment, info.getAnnotationText(), info.getTypeRanges());
            }
        });
    }

    private static void openEditorAndAddTemplateForTypeComment(@NotNull PsiComment insertedComment, @NotNull String annotation, @NotNull List<TextRange> typeRanges) {
        if (insertedComment == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(12);
        }
        if (annotation == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(13);
        }
        if (typeRanges == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(14);
        }
        int initialCaretOffset = insertedComment.getTextRange().getStartOffset();
        VirtualFile updatedVirtualFile = insertedComment.getContainingFile().getVirtualFile();
        Project project = insertedComment.getProject();
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, updatedVirtualFile, initialCaretOffset);
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor2, true);
        if (editor != null) {
            boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
            editor.getCaretModel().moveToOffset(initialCaretOffset);
            TemplateBuilder templateBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)insertedComment);
            for (TextRange range2 : typeRanges) {
                String individualType = range2.substring(annotation);
                String replacementText = testMode ? "[" + individualType + "]" : individualType;
                templateBuilder.replaceRange(range2.shiftRight(TYPE_COMMENT_PREFIX.length()), replacementText);
            }
            templateBuilder.run(editor, true);
        }
    }

    private static void addImportsForTypeAnnotations(@NotNull List<PyType> types, @NotNull TypeEvalContext context, @NotNull PsiFile file2) {
        if (types == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(17);
        }
        HashSet<PsiNamedElement> symbols = new HashSet<PsiNamedElement>();
        HashSet<String> namesFromTyping = new HashSet<String>();
        for (PyType type : types) {
            PyTypeHintGenerationUtil.collectImportTargetsFromType(type, context, symbols, namesFromTyping);
        }
        boolean builtinTyping = LanguageLevel.forElement((PsiElement)file2).isAtLeast(LanguageLevel.PYTHON35);
        AddImportHelper.ImportPriority priority = builtinTyping ? AddImportHelper.ImportPriority.BUILTIN : AddImportHelper.ImportPriority.THIRD_PARTY;
        for (String name : namesFromTyping) {
            AddImportHelper.addOrUpdateFromImportStatement(file2, "typing", name, null, priority, null);
        }
        for (PsiNamedElement symbol : symbols) {
            PyClassRefactoringUtil.insertImport((PsiElement)file2, symbol, null, true);
        }
    }

    private static void collectImportTargetsFromType(@Nullable PyType type, @NotNull TypeEvalContext context, @NotNull Set<PsiNamedElement> symbols, @NotNull Set<String> typingTypes) {
        PyTargetExpression target2;
        if (context == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(18);
        }
        if (symbols == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(19);
        }
        if (typingTypes == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(20);
        }
        if (type == null) {
            typingTypes.add("Any");
        } else if (type instanceof PyUnionType) {
            Collection<PyType> members = ((PyUnionType)type).getMembers();
            boolean isOptional = members.size() == 2 && members.contains(PyNoneType.INSTANCE);
            typingTypes.add(isOptional ? "Optional" : "Union");
            for (PyType pyType : members) {
                PyTypeHintGenerationUtil.collectImportTargetsFromType(pyType, context, symbols, typingTypes);
            }
        } else if (type instanceof PyNamedTupleType) {
            PyQualifiedNameOwner element = type.getDeclarationElement();
            if (element instanceof PsiNamedElement) {
                symbols.add((PsiNamedElement)element);
            }
        } else if (type instanceof PyCollectionType) {
            if (type instanceof PyCollectionTypeImpl) {
                PyClass pyClass = ((PyCollectionTypeImpl)type).getPyClass();
                String typingCollectionName = (String)PyTypingTypeProvider.TYPING_COLLECTION_CLASSES.get((Object)pyClass.getQualifiedName());
                if (typingCollectionName != null && type.isBuiltin()) {
                    typingTypes.add(typingCollectionName);
                } else {
                    symbols.add((PsiNamedElement)pyClass);
                }
            } else if (type instanceof PyTupleType) {
                typingTypes.add("Tuple");
            }
            for (PyType pyType : ((PyCollectionType)type).getElementTypes()) {
                PyTypeHintGenerationUtil.collectImportTargetsFromType(pyType, context, symbols, typingTypes);
            }
        } else if (type instanceof PyClassType) {
            symbols.add((PsiNamedElement)((PyClassType)type).getPyClass());
        } else if (type instanceof PyCallableType) {
            typingTypes.add("Callable");
            PyCallableType callableType = (PyCallableType)type;
            for (PyCallableParameter parameter : ContainerUtil.notNullize(callableType.getParameters(context))) {
                PyTypeHintGenerationUtil.collectImportTargetsFromType(parameter.getType(context), context, symbols, typingTypes);
            }
            PyTypeHintGenerationUtil.collectImportTargetsFromType(callableType.getReturnType(context), context, symbols, typingTypes);
        } else if (type instanceof PyGenericType && (target2 = PyUtil.as(type.getDeclarationElement(), PyTargetExpression.class)) != null) {
            symbols.add(target2);
        }
        if (type instanceof PyInstantiableType && ((PyInstantiableType)type).isDefinition()) {
            typingTypes.add("Type");
        }
    }

    public static void checkPep484Compatibility(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(21);
        }
        if (type == null || type instanceof PyNoneType || type instanceof PyGenericType) {
            return;
        }
        if (type instanceof PyUnionType) {
            for (PyType memberType : ((PyUnionType)type).getMembers()) {
                PyTypeHintGenerationUtil.checkPep484Compatibility(memberType, context);
            }
        } else if (type instanceof PyCollectionType) {
            for (PyType typeParam : ((PyCollectionType)type).getElementTypes()) {
                PyTypeHintGenerationUtil.checkPep484Compatibility(typeParam, context);
            }
        } else if (!(type instanceof PyClassType)) {
            if (type instanceof PyCallableType) {
                PyCallableType callableType = (PyCallableType)type;
                for (PyCallableParameter parameter : ContainerUtil.notNullize(callableType.getParameters(context))) {
                    PyTypeHintGenerationUtil.checkPep484Compatibility(parameter.getType(context), context);
                }
                PyTypeHintGenerationUtil.checkPep484Compatibility(callableType.getReturnType(context), context);
            } else {
                throw new Pep484IncompatibleTypeException(PyBundle.message("INTN.add.type.hint.for.variable.PEP484.incompatible.type", type.getName()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 3: 
            case 16: 
            case 18: 
            case 21: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 23: 
            case 26: 
            case 29: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotated";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedComment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRanges";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typingTypes";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyTypeHintGenerationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "insertStandaloneAttributeTypeComment";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "insertStandaloneAttributeAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findPrecedingAnchorForAttributeDeclaration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "insertVariableAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "openEditorAndAddTemplateForAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "canUseInlineAnnotation";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "insertVariableTypeComment";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "openEditorAndAddTemplateForTypeComment";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "addImportsForTypeAnnotations";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "collectImportTargetsFromType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPep484Compatibility";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$insertVariableTypeComment$10";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$insertVariableTypeComment$9";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$insertVariableTypeComment$7";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$insertVariableAnnotation$5";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$insertVariableAnnotation$3";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$2";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$insertStandaloneAttributeAnnotation$1";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$insertStandaloneAttributeTypeComment$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class AnnotationInfo {
        private final String myAnnotationText;
        private final List<PyType> myTypes;
        private final List<TextRange> myTypeRanges;

        public AnnotationInfo(@NotNull String annotationText) {
            if (annotationText == null) {
                AnnotationInfo.$$$reportNull$$$0(0);
            }
            this(annotationText, Collections.emptyList(), Collections.singletonList(TextRange.allOf((String)annotationText)));
        }

        public AnnotationInfo(@NotNull String annotationText, @Nullable PyType type) {
            if (annotationText == null) {
                AnnotationInfo.$$$reportNull$$$0(1);
            }
            this(annotationText, Collections.singletonList(type), Collections.singletonList(TextRange.allOf((String)annotationText)));
        }

        public AnnotationInfo(@NotNull String annotationText, @NotNull List<PyType> types, @NotNull List<TextRange> typeRanges) {
            if (annotationText == null) {
                AnnotationInfo.$$$reportNull$$$0(2);
            }
            if (types == null) {
                AnnotationInfo.$$$reportNull$$$0(3);
            }
            if (typeRanges == null) {
                AnnotationInfo.$$$reportNull$$$0(4);
            }
            this.myAnnotationText = annotationText;
            this.myTypes = types;
            this.myTypeRanges = typeRanges;
        }

        @NotNull
        public String getAnnotationText() {
            String string = this.myAnnotationText;
            if (string == null) {
                AnnotationInfo.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public List<PyType> getTypes() {
            List<PyType> list2 = this.myTypes;
            if (list2 == null) {
                AnnotationInfo.$$$reportNull$$$0(6);
            }
            return list2;
        }

        @NotNull
        public List<TextRange> getTypeRanges() {
            List<TextRange> list2 = this.myTypeRanges;
            if (list2 == null) {
                AnnotationInfo.$$$reportNull$$$0(7);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotationText";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeRanges";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyTypeHintGenerationUtil$AnnotationInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyTypeHintGenerationUtil$AnnotationInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotationText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypes";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Pep484IncompatibleTypeException
    extends RuntimeException {
        public Pep484IncompatibleTypeException(String message) {
            super(message);
        }
    }
}

