/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenamePyFileProcessor
extends RenamePsiFileProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof PyFile;
    }

    @Override
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        PyFile file2;
        if (element == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(1);
        }
        if ((file2 = (PyFile)element).getName().equals("__init__.py") && editor != null) {
            return file2.getParent();
        }
        return element;
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element) {
        if (element == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(2);
        }
        ArrayList<PsiReference> results = new ArrayList<PsiReference>();
        for (PsiReference reference : super.findReferences(element)) {
            if (!RenamePyFileProcessor.isNotAliasedInImportElement(reference)) continue;
            results.add(reference);
        }
        ArrayList<PsiReference> arrayList = results;
        if (arrayList == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    public void findCollisions(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        String newFileName;
        if (element == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(5);
        }
        if (allRenames == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(7);
        }
        if (!PyNames.isIdentifier(newFileName = FileUtil.getNameWithoutExtension((String)newName))) {
            ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>(result2);
            for (UsageInfo usageInfo : usages) {
                final PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)usageInfo.getElement(), PyImportStatementBase.class);
                if (importStatement == null) continue;
                result2.add((UsageInfo)new UnresolvableCollisionUsageInfo((PsiElement)importStatement, element){

                    @Override
                    public String getDescription() {
                        return "The name '" + newFileName + "' is not a valid Python identifier. Cannot update import statement in '" + importStatement.getContainingFile().getName() + "'";
                    }
                });
            }
        }
    }

    private static boolean isNotAliasedInImportElement(@NotNull PsiReference reference) {
        if (reference == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(8);
        }
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                PsiElement resolved = result2.getElement();
                if (!(resolved instanceof PyImportElement) || ((PyImportElement)resolved).getAsName() == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public String getHelpID(PsiElement element) {
        return "procedures.refactoring.renameRefactorings";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/rename/RenamePyFileProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/rename/RenamePyFileProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findCollisions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isNotAliasedInImportElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

