/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.util.imageio;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.bytesource.ByteSource;

public class CommonsImagingImageReaderSpi
extends ImageReaderSpi {
    private final ThreadLocal<ImageFormat> myFormat = new ThreadLocal();
    private final List<ImageFormat> myFormats;

    public CommonsImagingImageReaderSpi() {
        this.vendorName = "JetBrains, s.r.o.";
        this.version = "1.0";
        this.myFormats = new ArrayList<ImageFormats>(Arrays.asList(ImageFormats.values()));
        this.myFormats.removeAll(Arrays.asList(ImageFormats.UNKNOWN, ImageFormats.JPEG, ImageFormats.TIFF, ImageFormats.PNG));
        this.names = new String[this.myFormats.size() * 2];
        this.suffixes = new String[this.myFormats.size()];
        this.MIMETypes = new String[this.myFormats.size()];
        this.pluginClassName = MyImageReader.class.getName();
        this.inputTypes = new Class[]{ImageInputStream.class};
        int allFormatsLength = this.myFormats.size();
        for (int i = 0; i < allFormatsLength; ++i) {
            ImageFormat format = this.myFormats.get(i);
            this.names[2 * i] = StringUtil.toLowerCase((String)format.getExtension());
            this.names[2 * i + 1] = StringUtil.toLowerCase((String)format.getExtension());
            this.suffixes[i] = this.names[2 * i];
            this.MIMETypes[i] = "image/" + this.names[2 * i];
        }
    }

    @Override
    public String getDescription(Locale locale) {
        return "Apache Commons Imaging adapter reader";
    }

    @Override
    public boolean canDecodeInput(Object input) throws IOException {
        if (!(input instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)input;
        try {
            ImageFormat imageFormat = Imaging.guessFormat((ByteSource)new MyByteSource(stream));
            if (this.myFormats.contains(imageFormat)) {
                this.myFormat.set(imageFormat);
                return true;
            }
            return false;
        }
        catch (ImageReadException e) {
            throw new IOException(e);
        }
    }

    @Override
    public ImageReader createReaderInstance(Object extension) {
        return new MyImageReader(this, this.myFormat.get());
    }

    private static class MyImageReader
    extends ImageReader {
        private byte[] myBytes;
        private ImageInfo myInfo;
        private BufferedImage[] myImages;
        private final ImageFormat myDefaultFormat;

        private MyImageReader(CommonsImagingImageReaderSpi provider, ImageFormat imageFormat) {
            super(provider);
            this.myDefaultFormat = imageFormat == null ? ImageFormats.UNKNOWN : imageFormat;
        }

        @Override
        public void dispose() {
            this.myBytes = null;
            this.myInfo = null;
            this.myImages = null;
        }

        @Override
        public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
            super.setInput(input, seekForwardOnly, ignoreMetadata);
            this.myBytes = null;
            this.myInfo = null;
            this.myImages = null;
        }

        private ImageInfo getInfo() throws IOException {
            if (this.myInfo == null) {
                try {
                    this.myInfo = Imaging.getImageInfo((byte[])this.getBytes());
                }
                catch (ImageReadException e) {
                    throw new IOException(e);
                }
            }
            return this.myInfo;
        }

        private byte[] getBytes() throws IOException {
            if (this.myBytes == null) {
                ImageInputStream stream = (ImageInputStream)this.input;
                this.myBytes = new MyByteSource(stream).getAll();
            }
            return this.myBytes;
        }

        private BufferedImage[] getImages() throws IOException {
            if (this.myImages == null) {
                try {
                    List images = Imaging.getAllBufferedImages((byte[])this.getBytes());
                    this.myImages = images.toArray(new BufferedImage[0]);
                }
                catch (ImageReadException e) {
                    throw new IOException(e);
                }
            }
            return this.myImages;
        }

        @Override
        public int getNumImages(boolean allowSearch) throws IOException {
            return this.getInfo().getNumberOfImages();
        }

        @Override
        public int getWidth(int imageIndex) throws IOException {
            return this.getInfo().getWidth();
        }

        @Override
        public int getHeight(int imageIndex) throws IOException {
            return this.getInfo().getHeight();
        }

        @Override
        public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
            return Collections.singletonList(ImageTypeSpecifier.createFromRenderedImage(this.getImages()[imageIndex])).iterator();
        }

        @Override
        public IIOMetadata getStreamMetadata() throws IOException {
            return null;
        }

        @Override
        public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
            return null;
        }

        @Override
        public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
            return this.getImages()[imageIndex];
        }

        @Override
        public String getFormatName() throws IOException {
            return this.input == null ? this.myDefaultFormat.getName() : this.getInfo().getFormat().getName();
        }
    }

    private static class MyByteSource
    extends ByteSource {
        private final ImageInputStream myStream;

        public MyByteSource(ImageInputStream stream) {
            super(stream.toString());
            this.myStream = stream;
        }

        public InputStream getInputStream() throws IOException {
            this.myStream.seek(0L);
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return myStream.read();
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return myStream.read(b, off, len);
                }
            };
        }

        public byte[] getBlock(int start, int length) throws IOException {
            this.myStream.seek(start);
            byte[] bytes = new byte[length];
            int read2 = this.myStream.read(bytes);
            return ArrayUtil.realloc((byte[])bytes, (int)read2);
        }

        public byte[] getBlock(long start, int length) throws IOException {
            this.myStream.seek(start);
            byte[] bytes = new byte[length];
            int read2 = this.myStream.read(bytes);
            return ArrayUtil.realloc((byte[])bytes, (int)read2);
        }

        public byte[] getAll() throws IOException {
            return FileUtil.loadBytes((InputStream)this.getInputStream());
        }

        public long getLength() throws IOException {
            return this.myStream.length();
        }

        public String getDescription() {
            return this.myStream.toString();
        }
    }
}

