/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProviderKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PathQuery;
import org.jetbrains.builtInWebServer.RootProvider;
import org.jetbrains.builtInWebServer.SuitableRoot;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerPathToFileManagerKt;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ&\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\t2\b\b\u0002\u0010!\u001a\u00020\u00112\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010\"\u001a\u0004\u0018\u00010\t2\u0006\u0010#\u001a\u00020\u0018J\u0010\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010%\u001a\u00020\u0018J&\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\t2\b\b\u0002\u0010!\u001a\u00020\u00112\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\tR<\u0010\u0007\u001a*\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f \n*\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\u000b0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR0\u0010\u000f\u001a\u001e\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00110\u00110\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00150\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0017\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00180\u0018\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00150\u0015 \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\u00180\u0018\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager;", "", "application", "Lcom/intellij/openapi/application/Application;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/application/Application;Lcom/intellij/openapi/project/Project;)V", "parentToSuitableRoot", "Lcom/google/common/cache/LoadingCache;", "", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/builtInWebServer/SuitableRoot;", "getParentToSuitableRoot$intellij_platform_builtInServer_impl", "()Lcom/google/common/cache/LoadingCache;", "pathToExistShortTermCache", "Lcom/google/common/cache/Cache;", "", "getPathToExistShortTermCache$intellij_platform_builtInServer_impl", "()Lcom/google/common/cache/Cache;", "pathToInfoCache", "Lorg/jetbrains/builtInWebServer/PathInfo;", "getPathToInfoCache", "virtualFileToPathInfo", "Lcom/intellij/openapi/vfs/VirtualFile;", "clearCache", "", "doFindByRelativePath", "path", "pathQuery", "Lorg/jetbrains/builtInWebServer/PathQuery;", "doFindByRelativePath$intellij_platform_builtInServer_impl", "findVirtualFile", "cacheResult", "getPath", "file", "getPathInfo", "child", "getResolver", "Lorg/jetbrains/builtInWebServer/FileResolver;", "Companion", "intellij.platform.builtInServer.impl"})
public final class WebServerPathToFileManager {
    @NotNull
    private final Cache<String, PathInfo> pathToInfoCache;
    private final Cache<VirtualFile, PathInfo> virtualFileToPathInfo;
    @NotNull
    private final Cache<String, Boolean> pathToExistShortTermCache;
    @NotNull
    private final LoadingCache<String, List<SuitableRoot>> parentToSuitableRoot;
    private final Project project;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Cache<String, PathInfo> getPathToInfoCache() {
        return this.pathToInfoCache;
    }

    @NotNull
    public final Cache<String, Boolean> getPathToExistShortTermCache$intellij_platform_builtInServer_impl() {
        return this.pathToExistShortTermCache;
    }

    @NotNull
    public final LoadingCache<String, List<SuitableRoot>> getParentToSuitableRoot$intellij_platform_builtInServer_impl() {
        return this.parentToSuitableRoot;
    }

    private final void clearCache() {
        this.pathToInfoCache.invalidateAll();
        this.virtualFileToPathInfo.invalidateAll();
        this.pathToExistShortTermCache.invalidateAll();
        this.parentToSuitableRoot.invalidateAll();
    }

    @JvmOverloads
    @Nullable
    public final VirtualFile findVirtualFile(@NotNull String path, boolean cacheResult, @NotNull PathQuery pathQuery) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)pathQuery, (String)"pathQuery");
        PathInfo pathInfo = this.getPathInfo(path, cacheResult, pathQuery);
        return pathInfo != null ? pathInfo.getOrResolveVirtualFile() : null;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ VirtualFile findVirtualFile$default(WebServerPathToFileManager webServerPathToFileManager, String string, boolean bl, PathQuery pathQuery, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            pathQuery = WebServerPathToFileManagerKt.getDefaultPathQuery();
        }
        return webServerPathToFileManager.findVirtualFile(string, bl, pathQuery);
    }

    @JvmOverloads
    @Nullable
    public final VirtualFile findVirtualFile(@NotNull String path, boolean cacheResult) {
        return WebServerPathToFileManager.findVirtualFile$default(this, path, cacheResult, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final VirtualFile findVirtualFile(@NotNull String path) {
        return WebServerPathToFileManager.findVirtualFile$default(this, path, false, null, 6, null);
    }

    @JvmOverloads
    @Nullable
    public final PathInfo getPathInfo(@NotNull String path, boolean cacheResult, @NotNull PathQuery pathQuery) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)pathQuery, (String)"pathQuery");
        PathInfo pathInfo = (PathInfo)this.pathToInfoCache.getIfPresent((Object)path);
        if (pathInfo == null || !pathInfo.isValid()) {
            if (Intrinsics.areEqual((Object)((Boolean)this.pathToExistShortTermCache.getIfPresent((Object)path)), (Object)false)) {
                return null;
            }
            pathInfo = this.doFindByRelativePath$intellij_platform_builtInServer_impl(path, pathQuery);
            if (cacheResult) {
                if (pathInfo != null && pathInfo.isValid()) {
                    this.pathToInfoCache.put((Object)path, (Object)pathInfo);
                } else {
                    this.pathToExistShortTermCache.put((Object)path, (Object)false);
                }
            }
        }
        return pathInfo;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ PathInfo getPathInfo$default(WebServerPathToFileManager webServerPathToFileManager, String string, boolean bl, PathQuery pathQuery, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            pathQuery = WebServerPathToFileManagerKt.getDefaultPathQuery();
        }
        return webServerPathToFileManager.getPathInfo(string, bl, pathQuery);
    }

    @JvmOverloads
    @Nullable
    public final PathInfo getPathInfo(@NotNull String path, boolean cacheResult) {
        return WebServerPathToFileManager.getPathInfo$default(this, path, cacheResult, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final PathInfo getPathInfo(@NotNull String path) {
        return WebServerPathToFileManager.getPathInfo$default(this, path, false, null, 6, null);
    }

    @Nullable
    public final String getPath(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        PathInfo pathInfo = this.getPathInfo(file2);
        return pathInfo != null ? pathInfo.getPath() : null;
    }

    @Nullable
    public final PathInfo getPathInfo(@NotNull VirtualFile child) {
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        PathInfo result2 = (PathInfo)this.virtualFileToPathInfo.getIfPresent((Object)child);
        if (result2 == null) {
            block3: {
                PathInfo pathInfo;
                Object[] objectArray = WebServerRootsProvider.Companion.getEP_NAME().getExtensions();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"WebServerRootsProvider.EP_NAME.extensions");
                for (Object file$iv : objectArray) {
                    WebServerRootsProvider it = (WebServerRootsProvider)file$iv;
                    PathInfo result$iv = it.getPathInfo(child, this.project);
                    if (result$iv == null) continue;
                    pathInfo = result$iv;
                    break block3;
                }
                pathInfo = result2 = null;
            }
            if (result2 != null) {
                this.virtualFileToPathInfo.put((Object)child, (Object)result2);
            }
        }
        return result2;
    }

    @Nullable
    public final PathInfo doFindByRelativePath$intellij_platform_builtInServer_impl(@NotNull String path, @NotNull PathQuery pathQuery) {
        PathInfo result2;
        block3: {
            VirtualFile virtualFile;
            PathInfo pathInfo;
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                Intrinsics.checkParameterIsNotNull((Object)pathQuery, (String)"pathQuery");
                Object[] objectArray = WebServerRootsProvider.Companion.getEP_NAME().getExtensions();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"WebServerRootsProvider.EP_NAME.extensions");
                for (Object file$iv : objectArray) {
                    WebServerRootsProvider it = (WebServerRootsProvider)file$iv;
                    PathInfo result$iv = it.resolve(path, this.project, pathQuery);
                    if (result$iv == null) continue;
                    pathInfo = result$iv;
                    break block2;
                }
                pathInfo = null;
            }
            if (pathInfo == null) {
                return null;
            }
            result2 = pathInfo;
            VirtualFile virtualFile2 = result2.getFile();
            if (virtualFile2 == null) break block3;
            VirtualFile it = virtualFile = virtualFile2;
            this.virtualFileToPathInfo.put((Object)it, (Object)result2);
        }
        return result2;
    }

    @NotNull
    public final FileResolver getResolver(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        CharSequence charSequence = path;
        return charSequence.length() == 0 ? (FileResolver)WebServerPathToFileManagerKt.access$getEMPTY_PATH_RESOLVER$p() : (FileResolver)WebServerPathToFileManagerKt.access$getRELATIVE_PATH_RESOLVER$p();
    }

    public WebServerPathToFileManager(@NotNull Application application, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        Cache cache = CacheBuilder.newBuilder().maximumSize(WebServerPathToFileManagerKt.access$getCacheSize$p()).expireAfterAccess(10L, TimeUnit.MINUTES).build();
        if (cache == null) {
            Intrinsics.throwNpe();
        }
        this.pathToInfoCache = cache;
        this.virtualFileToPathInfo = CacheBuilder.newBuilder().maximumSize(WebServerPathToFileManagerKt.access$getCacheSize$p()).expireAfterAccess(11L, TimeUnit.MINUTES).build();
        Cache cache2 = CacheBuilder.newBuilder().maximumSize(WebServerPathToFileManagerKt.access$getCacheSize$p()).expireAfterAccess(5L, TimeUnit.SECONDS).build();
        if (cache2 == null) {
            Intrinsics.throwNpe();
        }
        this.pathToExistShortTermCache = cache2;
        LoadingCache loadingCache = CacheBuilder.newBuilder().maximumSize(WebServerPathToFileManagerKt.access$getCacheSize$p()).expireAfterAccess(10L, TimeUnit.MINUTES).build(CacheLoader.from((Function)((Function)new Function<String, List<? extends SuitableRoot>>(this){
            final /* synthetic */ WebServerPathToFileManager this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SmartList<SuitableRoot> apply(@Nullable String path) {
                void var2_2;
                SmartList suitableRoots = new SmartList();
                String moduleQualifier = null;
                Object object = ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(this){
                    final /* synthetic */ parentToSuitableRoot.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        ModuleManager moduleManager = ModuleManager.getInstance((Project)WebServerPathToFileManager.access$getProject$p(this.this$0.this$0));
                        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                        return (T)moduleManager.getModules();
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"runReadAction { ModuleMa\u2026stance(project).modules }");
                Module[] modules = (Module[])object;
                for (RootProvider rootProvider : RootProvider.values()) {
                    int n = modules.length;
                    for (int i = 0; i < n; ++i) {
                        Module module2;
                        Module module3 = module2 = modules[i];
                        Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
                        if (module3.isDisposed()) continue;
                        for (VirtualFile root : rootProvider.getRoots(ProjectUtil.getRootManager((Module)module2))) {
                            String string = path;
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            if (root.findChild(string) == null) continue;
                            if (moduleQualifier == null) {
                                moduleQualifier = DefaultWebServerRootsProviderKt.getModuleNameQualifier(WebServerPathToFileManager.access$getProject$p(this.this$0), module2);
                            }
                            suitableRoots.add((Object)new SuitableRoot(root, moduleQualifier));
                        }
                    }
                }
                return var2_2;
            }
            {
                this.this$0 = webServerPathToFileManager;
            }
        })));
        if (loadingCache == null) {
            Intrinsics.throwNpe();
        }
        this.parentToSuitableRoot = loadingCache;
        application.getMessageBus().connect((Disposable)this.project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                block0: for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileContentChangeEvent) {
                        Intrinsics.checkExpressionValueIsNotNull((Object)((VFileContentChangeEvent)vFileEvent).getFile(), (String)"event.file");
                        for (WebServerRootsProvider rootsProvider : (WebServerRootsProvider[])WebServerRootsProvider.Companion.getEP_NAME().getExtensions()) {
                            VirtualFile file2;
                            if (!rootsProvider.isClearCacheOnFileContentChanged(file2)) continue;
                            this.clearCache();
                            continue block0;
                        }
                        continue;
                    }
                    this.clearCache();
                    break;
                }
            }
        });
        this.project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.clearCache();
            }
        });
    }

    @NotNull
    public static final /* synthetic */ Project access$getProject$p(WebServerPathToFileManager $this) {
        return $this.project;
    }

    @JvmStatic
    @NotNull
    public static final WebServerPathToFileManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.builtInServer.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final WebServerPathToFileManager getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, WebServerPathToFileManager.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (WebServerPathToFileManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

