/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.AbstractAction;
import com.intellij.cvsSupport2.actions.actionVisibility.CvsActionVisibility;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.cvsstatuses.CvsStatusProvider;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;

public abstract class ActionOnSelectedElement
extends AbstractAction {
    protected static CvsActionVisibility.Condition FILES_HAVE_PARENT_UNDER_CVS = new CvsActionVisibility.Condition(){

        @Override
        public boolean isPerformedOn(CvsContext context) {
            return CvsUtil.filesHaveParentUnderCvs(ActionOnSelectedElement.getAllSelectedFiles(context));
        }
    };
    protected static final CvsActionVisibility.Condition FILES_ARENT_UNDER_CVS = new CvsActionVisibility.Condition(){

        @Override
        public boolean isPerformedOn(CvsContext context) {
            return CvsUtil.filesArentUnderCvs(ActionOnSelectedElement.getAllSelectedFiles(context));
        }
    };
    public static final CvsActionVisibility.Condition FILES_ARE_UNDER_CVS = new CvsActionVisibility.Condition(){

        @Override
        public boolean isPerformedOn(CvsContext context) {
            return CvsUtil.filesAreUnderCvs(ActionOnSelectedElement.getAllSelectedFiles(context));
        }
    };
    public static final CvsActionVisibility.Condition FILES_EXIST_IN_CVS = new CvsActionVisibility.Condition(){

        @Override
        public boolean isPerformedOn(CvsContext context) {
            return CvsUtil.filesExistInCvs(ActionOnSelectedElement.getAllSelectedFiles(context));
        }
    };
    public static final CvsActionVisibility.Condition FILES_ARE_NOT_DELETED = new CvsActionVisibility.Condition(){

        @Override
        public boolean isPerformedOn(CvsContext context) {
            return CvsUtil.filesAreNotDeleted(ActionOnSelectedElement.getAllSelectedFiles(context));
        }
    };
    public static final CvsActionVisibility.Condition FILES_ARE_CHANGED = new CvsActionVisibility.Condition(){

        @Override
        public boolean isPerformedOn(CvsContext context) {
            VirtualFile[] selectedFiles = context.getSelectedFiles();
            if (selectedFiles == null) {
                return false;
            }
            for (int i = 0; i < selectedFiles.length; ++i) {
                VirtualFile selectedFile = selectedFiles[i];
                if (CvsStatusProvider.getStatus(selectedFile) != FileStatus.NOT_CHANGED) continue;
                return ActionOnSelectedElement.documentIsModified(selectedFile);
            }
            return true;
        }
    };
    public static final CvsActionVisibility.Condition FILES_ARE_NOT_IGNORED = new CvsActionVisibility.Condition(){

        @Override
        public boolean isPerformedOn(CvsContext context) {
            VirtualFile[] selectedFiles = context.getSelectedFiles();
            if (selectedFiles == null) {
                return false;
            }
            CvsEntriesManager entriesManager = CvsEntriesManager.getInstance();
            for (VirtualFile selectedFile : selectedFiles) {
                if (!entriesManager.fileIsIgnored(selectedFile)) continue;
                return false;
            }
            return true;
        }
    };
    public static final CvsActionVisibility.Condition FILES_ARE_LOCALLY_ADDED = new CvsActionVisibility.Condition(){

        @Override
        public boolean isPerformedOn(CvsContext context) {
            VirtualFile[] selectedFiles = context.getSelectedFiles();
            if (selectedFiles == null) {
                return false;
            }
            for (VirtualFile selectedFile : selectedFiles) {
                if (CvsUtil.fileIsLocallyAdded(selectedFile)) continue;
                return false;
            }
            return true;
        }
    };
    private final CvsActionVisibility myVisibility = new CvsActionVisibility();

    protected static File[] getAllSelectedFiles(VcsContext context) {
        VirtualFile[] selectedFiles = context.getSelectedFiles();
        Object[] selectedIOFiles = context.getSelectedIOFiles();
        ArrayList<File> result = new ArrayList<File>();
        for (VirtualFile selectedFile : selectedFiles) {
            result.add(CvsVfsUtil.getFileFor(selectedFile));
        }
        if (selectedIOFiles != null) {
            ContainerUtil.addAll(result, (Object[])selectedIOFiles);
        }
        return result.toArray(new File[0]);
    }

    private static boolean documentIsModified(VirtualFile file) {
        boolean[] result = new boolean[]{false};
        ApplicationManager.getApplication().runReadAction(() -> {
            result[0] = FileDocumentManager.getInstance().isFileModified(file);
        });
        return result[0];
    }

    public ActionOnSelectedElement(boolean startLvcsAction) {
        super(startLvcsAction);
    }

    public ActionOnSelectedElement(boolean startLvcsAction, String name, Icon icon) {
        super(startLvcsAction, name, icon);
    }

    public void update(AnActionEvent e) {
        this.getVisibility().applyToEvent(e);
    }

    protected CvsActionVisibility getVisibility() {
        return this.myVisibility;
    }
}

