/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.cvsSupport2.actions.ActionOnSelectedElement;
import com.intellij.cvsSupport2.actions.actionVisibility.CvsActionVisibility;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextWrapper;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.ui.MigrateRootDialog;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.cvsclient.file.FileUtils;

public class MigrateCvsRootAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.actions.MigrateCvsRootAction");
    private final CvsActionVisibility myVisibility = new CvsActionVisibility();

    public MigrateCvsRootAction() {
        this.myVisibility.shouldNotBePerformedOnFile();
        this.myVisibility.addCondition(ActionOnSelectedElement.FILES_ARE_UNDER_CVS);
    }

    public void update(AnActionEvent e) {
        this.myVisibility.applyToEvent(e);
    }

    public void actionPerformed(AnActionEvent event) {
        CvsContext context = CvsContextWrapper.createInstance(event);
        VirtualFile selectedFile = context.getSelectedFile();
        Project project = context.getProject();
        MigrateRootDialog dialog = new MigrateRootDialog(project, selectedFile);
        if (!dialog.showAndGet()) {
            return;
        }
        File directory = dialog.getSelectedDirectory();
        boolean shouldReplaceAllRoots = dialog.shouldReplaceAllRoots();
        ArrayList<File> rootFiles = new ArrayList<File>();
        try {
            if (shouldReplaceAllRoots) {
                MigrateCvsRootAction.collectRootFiles(directory, null, rootFiles);
            } else {
                MigrateCvsRootAction.collectRootFiles(directory, dialog.getCvsRoot(), rootFiles);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return;
        }
        CvsRootConfiguration cvsConfiguration = dialog.getSelectedCvsConfiguration();
        String cvsRoot = cvsConfiguration.getCvsRootAsString();
        for (File file : rootFiles) {
            try {
                FileUtils.writeLine((File)file, (String)cvsRoot);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                break;
            }
        }
        for (File file : rootFiles) {
            CvsVfsUtil.findFileByIoFile(file).refresh(true, false);
        }
        StatusBar.Info.set((String)("Finished migrating CVS root to " + cvsRoot), (Project)project);
    }

    private static void collectRootFiles(File directory, String root, List<File> rootFiles) throws IOException {
        block4: {
            File rootFile = MigrateCvsRootAction.getRootFile(directory);
            if (rootFile != null) {
                rootFiles.add(rootFile);
            }
            try {
                File[] files;
                for (File file2 : files = directory.listFiles(file -> {
                    if (!file.isDirectory()) {
                        return false;
                    }
                    File rootFile1 = MigrateCvsRootAction.getRootFile(file);
                    if (!rootFile1.exists()) {
                        return false;
                    }
                    if (root == null) {
                        return true;
                    }
                    try {
                        String cvsRoot = FileUtils.readLineFromFile((File)rootFile1).trim();
                        return root.equals(cvsRoot);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                })) {
                    MigrateCvsRootAction.collectRootFiles(file2, root, rootFiles);
                }
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof IOException)) break block4;
                throw (IOException)cause;
            }
        }
    }

    private static File getRootFile(File directory) {
        return new File(directory, "CVS/Root");
    }
}

