/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.ResponseType;
import com.intellij.tasks.generic.Selector;
import com.intellij.tasks.generic.SelectorBasedResponseHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="JsonResponseHandler")
public final class JsonPathResponseHandler
extends SelectorBasedResponseHandler {
    private static final Map<Class<?>, String> JSON_TYPES = ContainerUtil.newHashMap((Pair)new Pair(Map.class, (Object)"JSON object"), (Pair[])new Pair[]{new Pair(List.class, (Object)"JSON array"), new Pair(String.class, (Object)"JSON string"), new Pair(Integer.class, (Object)"JSON number"), new Pair(Double.class, (Object)"JSON number"), new Pair(Boolean.class, (Object)"JSON boolean")});
    private final Map<String, JsonPath> myCompiledCache = new HashMap<String, JsonPath>();

    public JsonPathResponseHandler() {
    }

    public JsonPathResponseHandler(GenericRepository repository) {
        super(repository);
    }

    @Nullable
    private Object extractRawValue(@NotNull Selector selector, @NotNull String source) throws Exception {
        Object value;
        if (selector == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)selector.getPath())) {
            return null;
        }
        JsonPath jsonPath = this.lazyCompile(selector.getPath());
        try {
            value = jsonPath.read(source);
        }
        catch (InvalidPathException e) {
            throw new Exception(String.format("JsonPath expression '%s' doesn't match", selector.getPath()), e);
        }
        if (value == null) {
            return null;
        }
        return value;
    }

    @Nullable
    private <T> T extractValueAndCheckType(@NotNull Selector selector, @NotNull String source, Class<T> cls) throws Exception {
        Object value;
        if (selector == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(2);
        }
        if (source == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(3);
        }
        if ((value = this.extractRawValue(selector, source)) == null) {
            return null;
        }
        if (!cls.isInstance(value)) {
            throw new Exception(String.format("JsonPath expression '%s' should match %s. Got '%s' instead", selector.getPath(), JSON_TYPES.get(cls), value));
        }
        Object casted = value;
        return (T)casted;
    }

    @Override
    @NotNull
    protected List<Object> selectTasksList(@NotNull String response, int max) throws Exception {
        List list;
        if (response == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(4);
        }
        if ((list = this.extractValueAndCheckType(this.getSelector("tasks"), response, List.class)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JsonPathResponseHandler.$$$reportNull$$$0(5);
            }
            return list2;
        }
        List<Object> list3 = ContainerUtil.map2List((Collection)list, o -> o.toString()).subList(0, Math.min(list.size(), max));
        if (list3 == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(6);
        }
        return list3;
    }

    @Override
    @Nullable
    protected String selectString(@NotNull Selector selector, @NotNull Object context) throws Exception {
        Object value;
        if (selector == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(7);
        }
        if (context == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(8);
        }
        if ((value = this.extractRawValue(selector, (String)context)) == null) {
            return null;
        }
        if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        throw new Exception(String.format("JsonPath expression '%s' should match string value. Got '%s' instead", selector.getPath(), value));
    }

    @Override
    @Nullable
    protected Boolean selectBoolean(@NotNull Selector selector, @NotNull Object context) throws Exception {
        if (selector == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(9);
        }
        if (context == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(10);
        }
        return this.extractValueAndCheckType(selector, (String)context, Boolean.class);
    }

    @Nullable
    private Long selectLong(@NotNull Selector selector, @NotNull String source) throws Exception {
        if (selector == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(11);
        }
        if (source == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(12);
        }
        return this.extractValueAndCheckType(selector, source, Long.class);
    }

    @NotNull
    private JsonPath lazyCompile(@NotNull String path) throws Exception {
        JsonPath jsonPath;
        if (path == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(13);
        }
        if ((jsonPath = this.myCompiledCache.get(path)) == null) {
            try {
                jsonPath = JsonPath.compile((String)path, (Filter[])new Filter[0]);
                this.myCompiledCache.put(path, jsonPath);
            }
            catch (InvalidPathException e) {
                throw new Exception(String.format("Malformed JsonPath expression '%s'", path));
            }
        }
        JsonPath jsonPath2 = jsonPath;
        if (jsonPath2 == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(14);
        }
        return jsonPath2;
    }

    @Override
    @NotNull
    public ResponseType getResponseType() {
        ResponseType responseType = ResponseType.JSON;
        if (responseType == null) {
            JsonPathResponseHandler.$$$reportNull$$$0(15);
        }
        return responseType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 1: 
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/generic/JsonPathResponseHandler";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/generic/JsonPathResponseHandler";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "selectTasksList";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "lazyCompile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractRawValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractValueAndCheckType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectTasksList";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectString";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectBoolean";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "selectLong";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lazyCompile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

