/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Comparator;

public class AlphaComparator
implements Comparator<NodeDescriptor> {
    public static final AlphaComparator INSTANCE = new AlphaComparator();

    protected AlphaComparator() {
    }

    @Override
    public int compare(NodeDescriptor nodeDescriptor1, NodeDescriptor nodeDescriptor2) {
        int weight2;
        int weight1 = nodeDescriptor1.getWeight();
        if (weight1 != (weight2 = nodeDescriptor2.getWeight())) {
            return weight1 - weight2;
        }
        String s1 = nodeDescriptor1.toString();
        String s2 = nodeDescriptor2.toString();
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return 1;
        }
        Pair<String, String> normalized = AlphaComparator.normalize(s1, s2);
        return StringUtil.naturalCompare((String)((String)normalized.first), (String)((String)normalized.second));
    }

    private static Pair<String, String> normalize(String s1, String s2) {
        int minLen = Math.min(s1.length(), s2.length());
        StringBuilder sb1 = new StringBuilder(s1);
        StringBuilder sb2 = new StringBuilder(s2);
        for (int i = 0; i < minLen; ++i) {
            char ch2;
            char ch1 = s1.charAt(i);
            if (ch1 == (ch2 = sb2.charAt(i)) && ch1 == '-') {
                sb1.setCharAt(i, '_');
                sb2.setCharAt(i, '_');
                continue;
            }
            if (ch1 == '-' && ch2 != '_') {
                sb1.setCharAt(i, '_');
                continue;
            }
            if (ch2 != '-' || ch1 == '_') continue;
            sb2.setCharAt(i, '_');
        }
        s1 = sb1.toString();
        s2 = sb2.toString();
        return Pair.create((Object)s1, (Object)s2);
    }
}

