/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SyntaxHighlighterBase
implements SyntaxHighlighter {
    private static final Logger LOG = Logger.getInstance(SyntaxHighlighterBase.class);
    protected static final TextAttributesKey[] EMPTY = new TextAttributesKey[0];

    @NotNull
    public static TextAttributesKey[] pack(@Nullable TextAttributesKey key) {
        TextAttributesKey[] textAttributesKeyArray;
        if (key == null) {
            textAttributesKeyArray = EMPTY;
        } else {
            TextAttributesKey[] textAttributesKeyArray2 = new TextAttributesKey[1];
            textAttributesKeyArray = textAttributesKeyArray2;
            textAttributesKeyArray2[0] = key;
        }
        if (textAttributesKeyArray == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public static TextAttributesKey[] pack(@Nullable TextAttributesKey key1, @Nullable TextAttributesKey key2) {
        if (key1 == null) {
            TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack(key2);
            if (textAttributesKeyArray == null) {
                SyntaxHighlighterBase.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }
        if (key2 == null) {
            TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack(key1);
            if (textAttributesKeyArray == null) {
                SyntaxHighlighterBase.$$$reportNull$$$0(2);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = new TextAttributesKey[]{key1, key2};
        if (textAttributesKeyArray == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(3);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public static TextAttributesKey[] pack(@NotNull TextAttributesKey[] base, @Nullable TextAttributesKey key) {
        if (base == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(4);
        }
        if (key == null) {
            if (base == null) {
                SyntaxHighlighterBase.$$$reportNull$$$0(5);
            }
            return base;
        }
        TextAttributesKey[] result2 = new TextAttributesKey[base.length + 1];
        System.arraycopy(base, 0, result2, 0, base.length);
        result2[base.length] = key;
        if (result2 == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(6);
        }
        return result2;
    }

    @NotNull
    public static TextAttributesKey[] pack(@Nullable TextAttributesKey key, @NotNull TextAttributesKey[] base) {
        if (base == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(7);
        }
        if (key == null) {
            if (base == null) {
                SyntaxHighlighterBase.$$$reportNull$$$0(8);
            }
            return base;
        }
        TextAttributesKey[] result2 = new TextAttributesKey[base.length + 1];
        System.arraycopy(base, 0, result2, 1, base.length);
        result2[0] = key;
        if (result2 == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(9);
        }
        return result2;
    }

    @NotNull
    public static TextAttributesKey[] pack(@NotNull TextAttributesKey[] base, @Nullable TextAttributesKey t1, @Nullable TextAttributesKey t2) {
        if (base == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(10);
        }
        int add = 0;
        if (t1 != null) {
            ++add;
        }
        if (t2 != null) {
            ++add;
        }
        if (add == 0) {
            if (base == null) {
                SyntaxHighlighterBase.$$$reportNull$$$0(11);
            }
            return base;
        }
        TextAttributesKey[] result2 = new TextAttributesKey[base.length + add];
        add = base.length;
        System.arraycopy(base, 0, result2, 0, base.length);
        if (t1 != null) {
            result2[add++] = t1;
        }
        if (t2 != null) {
            result2[add] = t2;
        }
        if (result2 == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(12);
        }
        return result2;
    }

    protected static void fillMap(@NotNull Map<IElementType, TextAttributesKey> map, @NotNull TokenSet keys, TextAttributesKey value) {
        if (map == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(13);
        }
        if (keys == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(14);
        }
        SyntaxHighlighterBase.fillMap(map, value, keys.getTypes());
    }

    protected static void fillMap(@NotNull Map<IElementType, TextAttributesKey> map, TextAttributesKey value, IElementType ... types) {
        if (map == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(15);
        }
        if (types == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(16);
        }
        for (IElementType type : types) {
            map.put(type, value);
        }
    }

    protected static void safeMap(@NotNull Map<IElementType, TextAttributesKey> map, @NotNull TokenSet keys, @NotNull TextAttributesKey value) {
        if (map == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(17);
        }
        if (keys == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(18);
        }
        if (value == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(19);
        }
        for (IElementType type : keys.getTypes()) {
            SyntaxHighlighterBase.safeMap(map, type, value);
        }
    }

    protected static void safeMap(@NotNull Map<IElementType, TextAttributesKey> map, @NotNull IElementType type, @NotNull TextAttributesKey value) {
        TextAttributesKey oldVal;
        if (map == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(20);
        }
        if (type == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(21);
        }
        if (value == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(22);
        }
        if ((oldVal = map.put(type, value)) != null && !oldVal.equals(value)) {
            LOG.error("Remapping highlighting for \"" + type + "\" val: old=" + oldVal + " new=" + value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/SyntaxHighlighterBase";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "pack";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/SyntaxHighlighterBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "pack";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fillMap";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "safeMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

