/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LibraryKind {
    private final String myKindId;
    private static final Map<String, LibraryKind> ourAllKinds = new HashMap<String, LibraryKind>();

    public LibraryKind(@NotNull @NonNls String kindId) {
        if (kindId == null) {
            LibraryKind.$$$reportNull$$$0(0);
        }
        this.myKindId = kindId;
        if (ourAllKinds.containsKey(kindId)) {
            throw new IllegalArgumentException("Kind " + kindId + " is not unique");
        }
        ourAllKinds.put(kindId, this);
    }

    public final String getKindId() {
        return this.myKindId;
    }

    public String toString() {
        return "LibraryKind:" + this.myKindId;
    }

    public static LibraryKind create(@NotNull @NonNls String kindId) {
        if (kindId == null) {
            LibraryKind.$$$reportNull$$$0(1);
        }
        return new LibraryKind(kindId);
    }

    public static LibraryKind findById(String kindId) {
        return ourAllKinds.get(kindId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "kindId";
        objectArray2[1] = "com/intellij/openapi/roots/libraries/LibraryKind";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

