/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

final class ProgressMonitorInputStream
extends InputStream {
    private final ProgressIndicator indicator;
    private final InputStream in;
    private final double available;
    private long count;

    public ProgressMonitorInputStream(@NotNull ProgressIndicator indicator, @NotNull InputStream in, int length) {
        if (indicator == null) {
            ProgressMonitorInputStream.$$$reportNull$$$0(0);
        }
        if (in == null) {
            ProgressMonitorInputStream.$$$reportNull$$$0(1);
        }
        this.indicator = indicator;
        this.in = in;
        this.available = length;
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        this.updateProgress(c >= 0 ? 1L : 0L);
        return c;
    }

    private void updateProgress(long increment) {
        this.indicator.checkCanceled();
        if (increment > 0L) {
            this.count += increment;
            this.indicator.setFraction((double)this.count / this.available);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.in.read(b);
        this.updateProgress(r);
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        this.updateProgress(r);
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        long r = this.in.skip(n);
        this.updateProgress(r);
        return r;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "indicator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "in";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/io/ProgressMonitorInputStream";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

