/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicatePropertyInspection;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Processors;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class DuplicatePropertyInspection
extends GlobalSimpleInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.DuplicatePropertyInspection");
    public boolean CURRENT_FILE = true;
    public boolean MODULE_WITH_DEPENDENCIES = false;
    public boolean CHECK_DUPLICATE_VALUES = true;
    public boolean CHECK_DUPLICATE_KEYS = true;
    public boolean CHECK_DUPLICATE_KEYS_WITH_DIFFERENT_VALUES = true;

    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (file == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(1);
        }
        if (problemsHolder == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(2);
        }
        if (globalContext == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(3);
        }
        if (problemDescriptionsProcessor == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(4);
        }
        this.checkFile(file, manager, (GlobalInspectionContextBase)globalContext, globalContext.getRefManager(), problemDescriptionsProcessor);
    }

    private static void surroundWithHref(StringBuffer anchor, PsiElement element, boolean isValue) {
        if (element != null) {
            PsiElement elementToLink;
            PsiElement parent = element.getParent();
            PsiElement psiElement = elementToLink = isValue ? parent.getFirstChild() : parent.getLastChild();
            if (elementToLink != null) {
                HTMLComposer.appendAfterHeaderIndention((StringBuffer)anchor);
                HTMLComposer.appendAfterHeaderIndention((StringBuffer)anchor);
                anchor.append("<a HREF=\"");
                try {
                    VirtualFile virtualFile;
                    PsiFile file = element.getContainingFile();
                    if (file != null && (virtualFile = file.getVirtualFile()) != null) {
                        anchor.append(new URL(virtualFile.getUrl() + "#" + elementToLink.getTextRange().getStartOffset()));
                    }
                }
                catch (MalformedURLException e) {
                    LOG.error((Throwable)e);
                }
                anchor.append("\">");
                anchor.append(elementToLink.getText().replaceAll("\\$", "\\\\\\$"));
                anchor.append("</a>");
                DuplicatePropertyInspection.compoundLineLink(anchor, element);
                anchor.append("<br>");
            }
        } else {
            anchor.append("<font style=\"font-family:verdana; font-weight:bold; color:#FF0000\";>");
            anchor.append(InspectionsBundle.message((String)"inspection.export.results.invalidated.item", (Object[])new Object[0]));
            anchor.append("</font>");
        }
    }

    private static void compoundLineLink(StringBuffer lineAnchor, PsiElement psiElement) {
        VirtualFile vFile;
        PsiFile file = psiElement.getContainingFile();
        if (file != null && (vFile = file.getVirtualFile()) != null) {
            Document doc = FileDocumentManager.getInstance().getDocument(vFile);
            int lineNumber = doc.getLineNumber(psiElement.getTextOffset()) + 1;
            lineAnchor.append(" ").append(InspectionsBundle.message((String)"inspection.export.results.at.line", (Object[])new Object[0])).append(" ");
            lineAnchor.append("<a HREF=\"");
            try {
                int offset = doc.getLineStartOffset(lineNumber - 1);
                offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)offset, (String)" \t");
                lineAnchor.append(new URL(vFile.getUrl() + "#" + offset));
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
            lineAnchor.append("\">");
            lineAnchor.append(Integer.toString(lineNumber));
            lineAnchor.append("</a>");
        }
    }

    private void checkFile(PsiFile file, InspectionManager manager, GlobalInspectionContextBase context, RefManager refManager, ProblemDescriptionsProcessor processor) {
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        if (!context.isToCheckFile(file, (InspectionProfileEntry)this) || SuppressionUtil.inspectionResultSuppressed((PsiElement)file, (InspectionProfileEntry)this)) {
            return;
        }
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)file.getProject());
        PropertiesFile propertiesFile = (PropertiesFile)file;
        List<IProperty> properties = propertiesFile.getProperties();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return;
        }
        GlobalSearchScope scope = this.CURRENT_FILE ? GlobalSearchScope.fileScope((PsiFile)file) : (this.MODULE_WITH_DEPENDENCIES ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.projectScope((Project)file.getProject()));
        Map processedValueToFiles = Collections.synchronizedMap(new HashMap());
        Map processedKeyToFiles = Collections.synchronizedMap(new HashMap());
        ProgressIndicator original = ProgressManager.getInstance().getProgressIndicator();
        ProgressWrapper progress = ProgressWrapper.wrap((ProgressIndicator)original);
        ProgressManager.getInstance().runProcess(() -> this.lambda$checkFile$1(properties, (ProgressIndicator)progress, original, processedValueToFiles, processedKeyToFiles, searchHelper, scope, manager, file, processor, refManager), (ProgressIndicator)progress);
    }

    private static void processTextUsages(Map<String, Set<PsiFile>> processedTextToFiles, String text, Map<String, Set<PsiFile>> processedFoundTextToFiles, PsiSearchHelper searchHelper, GlobalSearchScope scope) {
        if (!processedTextToFiles.containsKey(text)) {
            if (processedFoundTextToFiles.containsKey(text)) {
                Set<PsiFile> filesWithValue = processedFoundTextToFiles.get(text);
                processedTextToFiles.put(text, filesWithValue);
            } else {
                HashSet<PsiFile> resultFiles = new HashSet<PsiFile>();
                DuplicatePropertyInspection.findFilesWithText(text, searchHelper, scope, resultFiles);
                if (resultFiles.isEmpty()) {
                    return;
                }
                processedTextToFiles.put(text, resultFiles);
            }
        }
    }

    private static void prepareDuplicateValuesByFile(Map<String, Set<PsiFile>> valueToFiles, InspectionManager manager, List<ProblemDescriptor> problemDescriptors, PsiFile psiFile, ProgressIndicator progress) {
        for (String value : valueToFiles.keySet()) {
            if (progress != null) {
                progress.setText2(InspectionsBundle.message((String)"duplicate.property.value.progress.indicator.text", (Object[])new Object[]{value}));
                progress.checkCanceled();
            }
            if (value.length() == 0) continue;
            StringSearcher searcher = new StringSearcher(value, true, true);
            StringBuffer message = new StringBuffer();
            int[] duplicatesCount = new int[]{0};
            Set<PsiFile> psiFilesWithDuplicates = valueToFiles.get(value);
            for (PsiFile file : psiFilesWithDuplicates) {
                CharSequence text = file.getViewProvider().getContents();
                LowLevelSearchUtil.processTextOccurrences((CharSequence)text, (int)0, (int)text.length(), (StringSearcher)searcher, (ProgressIndicator)progress, offset -> {
                    Property property;
                    PsiElement element = file.findElementAt(offset);
                    if (element != null && element.getParent() instanceof Property && Comparing.equal((String)(property = (Property)element.getParent()).getValue(), (String)value) && element.getStartOffsetInParent() != 0) {
                        if (duplicatesCount[0] == 0) {
                            message.append(InspectionsBundle.message((String)"duplicate.property.value.problem.descriptor", (Object[])new Object[]{property.getValue()}));
                        }
                        DuplicatePropertyInspection.surroundWithHref(message, element, true);
                        duplicatesCount[0] = duplicatesCount[0] + 1;
                    }
                    return true;
                });
            }
            if (duplicatesCount[0] <= 1) continue;
            problemDescriptors.add(manager.createProblemDescriptor((PsiElement)psiFile, message.toString(), false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
    }

    private void prepareDuplicateKeysByFile(Map<String, Set<PsiFile>> keyToFiles, InspectionManager manager, Map<String, Set<String>> keyToValues, List<ProblemDescriptor> problemDescriptors, PsiFile psiFile, ProgressIndicator progress) {
        for (String key : keyToFiles.keySet()) {
            if (progress != null) {
                progress.setText2(InspectionsBundle.message((String)"duplicate.property.key.progress.indicator.text", (Object[])new Object[]{key}));
                if (progress.isCanceled()) {
                    throw new ProcessCanceledException();
                }
            }
            StringBuffer message = new StringBuffer();
            int duplicatesCount = 0;
            Set<PsiFile> psiFilesWithDuplicates = keyToFiles.get(key);
            for (PsiFile file : psiFilesWithDuplicates) {
                if (!(file instanceof PropertiesFile)) continue;
                PropertiesFile propertiesFile = (PropertiesFile)file;
                List<IProperty> propertiesByKey = propertiesFile.findPropertiesByKey(key);
                for (IProperty property : propertiesByKey) {
                    if (duplicatesCount == 0) {
                        message.append(InspectionsBundle.message((String)"duplicate.property.key.problem.descriptor", (Object[])new Object[]{key}));
                    }
                    DuplicatePropertyInspection.surroundWithHref(message, property.getPsiElement().getFirstChild(), false);
                    ++duplicatesCount;
                    Set<String> values = keyToValues.get(key);
                    if (values == null) {
                        values = new HashSet<String>();
                        keyToValues.put(key, values);
                    }
                    values.add(property.getValue());
                }
            }
            if (duplicatesCount <= true || !this.CHECK_DUPLICATE_KEYS) continue;
            problemDescriptors.add(manager.createProblemDescriptor((PsiElement)psiFile, message.toString(), false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
    }

    private static void processDuplicateKeysWithDifferentValues(Map<String, Set<String>> keyToDifferentValues, Map<String, Set<PsiFile>> keyToFiles, List<ProblemDescriptor> problemDescriptors, InspectionManager manager, PsiFile psiFile, ProgressIndicator progress) {
        for (String key : keyToDifferentValues.keySet()) {
            Set<String> values;
            if (progress != null) {
                progress.setText2(InspectionsBundle.message((String)"duplicate.property.diff.key.progress.indicator.text", (Object[])new Object[]{key}));
                if (progress.isCanceled()) {
                    throw new ProcessCanceledException();
                }
            }
            if ((values = keyToDifferentValues.get(key)) == null || values.size() < 2) {
                keyToFiles.remove(key);
                continue;
            }
            StringBuffer message = new StringBuffer();
            Set<PsiFile> psiFiles = keyToFiles.get(key);
            boolean firstUsage = true;
            for (PsiFile file : psiFiles) {
                if (!(file instanceof PropertiesFile)) continue;
                PropertiesFile propertiesFile = (PropertiesFile)file;
                List<IProperty> propertiesByKey = propertiesFile.findPropertiesByKey(key);
                for (IProperty property : propertiesByKey) {
                    if (firstUsage) {
                        message.append(InspectionsBundle.message((String)"duplicate.property.diff.key.problem.descriptor", (Object[])new Object[]{key}));
                        firstUsage = false;
                    }
                    DuplicatePropertyInspection.surroundWithHref(message, property.getPsiElement().getFirstChild(), false);
                }
            }
            problemDescriptors.add(manager.createProblemDescriptor((PsiElement)psiFile, message.toString(), false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
    }

    private static void findFilesWithText(String stringToFind, PsiSearchHelper searchHelper, GlobalSearchScope scope, Set<PsiFile> resultFiles) {
        List words = StringUtil.getWordsIn((String)stringToFind);
        if (words.isEmpty()) {
            return;
        }
        Collections.sort(words, (o1, o2) -> o2.length() - o1.length());
        for (String word : words) {
            THashSet files = new THashSet();
            searchHelper.processAllFilesWithWord(word, scope, Processors.cancelableCollectProcessor((Collection)files), true);
            if (resultFiles.isEmpty()) {
                resultFiles.addAll((Collection<PsiFile>)files);
            } else {
                resultFiles.retainAll((Collection<?>)files);
            }
            if (!resultFiles.isEmpty()) continue;
            return;
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"duplicate.property.display.name", (Object[])new Object[0]);
        if (string == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.properties.files", (Object[])new Object[0]);
        if (string == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("DuplicatePropertyInspection" == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(7);
        }
        return "DuplicatePropertyInspection";
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().myWholePanel;
    }

    private /* synthetic */ void lambda$checkFile$1(List properties, ProgressIndicator progress, ProgressIndicator original, Map processedValueToFiles, Map processedKeyToFiles, PsiSearchHelper searchHelper, GlobalSearchScope scope, InspectionManager manager, PsiFile file, ProblemDescriptionsProcessor processor, RefManager refManager) {
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(properties, progress, property -> {
            if (original != null) {
                if (original.isCanceled()) {
                    return false;
                }
                original.setText2(PropertiesBundle.message("searching.for.property.key.progress.text", property.getUnescapedKey()));
            }
            DuplicatePropertyInspection.processTextUsages(processedValueToFiles, property.getValue(), processedKeyToFiles, searchHelper, scope);
            DuplicatePropertyInspection.processTextUsages(processedKeyToFiles, property.getUnescapedKey(), processedValueToFiles, searchHelper, scope);
            return true;
        })) {
            throw new ProcessCanceledException();
        }
        ArrayList<ProblemDescriptor> problemDescriptors = new ArrayList<ProblemDescriptor>();
        HashMap<String, Set<String>> keyToDifferentValues = new HashMap<String, Set<String>>();
        if (this.CHECK_DUPLICATE_KEYS || this.CHECK_DUPLICATE_KEYS_WITH_DIFFERENT_VALUES) {
            this.prepareDuplicateKeysByFile(processedKeyToFiles, manager, keyToDifferentValues, problemDescriptors, file, original);
        }
        if (this.CHECK_DUPLICATE_VALUES) {
            DuplicatePropertyInspection.prepareDuplicateValuesByFile(processedValueToFiles, manager, problemDescriptors, file, original);
        }
        if (this.CHECK_DUPLICATE_KEYS_WITH_DIFFERENT_VALUES) {
            DuplicatePropertyInspection.processDuplicateKeysWithDifferentValues(keyToDifferentValues, processedKeyToFiles, problemDescriptors, manager, file, original);
        }
        if (!problemDescriptors.isEmpty()) {
            processor.addProblemElement((RefEntity)refManager.getReference((PsiElement)file), (CommonProblemDescriptor[])problemDescriptors.toArray(ProblemDescriptor.EMPTY_ARRAY));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/duplicatePropertyInspection/DuplicatePropertyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/duplicatePropertyInspection/DuplicatePropertyInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JRadioButton myFileScope;
        private JRadioButton myModuleScope;
        private JRadioButton myProjectScope;
        private JCheckBox myDuplicateValues;
        private JCheckBox myDuplicateKeys;
        private JCheckBox myDuplicateBoth;
        private JPanel myWholePanel;

        OptionsPanel() {
            this.$$$setupUI$$$();
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.myFileScope);
            buttonGroup.add(this.myModuleScope);
            buttonGroup.add(this.myProjectScope);
            this.myFileScope.setSelected(DuplicatePropertyInspection.this.CURRENT_FILE);
            this.myModuleScope.setSelected(DuplicatePropertyInspection.this.MODULE_WITH_DEPENDENCIES);
            this.myProjectScope.setSelected(!DuplicatePropertyInspection.this.CURRENT_FILE && !DuplicatePropertyInspection.this.MODULE_WITH_DEPENDENCIES);
            this.myFileScope.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DuplicatePropertyInspection.this.CURRENT_FILE = OptionsPanel.this.myFileScope.isSelected();
                }
            });
            this.myModuleScope.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DuplicatePropertyInspection.this.MODULE_WITH_DEPENDENCIES = OptionsPanel.this.myModuleScope.isSelected();
                    if (DuplicatePropertyInspection.this.MODULE_WITH_DEPENDENCIES) {
                        DuplicatePropertyInspection.this.CURRENT_FILE = false;
                    }
                }
            });
            this.myProjectScope.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (OptionsPanel.this.myProjectScope.isSelected()) {
                        DuplicatePropertyInspection.this.CURRENT_FILE = false;
                        DuplicatePropertyInspection.this.MODULE_WITH_DEPENDENCIES = false;
                    }
                }
            });
            this.myDuplicateKeys.setSelected(DuplicatePropertyInspection.this.CHECK_DUPLICATE_KEYS);
            this.myDuplicateValues.setSelected(DuplicatePropertyInspection.this.CHECK_DUPLICATE_VALUES);
            this.myDuplicateBoth.setSelected(DuplicatePropertyInspection.this.CHECK_DUPLICATE_KEYS_WITH_DIFFERENT_VALUES);
            this.myDuplicateKeys.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DuplicatePropertyInspection.this.CHECK_DUPLICATE_KEYS = OptionsPanel.this.myDuplicateKeys.isSelected();
                }
            });
            this.myDuplicateValues.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DuplicatePropertyInspection.this.CHECK_DUPLICATE_VALUES = OptionsPanel.this.myDuplicateValues.isSelected();
                }
            });
            this.myDuplicateBoth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DuplicatePropertyInspection.this.CHECK_DUPLICATE_KEYS_WITH_DIFFERENT_VALUES = OptionsPanel.this.myDuplicateBoth.isSelected();
                }
            });
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JRadioButton jRadioButton;
            JRadioButton jRadioButton2;
            JRadioButton jRadioButton3;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myProjectScope = jRadioButton3 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/InspectionsBundle").getString("duplicate.property.project.scope.option"));
            jPanel2.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myFileScope = jRadioButton2 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/InspectionsBundle").getString("duplicate.property.file.scope.option"));
            jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myModuleScope = jRadioButton = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/InspectionsBundle").getString("duplicate.property.module.scope.option"));
            jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(20, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myDuplicateKeys = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/InspectionsBundle").getString("duplicate.property.key.option"));
            jPanel3.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDuplicateValues = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/InspectionsBundle").getString("duplicate.property.value.option"));
            jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDuplicateBoth = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/InspectionsBundle").getString("duplicate.property.diff.key.option"));
            jPanel3.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

