/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.customizeActions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class CombinePropertiesFilesAction
extends AnAction {
    public CombinePropertiesFilesAction() {
        super(PropertiesBundle.message("combine.properties.files.title", new Object[0]), null, AllIcons.FileTypes.Properties);
    }

    public void actionPerformed(AnActionEvent e) {
        String newBaseName;
        List<PropertiesFile> initialPropertiesFiles = CombinePropertiesFilesAction.getPropertiesFiles(e);
        ArrayList<PropertiesFile> propertiesFiles = initialPropertiesFiles == null ? new ArrayList<PropertiesFile>() : new ArrayList<PropertiesFile>(initialPropertiesFiles);
        List<ResourceBundle> resourceBundles = CombinePropertiesFilesAction.getResourceBundles(e);
        if (resourceBundles != null) {
            for (ResourceBundle bundle : resourceBundles) {
                propertiesFiles.addAll(bundle.getPropertiesFiles());
            }
        }
        if ((newBaseName = Messages.showInputDialog((Project)((PropertiesFile)propertiesFiles.get(0)).getProject(), (String)PropertiesBundle.message("combine.properties.files.prompt.text", new Object[0]), (String)PropertiesBundle.message("combine.properties.files.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)PropertiesUtil.getDefaultBaseName(propertiesFiles), (InputValidator)new MyInputValidator(propertiesFiles))) != null) {
            Project project = ((PropertiesFile)propertiesFiles.get(0)).getProject();
            HashSet<ResourceBundle> uniqueBundlesToDissociate = new HashSet<ResourceBundle>();
            for (PropertiesFile propertiesFile : propertiesFiles) {
                ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
                if (resourceBundle.getPropertiesFiles().size() == 1) continue;
                uniqueBundlesToDissociate.add(resourceBundle);
            }
            ResourceBundleManager resourceBundleManager = ResourceBundleManager.getInstance(project);
            for (ResourceBundle resourceBundle : uniqueBundlesToDissociate) {
                resourceBundleManager.dissociateResourceBundle(resourceBundle);
            }
            ResourceBundle resourceBundle = resourceBundleManager.combineToResourceBundleAndGet(propertiesFiles, newBaseName);
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new ResourceBundleAsVirtualFile(resourceBundle), true);
            ProjectView.getInstance((Project)project).refresh();
        }
    }

    public void update(AnActionEvent e) {
        List<PropertiesFile> propertiesFiles = CombinePropertiesFilesAction.getPropertiesFiles(e);
        List<ResourceBundle> resourceBundles = CombinePropertiesFilesAction.getResourceBundles(e);
        int elementCount = 0;
        if (propertiesFiles != null) {
            elementCount += propertiesFiles.size();
        }
        if (resourceBundles != null) {
            elementCount += resourceBundles.size();
        }
        e.getPresentation().setEnabledAndVisible(elementCount > 1);
    }

    @Nullable
    private static List<ResourceBundle> getResourceBundles(AnActionEvent e) {
        Object[] resourceBundles = (ResourceBundle[])e.getData(ResourceBundle.ARRAY_DATA_KEY);
        return resourceBundles == null ? null : ContainerUtil.newArrayList((Object[])resourceBundles);
    }

    @Nullable
    private static List<PropertiesFile> getPropertiesFiles(AnActionEvent e) {
        PsiElement[] psiElements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY);
        if (psiElements == null || psiElements.length == 0) {
            return null;
        }
        ArrayList<PropertiesFile> files = new ArrayList<PropertiesFile>(psiElements.length);
        for (PsiElement psiElement : psiElements) {
            PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(psiElement);
            if (propertiesFile == null) {
                return null;
            }
            files.add(propertiesFile);
        }
        return files;
    }

    public boolean isDumbAware() {
        return true;
    }

    private static class MyInputValidator
    implements InputValidatorEx {
        private final List<PropertiesFile> myPropertiesFiles;

        private MyInputValidator(List<PropertiesFile> propertiesFiles) {
            this.myPropertiesFiles = propertiesFiles;
        }

        public boolean checkInput(String newBaseName) {
            return !newBaseName.isEmpty() && this.checkBaseName(newBaseName) == null;
        }

        public boolean canClose(String newBaseName) {
            return true;
        }

        @Nullable
        public String getErrorText(String inputString) {
            return this.checkInput(inputString) ? null : String.format("Base name must be valid for file '%s'", this.checkBaseName(inputString).getFailedFile());
        }

        @Nullable
        private BaseNameError checkBaseName(String baseNameCandidate) {
            for (PropertiesFile propertiesFile : this.myPropertiesFiles) {
                String name = propertiesFile.getVirtualFile().getName();
                if (name.startsWith(baseNameCandidate) && (name.length() == baseNameCandidate.length() || PropertiesUtil.BASE_NAME_BORDER_CHAR.contains(Character.valueOf(name.charAt(baseNameCandidate.length()))))) continue;
                return new BaseNameError(name);
            }
            return null;
        }

        private static class BaseNameError {
            private final String myFailedFile;

            private BaseNameError(String failedFile) {
                this.myFailedFile = failedFile;
            }

            public String getFailedFile() {
                return this.myFailedFile;
            }
        }
    }
}

