/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.Utils;
import org.apache.solr.util.IdUtils;

public class TriggerEvent
implements MapWriter {
    public static final String IGNORED = "ignored";
    public static final String COOLDOWN = "cooldown";
    public static final String REPLAYING = "replaying";
    public static final String NODE_NAMES = "nodeNames";
    public static final String EVENT_TIMES = "eventTimes";
    public static final String REQUESTED_OPS = "requestedOps";
    public static final String UNSUPPORTED_OPS = "unsupportedOps";
    protected final String id;
    protected final String source;
    protected final long eventTime;
    protected final TriggerEventType eventType;
    protected final Map<String, Object> properties = new HashMap<String, Object>();
    protected final boolean ignored;

    public TriggerEvent(TriggerEventType eventType, String source, long eventTime, Map<String, Object> properties) {
        this(IdUtils.timeRandomId(eventTime), eventType, source, eventTime, properties, false);
    }

    public TriggerEvent(TriggerEventType eventType, String source, long eventTime, Map<String, Object> properties, boolean ignored) {
        this(IdUtils.timeRandomId(eventTime), eventType, source, eventTime, properties, ignored);
    }

    public TriggerEvent(String id, TriggerEventType eventType, String source, long eventTime, Map<String, Object> properties) {
        this(id, eventType, source, eventTime, properties, false);
    }

    public TriggerEvent(String id, TriggerEventType eventType, String source, long eventTime, Map<String, Object> properties, boolean ignored) {
        this.id = id;
        this.eventType = eventType;
        this.source = source;
        this.eventTime = eventTime;
        if (properties != null) {
            this.properties.putAll(properties);
        }
        this.ignored = ignored;
    }

    public String getId() {
        return this.id;
    }

    public String getSource() {
        return this.source;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Object getProperty(String name, Object defaultValue) {
        Object v = this.properties.get(name);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public TriggerEventType getEventType() {
        return this.eventType;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put("id", (Object)this.id);
        ew.put("source", (Object)this.source);
        ew.put("eventTime", this.eventTime);
        ew.put("eventType", (Object)this.eventType.toString());
        ew.put("properties", this.properties);
        if (this.ignored) {
            ew.put(IGNORED, true);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerEvent that = (TriggerEvent)o;
        if (this.eventTime != that.eventTime) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        if (this.eventType != that.eventType) {
            return false;
        }
        if (this.ignored != that.ignored) {
            return false;
        }
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + (int)(this.eventTime ^ this.eventTime >>> 32);
        result = 31 * result + this.eventType.hashCode();
        result = 31 * result + this.properties.hashCode();
        result = 31 * result + Boolean.hashCode(this.ignored);
        return result;
    }

    public String toString() {
        return Utils.toJSONString((Object)this);
    }

    public static TriggerEvent fromMap(Map<String, Object> map) {
        String id = (String)map.get("id");
        String source = (String)map.get("source");
        long eventTime = ((Number)map.get("eventTime")).longValue();
        TriggerEventType eventType = TriggerEventType.valueOf((String)((String)map.get("eventType")));
        Map properties = (Map)map.get("properties");
        TriggerEvent.fixOps(REQUESTED_OPS, properties);
        TriggerEvent.fixOps(UNSUPPORTED_OPS, properties);
        TriggerEvent res = new TriggerEvent(id, eventType, source, eventTime, properties);
        return res;
    }

    public static void fixOps(String type, Map<String, Object> properties) {
        List ops = (List)properties.get(type);
        if (ops != null && !ops.isEmpty()) {
            for (int i = 0; i < ops.size(); ++i) {
                Op op;
                Object o = ops.get(i);
                if (!(o instanceof Map) || (op = Op.fromMap((Map)o)) == null) continue;
                ops.set(i, op);
            }
        }
    }

    public static final class Op
    implements MapWriter {
        private final CollectionParams.CollectionAction action;
        private final EnumMap<Suggester.Hint, Object> hints = new EnumMap(Suggester.Hint.class);

        public Op(CollectionParams.CollectionAction action) {
            this.action = action;
        }

        public Op(CollectionParams.CollectionAction action, Suggester.Hint hint, Object hintValue) {
            this.action = action;
            this.addHint(hint, hintValue);
        }

        public void addHint(Suggester.Hint hint, Object value) {
            hint.validator.accept(value);
            if (hint.multiValued) {
                List<Object> values = value instanceof Collection ? (List<Object>)value : Collections.singletonList(value);
                ((Set)this.hints.computeIfAbsent(hint, h -> new LinkedHashSet())).addAll(values);
            } else {
                this.hints.put(hint, (Object)(value == null ? null : String.valueOf(value)));
            }
        }

        public CollectionParams.CollectionAction getAction() {
            return this.action;
        }

        public EnumMap<Suggester.Hint, Object> getHints() {
            return this.hints;
        }

        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.put("action", (Object)this.action);
            ew.put("hints", this.hints);
        }

        public static Op fromMap(Map<String, Object> map) {
            if (!map.containsKey("action")) {
                return null;
            }
            CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)String.valueOf(map.get("action")));
            if (action == null) {
                return null;
            }
            Op op = new Op(action);
            Map hints = (Map)map.get("hints");
            if (hints != null && !hints.isEmpty()) {
                hints.forEach((k, v) -> {
                    Suggester.Hint h = Suggester.Hint.get((String)k.toString());
                    if (h == null) {
                        return;
                    }
                    if (!(v instanceof Collection)) {
                        v = Collections.singletonList(v);
                    }
                    ((Collection)v).forEach(vv -> {
                        Pair p;
                        Map m;
                        if (vv instanceof Map && (m = (Map)vv).containsKey("first") && m.containsKey("second") && (p = Pair.parse((Map)m)) != null) {
                            op.addHint(h, p);
                            return;
                        }
                        op.addHint(h, vv);
                    });
                });
            }
            return op;
        }

        public String toString() {
            return "Op{action=" + this.action + ", hints=" + this.hints + '}';
        }
    }
}

