/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.rrd;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.solr.metrics.rrd.SolrRrdBackendFactory;
import org.rrd4j.core.RrdByteArrayBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrRrdBackend
extends RrdByteArrayBackend
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrRrdBackendFactory factory;
    private final boolean readOnly;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile boolean dirty = false;
    private volatile boolean closed = false;
    private volatile long lastModifiedTime;

    public SolrRrdBackend(String path, boolean readOnly, SolrRrdBackendFactory factory) {
        super(path);
        this.factory = factory;
        this.lastModifiedTime = TimeUnit.MILLISECONDS.convert(factory.getTimeSource().getEpochTimeNs(), TimeUnit.NANOSECONDS);
        try {
            SyncData syncData = factory.getData(path);
            if (syncData != null) {
                this.buffer = syncData.data;
                this.lastModifiedTime = syncData.timestamp;
            }
        }
        catch (IOException e) {
            log.warn("Exception retrieving data from " + path + ", store will be readOnly", (Throwable)e);
            readOnly = true;
        }
        this.readOnly = readOnly;
    }

    public SolrRrdBackend(SolrRrdBackend other) {
        super(other.getPath());
        this.readOnly = true;
        this.factory = null;
        this.lastModifiedTime = other.lastModifiedTime;
        byte[] otherBuffer = other.buffer;
        this.buffer = new byte[otherBuffer.length];
        System.arraycopy(otherBuffer, 0, this.buffer, 0, otherBuffer.length);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(long offset, byte[] bytes) throws IOException {
        if (this.readOnly || this.closed) {
            return;
        }
        this.lock.lock();
        try {
            super.write(offset, bytes);
            this.lastModifiedTime = TimeUnit.MILLISECONDS.convert(this.factory.getTimeSource().getEpochTimeNs(), TimeUnit.NANOSECONDS);
            this.dirty = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public SyncData getSyncData() {
        if (this.readOnly || this.closed) {
            return null;
        }
        if (!this.dirty) {
            return null;
        }
        this.lock.lock();
        try {
            byte[] bufferCopy = new byte[this.buffer.length];
            System.arraycopy(this.buffer, 0, bufferCopy, 0, this.buffer.length);
            SyncData syncData = new SyncData(bufferCopy, this.lastModifiedTime);
            return syncData;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void markClean() {
        this.dirty = false;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
        if (this.factory != null) {
            this.factory.unregisterBackend(this.getPath());
        }
    }

    public static final class SyncData {
        public byte[] data;
        public long timestamp;

        public SyncData(byte[] data, long timestamp) {
            this.data = data;
            this.timestamp = timestamp;
        }
    }
}

