/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Paint;
import org.rrd4j.data.DataProcessor;
import org.rrd4j.graph.Area;
import org.rrd4j.graph.Line;
import org.rrd4j.graph.SourcedPlotElement;

class Stack
extends SourcedPlotElement {
    private final SourcedPlotElement parent;

    Stack(SourcedPlotElement parent, String srcName, Paint color) {
        super(srcName, color);
        this.parent = parent;
    }

    @Override
    void assignValues(DataProcessor dproc) {
        double[] parentValues = this.parent.getValues();
        double[] procValues = dproc.getValues(this.srcName);
        this.values = new double[procValues.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Double.isNaN(parentValues[i]) ? procValues[i] : (Double.isNaN(procValues[i]) ? parentValues[i] : parentValues[i] + procValues[i]);
        }
    }

    float getParentLineWidth() {
        if (this.parent instanceof Line) {
            return ((Line)this.parent).stroke.getLineWidth();
        }
        if (this.parent instanceof Area) {
            return -1.0f;
        }
        return ((Stack)this.parent).getParentLineWidth();
    }

    @Override
    Paint getParentColor() {
        return this.parent.color;
    }
}

