/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.encoding;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import nu.validator.encoding.Encoding;
import nu.validator.encoding.InfallibleSingleByteDecoder;

public final class FallibleSingleByteDecoder
extends InfallibleSingleByteDecoder {
    public FallibleSingleByteDecoder(Encoding cs, char[] upperHalf) {
        super(cs, upperHalf);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        if (!this.report) {
            return super.decodeLoop(in, out);
        }
        while (in.hasRemaining()) {
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            byte b = in.get();
            if (b >= 0) {
                out.put((char)b);
                continue;
            }
            char mapped = this.upperHalf[b + 128];
            if (mapped == '\ufffd') {
                in.position(in.position() - 1);
                return CoderResult.malformedForLength(1);
            }
            out.put(mapped);
        }
        return CoderResult.UNDERFLOW;
    }
}

