/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.ImageDataRenderer;

public abstract class FilterEffect
extends Effect {
    protected FilterEffect() {
    }

    protected FilterEffect(Effect effect) {
        super(effect);
    }

    protected FilterEffect(Effect effect, Effect effect2) {
        super(effect, effect2);
    }

    public boolean operatesInUserSpace() {
        return false;
    }

    @Override
    public BaseBounds getBounds(BaseTransform baseTransform, Effect effect) {
        BaseBounds baseBounds;
        int n = this.getNumInputs();
        BaseTransform baseTransform2 = baseTransform;
        if (this.operatesInUserSpace()) {
            baseTransform2 = BaseTransform.IDENTITY_TRANSFORM;
        }
        if (n == 1) {
            Effect effect2 = this.getDefaultedInput(0, effect);
            baseBounds = effect2.getBounds(baseTransform2, effect);
        } else {
            BaseBounds[] baseBoundsArray = new BaseBounds[n];
            for (int i = 0; i < n; ++i) {
                Effect effect3 = this.getDefaultedInput(i, effect);
                baseBoundsArray[i] = effect3.getBounds(baseTransform2, effect);
            }
            baseBounds = FilterEffect.combineBounds(baseBoundsArray);
        }
        if (baseTransform2 != baseTransform) {
            baseBounds = FilterEffect.transformBounds(baseTransform, baseBounds);
        }
        return baseBounds;
    }

    protected abstract Rectangle getInputClip(int var1, BaseTransform var2, Rectangle var3);

    protected static Rectangle untransformClip(BaseTransform baseTransform, Rectangle rectangle) {
        if (baseTransform.isIdentity() || rectangle == null || rectangle.isEmpty()) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle();
        if (baseTransform.isTranslateOrIdentity()) {
            rectangle2.setBounds(rectangle);
            double d = -baseTransform.getMxt();
            double d2 = -baseTransform.getMyt();
            int n = (int)Math.floor(d);
            int n2 = (int)Math.floor(d2);
            rectangle2.translate(n, n2);
            if ((double)n != d) {
                ++rectangle2.width;
            }
            if ((double)n2 != d2) {
                ++rectangle2.height;
            }
            return rectangle2;
        }
        RectBounds rectBounds = new RectBounds(rectangle);
        try {
            rectBounds.grow(-0.5f, -0.5f);
            rectBounds = (RectBounds)baseTransform.inverseTransform(rectBounds, rectBounds);
            rectBounds.grow(0.5f, 0.5f);
            rectangle2.setBounds(rectBounds);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return rectangle2;
    }

    @Override
    public ImageData filter(FilterContext filterContext, BaseTransform baseTransform, Rectangle rectangle, Object object, Effect effect) {
        BaseTransform baseTransform2;
        Rectangle rectangle2;
        int n = this.getNumInputs();
        ImageData[] imageDataArray = new ImageData[n];
        if (this.operatesInUserSpace()) {
            rectangle2 = FilterEffect.untransformClip(baseTransform, rectangle);
            baseTransform2 = BaseTransform.IDENTITY_TRANSFORM;
        } else {
            rectangle2 = rectangle;
            baseTransform2 = baseTransform;
        }
        for (int i = 0; i < n; ++i) {
            Effect effect2 = this.getDefaultedInput(i, effect);
            imageDataArray[i] = effect2.filter(filterContext, baseTransform2, this.getInputClip(i, baseTransform2, rectangle2), null, effect);
            if (imageDataArray[i].validate(filterContext)) continue;
            for (int j = 0; j <= i; ++j) {
                imageDataArray[j].unref();
            }
            return new ImageData(filterContext, null, null);
        }
        ImageData imageData = this.filterImageDatas(filterContext, baseTransform2, rectangle2, imageDataArray);
        for (int i = 0; i < n; ++i) {
            imageDataArray[i].unref();
        }
        if (baseTransform2 != baseTransform) {
            if (object instanceof ImageDataRenderer) {
                ImageDataRenderer imageDataRenderer = (ImageDataRenderer)object;
                imageDataRenderer.renderImage(imageData, baseTransform, filterContext);
                imageData.unref();
                imageData = null;
            } else {
                imageData = imageData.transform(baseTransform);
            }
        }
        return imageData;
    }

    @Override
    public Point2D transform(Point2D point2D, Effect effect) {
        return this.getDefaultedInput(0, effect).transform(point2D, effect);
    }

    @Override
    public Point2D untransform(Point2D point2D, Effect effect) {
        return this.getDefaultedInput(0, effect).untransform(point2D, effect);
    }

    protected abstract ImageData filterImageDatas(FilterContext var1, BaseTransform var2, Rectangle var3, ImageData ... var4);
}

