/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.NodeImpl;
import org.w3c.dom.events.EventTarget;

public class TouchImpl {
    protected final long peer;

    TouchImpl(long peer) {
        this.peer = peer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static TouchImpl create(long peer) {
        if (peer == 0L) {
            return null;
        }
        return new TouchImpl(peer);
    }

    public boolean equals(Object that) {
        return that instanceof TouchImpl && this.peer == ((TouchImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(TouchImpl arg) {
        return arg == null ? 0L : arg.getPeer();
    }

    private static native void dispose(long var0);

    static TouchImpl getImpl(long peer) {
        return TouchImpl.create(peer);
    }

    public int getClientX() {
        return TouchImpl.getClientXImpl(this.getPeer());
    }

    static native int getClientXImpl(long var0);

    public int getClientY() {
        return TouchImpl.getClientYImpl(this.getPeer());
    }

    static native int getClientYImpl(long var0);

    public int getScreenX() {
        return TouchImpl.getScreenXImpl(this.getPeer());
    }

    static native int getScreenXImpl(long var0);

    public int getScreenY() {
        return TouchImpl.getScreenYImpl(this.getPeer());
    }

    static native int getScreenYImpl(long var0);

    public int getPageX() {
        return TouchImpl.getPageXImpl(this.getPeer());
    }

    static native int getPageXImpl(long var0);

    public int getPageY() {
        return TouchImpl.getPageYImpl(this.getPeer());
    }

    static native int getPageYImpl(long var0);

    public EventTarget getTarget() {
        return (EventTarget)((Object)NodeImpl.getImpl(TouchImpl.getTargetImpl(this.getPeer())));
    }

    static native long getTargetImpl(long var0);

    public int getIdentifier() {
        return TouchImpl.getIdentifierImpl(this.getPeer());
    }

    static native int getIdentifierImpl(long var0);

    public int getWebkitRadiusX() {
        return TouchImpl.getWebkitRadiusXImpl(this.getPeer());
    }

    static native int getWebkitRadiusXImpl(long var0);

    public int getWebkitRadiusY() {
        return TouchImpl.getWebkitRadiusYImpl(this.getPeer());
    }

    static native int getWebkitRadiusYImpl(long var0);

    public float getWebkitRotationAngle() {
        return TouchImpl.getWebkitRotationAngleImpl(this.getPeer());
    }

    static native float getWebkitRotationAngleImpl(long var0);

    public float getWebkitForce() {
        return TouchImpl.getWebkitForceImpl(this.getPeer());
    }

    static native float getWebkitForceImpl(long var0);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            TouchImpl.dispose(this.peer);
        }
    }
}

