/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig;

import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.sig.ISignature;
import gnu.java.security.util.PRNG;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import java.util.Random;

public abstract class BaseSignature
implements ISignature {
    protected String schemeName;
    protected IMessageDigest md;
    protected PublicKey publicKey;
    protected PrivateKey privateKey;
    private Random rnd;
    private IRandom irnd;
    private PRNG prng = null;

    protected BaseSignature(String schemeName, IMessageDigest md) {
        this.schemeName = schemeName;
        if (md == null) {
            throw new IllegalArgumentException("Message digest MUST NOT be null");
        }
        this.md = md;
    }

    public String name() {
        return String.valueOf(this.schemeName) + "-" + this.md.name();
    }

    public void setupVerify(Map attributes) throws IllegalArgumentException {
        this.setup(attributes);
        PublicKey key = (PublicKey)attributes.get("gnu.crypto.sig.public.key");
        if (key != null) {
            this.setupForVerification(key);
        }
    }

    public void setupSign(Map attributes) throws IllegalArgumentException {
        this.setup(attributes);
        PrivateKey key = (PrivateKey)attributes.get("gnu.crypto.sig.private.key");
        if (key != null) {
            this.setupForSigning(key);
        }
    }

    public void update(byte b) {
        if (this.md == null) {
            throw new IllegalStateException();
        }
        this.md.update(b);
    }

    public void update(byte[] b, int off, int len) {
        if (this.md == null) {
            throw new IllegalStateException();
        }
        this.md.update(b, off, len);
    }

    public Object sign() {
        if (this.md == null || this.privateKey == null) {
            throw new IllegalStateException();
        }
        return this.generateSignature();
    }

    public boolean verify(Object sig) {
        if (this.md == null || this.publicKey == null) {
            throw new IllegalStateException();
        }
        return this.verifySignature(sig);
    }

    public abstract Object clone();

    protected abstract void setupForVerification(PublicKey var1) throws IllegalArgumentException;

    protected abstract void setupForSigning(PrivateKey var1) throws IllegalArgumentException;

    protected abstract Object generateSignature() throws IllegalStateException;

    protected abstract boolean verifySignature(Object var1) throws IllegalStateException;

    protected void init() {
        this.md.reset();
        this.rnd = null;
        this.irnd = null;
        this.publicKey = null;
        this.privateKey = null;
    }

    protected void nextRandomBytes(byte[] buffer) {
        if (this.rnd != null) {
            this.rnd.nextBytes(buffer);
        } else if (this.irnd != null) {
            try {
                this.irnd.nextBytes(buffer, 0, buffer.length);
            }
            catch (IllegalStateException x) {
                throw new RuntimeException("nextRandomBytes(): " + x);
            }
            catch (LimitReachedException x) {
                throw new RuntimeException("nextRandomBytes(): " + x);
            }
        } else {
            this.getDefaultPRNG().nextBytes(buffer);
        }
    }

    private void setup(Map attributes) {
        this.init();
        Object obj = attributes.get("gnu.crypto.sig.prng");
        if (obj instanceof Random) {
            this.rnd = (Random)obj;
        } else if (obj instanceof IRandom) {
            this.irnd = (IRandom)obj;
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

