/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print.ipp;

import gnu.javax.print.PrintFlavorException;
import gnu.javax.print.ipp.IppException;
import gnu.javax.print.ipp.IppPrintService;
import gnu.javax.print.ipp.IppRequest;
import gnu.javax.print.ipp.IppResponse;
import gnu.javax.print.ipp.attribute.job.JobId;
import gnu.javax.print.ipp.attribute.job.JobUri;
import gnu.javax.print.ipp.attribute.printer.DocumentFormat;
import gnu.javax.print.ipp.attribute.supported.OperationsSupported;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.print.CancelablePrintJob;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintJobAttributeSet;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;

public class DocPrintJobImpl
implements CancelablePrintJob {
    private IppPrintService service;
    private HashSet printJobListener = new HashSet();
    private ArrayList attributesListener = new ArrayList();
    private ArrayList attributesListenerAttributes = new ArrayList();
    private String username;
    private String password;
    private JobUri jobUri = null;
    private JobId jobId = null;
    private RequestingUserName requestingUser;
    private PrintJobAttributeSet oldSet = new HashPrintJobAttributeSet();
    private PrintJobAttributeSet currentSet = new HashPrintJobAttributeSet();
    private boolean printing = false;

    public DocPrintJobImpl(IppPrintService service, String user, String passwd) {
        this.service = service;
        this.username = user;
        this.password = passwd;
    }

    public void addPrintJobAttributeListener(PrintJobAttributeListener listener, PrintJobAttributeSet attributes) {
        if (listener == null) {
            return;
        }
        this.attributesListener.add(listener);
        this.attributesListenerAttributes.add(attributes);
    }

    public void addPrintJobListener(PrintJobListener listener) {
        if (listener == null) {
            return;
        }
        this.printJobListener.add(listener);
    }

    public PrintJobAttributeSet getAttributes() {
        return AttributeSetUtilities.unmodifiableView(this.currentSet);
    }

    public PrintService getPrintService() {
        return this.service;
    }

    public void print(Doc doc, PrintRequestAttributeSet attributes) throws PrintException {
        if (this.printing) {
            throw new PrintException("already printing");
        }
        this.printing = true;
        DocAttributeSet docAtts = doc.getAttributes();
        DocFlavor flavor = doc.getDocFlavor();
        if (flavor == null || !this.service.isDocFlavorSupported(flavor)) {
            this.notifyPrintJobListeners(new PrintJobEvent(this, 103));
            throw new PrintFlavorException("Invalid flavor", new DocFlavor[]{flavor});
        }
        HashAttributeSet mergedAtts = new HashAttributeSet();
        if (attributes != null) {
            mergedAtts.addAll(attributes);
        }
        if (docAtts != null) {
            mergedAtts.addAll(docAtts);
        }
        if (!mergedAtts.containsKey(RequestingUserName.class)) {
            mergedAtts.add(IppPrintService.REQUESTING_USER_NAME);
            this.requestingUser = IppPrintService.REQUESTING_USER_NAME;
        } else {
            this.requestingUser = (RequestingUserName)mergedAtts.get(RequestingUserName.class);
        }
        if (!mergedAtts.containsKey(JobName.class)) {
            mergedAtts.add(IppPrintService.JOB_NAME);
        }
        IppResponse response = null;
        try {
            PrinterURI printerUri = this.service.getPrinterURI();
            String printerUriStr = "http" + printerUri.toString().substring(3);
            URI uri = null;
            try {
                uri = new URI(printerUriStr);
            }
            catch (URISyntaxException uRISyntaxException) {}
            IppRequest request = new IppRequest(uri, this.username, this.password);
            request.setOperationID((short)OperationsSupported.PRINT_JOB.getValue());
            request.setOperationAttributeDefaults();
            request.addOperationAttribute(printerUri);
            if (mergedAtts != null) {
                request.addAndFilterJobOperationAttributes(mergedAtts);
                request.addAndFilterJobTemplateAttributes(mergedAtts);
            }
            DocumentFormat format = DocumentFormat.createDocumentFormat(flavor);
            request.addOperationAttribute(format);
            String className = flavor.getRepresentationClassName();
            if (className.equals("[B")) {
                request.setData((byte[])doc.getPrintData());
                response = request.send();
            } else if (className.equals("java.io.InputStream")) {
                InputStream stream = (InputStream)doc.getPrintData();
                request.setData(stream);
                response = request.send();
                stream.close();
            } else if (className.equals("[C")) {
                try {
                    String str = new String((char[])doc.getPrintData());
                    request.setData(str.getBytes("utf-16"));
                    response = request.send();
                }
                catch (UnsupportedEncodingException e) {
                    this.notifyPrintJobListeners(new PrintJobEvent(this, 103));
                    throw new PrintFlavorException("Invalid charset of flavor", e, new DocFlavor[]{flavor});
                }
            } else {
                if (className.equals("java.io.Reader")) {
                    try {
                        response = request.send();
                        throw new UnsupportedEncodingException("not supported yet");
                    }
                    catch (UnsupportedEncodingException e) {
                        this.notifyPrintJobListeners(new PrintJobEvent(this, 103));
                        throw new PrintFlavorException("Invalid charset of flavor", e, new DocFlavor[]{flavor});
                    }
                }
                if (className.equals("java.lang.String")) {
                    try {
                        String str = (String)doc.getPrintData();
                        request.setData(str.getBytes("utf-16"));
                        response = request.send();
                    }
                    catch (UnsupportedEncodingException e) {
                        this.notifyPrintJobListeners(new PrintJobEvent(this, 103));
                        throw new PrintFlavorException("Invalid charset of flavor", e, new DocFlavor[]{flavor});
                    }
                } else if (className.equals("java.net.URL")) {
                    URL url = (URL)doc.getPrintData();
                    InputStream stream = url.openStream();
                    request.setData(stream);
                    response = request.send();
                    stream.close();
                } else {
                    if (className.equals("java.awt.image.renderable.RenderableImage") || className.equals("java.awt.print.Printable") || className.equals("java.awt.print.Pageable")) {
                        throw new PrintException("Not yet supported.");
                    }
                    this.notifyPrintJobListeners(new PrintJobEvent(this, 103));
                    throw new PrintFlavorException("Invalid flavor", new DocFlavor[]{flavor});
                }
            }
            this.notifyPrintJobListeners(new PrintJobEvent(this, 106));
        }
        catch (IOException e) {
            throw new PrintException("IOException occured.", e);
        }
        short status = response.getStatusCode();
        if (status != 0 && status != 1 && status != 2) {
            this.notifyPrintJobListeners(new PrintJobEvent(this, 103));
            throw new PrintException("Printing failed - received statuscode " + Integer.toHexString(status));
        }
        this.notifyPrintJobListeners(new PrintJobEvent(this, 102));
        List<Map<Class<? extends Attribute>, Set<Attribute>>> jobAtts = response.getJobAttributes();
        Map<Class<? extends Attribute>, Set<Attribute>> jobAttributes = jobAtts.get(0);
        this.jobUri = (JobUri)((HashSet)jobAttributes.get(JobUri.class)).toArray()[0];
        this.jobId = (JobId)((HashSet)jobAttributes.get(JobId.class)).toArray()[0];
    }

    public void removePrintJobAttributeListener(PrintJobAttributeListener listener) {
        if (listener == null) {
            return;
        }
        int index = this.attributesListener.indexOf(listener);
        if (index != -1) {
            this.attributesListener.remove(index);
            this.attributesListenerAttributes.remove(index);
        }
    }

    public void removePrintJobListener(PrintJobListener listener) {
        if (listener == null) {
            return;
        }
        this.printJobListener.remove(listener);
    }

    public void cancel() throws PrintException {
        if (this.jobUri == null) {
            throw new PrintException("print job is not yet send");
        }
        IppResponse response = null;
        try {
            IppRequest request = new IppRequest(this.jobUri.getURI(), this.username, this.password);
            request.setOperationID((short)OperationsSupported.CANCEL_JOB.getValue());
            request.setOperationAttributeDefaults();
            request.addOperationAttribute(this.jobUri);
            request.addOperationAttribute(this.requestingUser);
            response = request.send();
        }
        catch (IOException e) {
            throw new IppException("IOException occured during cancel request.", e);
        }
        short status = response.getStatusCode();
        if (status != 0 && status != 1 && status != 2) {
            this.notifyPrintJobListeners(new PrintJobEvent(this, 103));
            throw new PrintException("Canceling failed - received statuscode " + Integer.toHexString(status));
        }
        this.notifyPrintJobListeners(new PrintJobEvent(this, 101));
    }

    private void notifyPrintJobListeners(PrintJobEvent e) {
        for (PrintJobListener l : this.printJobListener) {
            if (e.getPrintEventType() == 106) {
                l.printDataTransferCompleted(e);
                continue;
            }
            if (e.getPrintEventType() == 101) {
                l.printJobCanceled(e);
                continue;
            }
            if (e.getPrintEventType() == 102) {
                l.printJobCompleted(e);
                continue;
            }
            if (e.getPrintEventType() == 103) {
                l.printJobFailed(e);
                continue;
            }
            if (e.getPrintEventType() == 105) {
                l.printJobNoMoreEvents(e);
                continue;
            }
            l.printJobRequiresAttention(e);
        }
    }
}

