/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import gnu.xml.xpath.NameTest;
import gnu.xml.xpath.NodeTypeTest;
import gnu.xml.xpath.Pattern;
import gnu.xml.xpath.Selector;
import gnu.xml.xpath.Test;
import java.io.PrintStream;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

class Template
implements Comparable {
    static final double DEFAULT_PRIORITY = 0.5;
    final Stylesheet stylesheet;
    final QName name;
    final Pattern match;
    final TemplateNode node;
    final double priority;
    final int precedence;
    final QName mode;
    final boolean isAnyNode;

    Template(Stylesheet stylesheet, QName name, Pattern match, TemplateNode node2, int precedence, String priorityAttr, QName mode) {
        Selector selector;
        Test[] tests;
        this.stylesheet = stylesheet;
        this.name = name;
        this.match = match;
        this.node = node2;
        this.precedence = precedence;
        this.mode = mode;
        double p = 0.5;
        boolean a = false;
        if (priorityAttr != null) {
            p = Double.parseDouble(priorityAttr);
        } else if (match instanceof Selector && (tests = (selector = (Selector)match).getTests()).length > 0) {
            Test test = tests[0];
            if (test instanceof NameTest) {
                NameTest nameTest = (NameTest)test;
                p = nameTest.matchesAny() ? -0.25 : (nameTest.matchesAnyLocalName() ? -0.2 : 0.0);
            } else {
                NodeTypeTest nodeTypeTest = (NodeTypeTest)test;
                p = nodeTypeTest.getNodeType() == 7 && nodeTypeTest.getData() != null ? 0.0 : -0.5;
                boolean bl = a = nodeTypeTest.getNodeType() == 0;
            }
            if (tests.length > 1) {
                p += ((double)tests.length - 1.0) * 0.001;
            }
        }
        this.priority = p;
        this.isAnyNode = a;
    }

    private Template(Stylesheet stylesheet, QName name, Pattern match, TemplateNode node2, int precedence, double priority, QName mode, boolean isAnyNode) {
        this.stylesheet = stylesheet;
        this.name = name;
        this.match = match;
        this.node = node2;
        this.precedence = precedence;
        this.priority = priority;
        this.mode = mode;
        this.isAnyNode = isAnyNode;
    }

    Template clone(Stylesheet stylesheet) {
        return new Template(stylesheet, this.name, this.match == null ? null : (Pattern)this.match.clone(stylesheet), this.node == null ? null : this.node.clone(stylesheet), this.precedence, this.priority, this.mode, this.isAnyNode);
    }

    public int compareTo(Object other) {
        if (other instanceof Template) {
            Template t = (Template)other;
            int d = t.precedence - this.precedence;
            if (d != 0) {
                return d;
            }
            double d2 = t.priority - this.priority;
            if (d2 != 0.0) {
                return (int)Math.round(d2 * 1000.0);
            }
        }
        return 0;
    }

    Test getNodeTest(Expr expr) {
        return null;
    }

    boolean matches(QName mode, Node node2) {
        if (mode == null && this.mode != null || mode != null && !mode.equals(this.mode)) {
            return false;
        }
        if (this.match == null) {
            return false;
        }
        if (this.isAnyNode && node2.getNodeType() == 9) {
            return false;
        }
        return this.match.matches(node2);
    }

    boolean matches(QName name) {
        return name.equals(this.name);
    }

    boolean imports(Template other) {
        Stylesheet ctx = other.stylesheet.parent;
        while (ctx != null) {
            if (ctx == this.stylesheet) {
                return true;
            }
            ctx = ctx.parent;
        }
        return false;
    }

    void apply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        if (stylesheet.debug) {
            System.err.println("...applying " + this.toString() + " to " + context);
        }
        if (this.node != null) {
            this.node.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    public String toString() {
        CPStringBuilder buf = new CPStringBuilder(this.getClass().getName());
        buf.append('[');
        if (this.name != null) {
            buf.append("name=");
            buf.append(this.name);
        } else if (this.match != null) {
            buf.append("match=");
            buf.append(this.match);
        }
        if (this.mode != null) {
            buf.append(",mode=");
            buf.append(this.mode);
        }
        buf.append(",node=");
        buf.append(this.node);
        buf.append(']');
        return buf.toString();
    }

    void list(PrintStream out) {
        out.println(this.toString());
        if (this.node != null) {
            this.node.list(1, out, true);
        }
    }
}

