/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 10;
    private int size;
    private transient E[] data;

    public ArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.data = new Object[capacity];
    }

    public ArrayList() {
        this(10);
    }

    public ArrayList(Collection<? extends E> c) {
        this((int)((float)c.size() * 1.1f));
        this.addAll(c);
    }

    public void trimToSize() {
        if (this.size != this.data.length) {
            Object[] newData = new Object[this.size];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public void ensureCapacity(int minCapacity) {
        int current = this.data.length;
        if (minCapacity > current) {
            Object[] newData = new Object[Math.max(current * 2, minCapacity)];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object e) {
        return this.indexOf(e) != -1;
    }

    @Override
    public int indexOf(Object e) {
        int i = 0;
        while (i < this.size) {
            if (ArrayList.equals(e, this.data[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object e) {
        int i = this.size - 1;
        while (i >= 0) {
            if (ArrayList.equals(e, this.data[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public Object clone() {
        ArrayList clone = null;
        try {
            clone = (ArrayList)super.clone();
            clone.data = (Object[])this.data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        } else if (a.length > this.size) {
            a[this.size] = null;
        }
        System.arraycopy(this.data, 0, a, 0, this.size);
        return a;
    }

    @Override
    public E get(int index) {
        this.checkBoundExclusive(index);
        return this.data[index];
    }

    @Override
    public E set(int index, E e) {
        this.checkBoundExclusive(index);
        E result = this.data[index];
        this.data[index] = e;
        return result;
    }

    @Override
    public boolean add(E e) {
        ++this.modCount;
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.data[this.size++] = e;
        return true;
    }

    @Override
    public void add(int index, E e) {
        this.checkBoundInclusive(index);
        ++this.modCount;
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        if (index != this.size) {
            System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        }
        this.data[index] = e;
        ++this.size;
    }

    @Override
    public E remove(int index) {
        this.checkBoundExclusive(index);
        E r = this.data[index];
        ++this.modCount;
        if (index != --this.size) {
            System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
        }
        this.data[this.size] = null;
        return r;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            Arrays.fill(this.data, 0, this.size, null);
            this.size = 0;
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkBoundInclusive(index);
        Iterator<E> itr = c.iterator();
        int csize = c.size();
        ++this.modCount;
        if (csize + this.size > this.data.length) {
            this.ensureCapacity(this.size + csize);
        }
        int end = index + csize;
        if (this.size > 0 && index != this.size) {
            System.arraycopy(this.data, index, this.data, end, this.size - index);
        }
        this.size += csize;
        while (index < end) {
            this.data[index] = itr.next();
            ++index;
        }
        return csize > 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        int change = toIndex - fromIndex;
        if (change > 0) {
            ++this.modCount;
            System.arraycopy(this.data, toIndex, this.data, fromIndex, this.size - toIndex);
            this.size -= change;
        } else if (change < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkBoundInclusive(int index) {
        if (index > this.size) {
            this.raiseBoundsError(index);
        }
    }

    private void checkBoundExclusive(int index) {
        if (index >= this.size) {
            this.raiseBoundsError(index);
        }
    }

    private void raiseBoundsError(int index) {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
    }

    @Override
    boolean removeAllInternal(Collection<?> c) {
        int i = 0;
        while (i < this.size) {
            if (c.contains(this.data[i])) break;
            ++i;
        }
        if (i == this.size) {
            return false;
        }
        ++this.modCount;
        int j = i++;
        while (i < this.size) {
            if (!c.contains(this.data[i])) {
                this.data[j++] = this.data[i];
            }
            ++i;
        }
        this.size -= i - j;
        return true;
    }

    @Override
    boolean retainAllInternal(Collection<?> c) {
        int i = 0;
        while (i < this.size) {
            if (!c.contains(this.data[i])) break;
            ++i;
        }
        if (i == this.size) {
            return false;
        }
        ++this.modCount;
        int j = i++;
        while (i < this.size) {
            if (c.contains(this.data[i])) {
                this.data[j++] = this.data[i];
            }
            ++i;
        }
        this.size -= i - j;
        return true;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int len = this.data.length;
        s.writeInt(len);
        int i = 0;
        while (i < this.size) {
            s.writeObject(this.data[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int capacity = s.readInt();
        this.data = new Object[capacity];
        int i = 0;
        while (i < this.size) {
            this.data[i] = s.readObject();
            ++i;
        }
    }
}

