/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;

public class Bib2GlsDualIndexSymbol
extends Bib2GlsDualEntry {
    private String category;

    public Bib2GlsDualIndexSymbol(Bib2Gls bib2Gls) {
        this(bib2Gls, "dualindexsymbol", "symbol");
    }

    public Bib2GlsDualIndexSymbol(Bib2Gls bib2Gls, String string) {
        this(bib2Gls, string, "symbol");
    }

    public Bib2GlsDualIndexSymbol(Bib2Gls bib2Gls, String string, String string2) {
        super(bib2Gls, string);
        this.category = string2;
    }

    @Override
    public HashMap<String, String> getMappings() {
        return this.getResource().getDualIndexSymbolMap();
    }

    @Override
    public String getFirstMap() {
        return this.getResource().getFirstDualIndexSymbolMap();
    }

    @Override
    public boolean backLink() {
        return this.getResource().backLinkFirstDualIndexSymbolMap();
    }

    @Override
    protected Bib2GlsDualEntry createDualEntry() {
        return new Bib2GlsDualIndexSymbol(this.bib2gls, this.getEntryType() + "secondary");
    }

    @Override
    public void checkRequiredFields() {
        if (this.getField("symbol") == null) {
            this.missingFieldWarning("symbol");
        }
    }

    @Override
    public String getFallbackValue(String string) {
        if (string.equals("sort")) {
            String string2;
            String string3 = string2 = this.isPrimary() ? "name" : this.resource.getSymbolDefaultSortField();
            if (string2.equals("id")) {
                return this.getOriginalId();
            }
            String string4 = this.getFieldValue(string2);
            return string4 == null ? this.getFallbackValue(string2) : string4;
        }
        if (string.equals("name")) {
            return this.getOriginalId();
        }
        return super.getFallbackValue(string);
    }

    @Override
    public BibValueList getFallbackContents(String string) {
        if (string.equals("sort")) {
            String string2;
            String string3 = string2 = this.isPrimary() ? "name" : this.resource.getSymbolDefaultSortField();
            if (string2.equals("id")) {
                return this.getIdField();
            }
            BibValueList bibValueList = this.getField(string2);
            return bibValueList == null ? this.getFallbackContents(string2) : bibValueList;
        }
        if (string.equals("name") && this.bib2gls.useInterpreter()) {
            return this.getIdField();
        }
        return super.getFallbackContents(string);
    }

    @Override
    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("\\%s{%s}%%%n{", this.getCsName(), this.getId());
        String string = "";
        String string2 = "";
        String string3 = null;
        String string4 = "";
        Set<String> set = this.getFieldSet();
        for (String string5 : set) {
            if (string5.equals("description")) {
                string2 = this.getFieldValue(string5);
                continue;
            }
            if (string5.equals("name")) {
                string3 = this.getFieldValue(string5);
                continue;
            }
            if (string5.equals("symbol")) {
                string4 = this.getFieldValue(string5);
                continue;
            }
            if (this.bib2gls.isKnownField(string5)) {
                printWriter.format("%s", string);
                string = String.format(",%n", new Object[0]);
                printWriter.format("%s={%s}", string5, this.getFieldValue(string5));
                continue;
            }
            if (this.bib2gls.getDebugLevel() <= 0 || this.bib2gls.isInternalField(string5)) continue;
            this.bib2gls.debugMessage("warning.ignoring.unknown.field", string5);
        }
        if (string3 == null) {
            string3 = this.getFallbackValue("name");
        }
        printWriter.println(String.format("}%%%n{%s}{%s}%n{%s}", string3, string4, string2));
    }

    @Override
    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        printWriter.format("\\providecommand{\\%s}[5]{%%%n", this.getCsName());
        printWriter.print("  \\longnewglossaryentry*{#1}{name={#3},");
        if (this.isPrimary()) {
            printWriter.println("category={index},");
        } else {
            printWriter.format("category={%s},", this.category);
        }
        printWriter.println("symbol={#4},#2}{#5}%");
        printWriter.println("}");
    }
}

