/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class JadxArgs {
    public static final int DEFAULT_THREADS_COUNT = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    public static final String DEFAULT_OUT_DIR = "jadx-output";
    public static final String DEFAULT_SRC_DIR = "sources";
    public static final String DEFAULT_RES_DIR = "resources";
    private List<File> inputFiles = new ArrayList<File>(1);
    private File outDir;
    private File outDirSrc;
    private File outDirRes;
    private int threadsCount = DEFAULT_THREADS_COUNT;
    private boolean cfgOutput = false;
    private boolean rawCFGOutput = false;
    private boolean fallbackMode = false;
    private boolean showInconsistentCode = false;
    private boolean useImports = true;
    private boolean isSkipResources = false;
    private boolean isSkipSources = false;
    private boolean isDeobfuscationOn = false;
    private boolean isDeobfuscationForceSave = false;
    private boolean useSourceNameAsClassAlias = false;
    private int deobfuscationMinLength = 0;
    private int deobfuscationMaxLength = Integer.MAX_VALUE;
    private boolean escapeUnicode = false;
    private boolean replaceConsts = true;
    private boolean respectBytecodeAccModifiers = false;
    private boolean exportAsGradleProject = false;

    public void setRootDir(File rootDir) {
        this.setOutDir(rootDir);
        this.setOutDirSrc(new File(rootDir, DEFAULT_SRC_DIR));
        this.setOutDirRes(new File(rootDir, DEFAULT_RES_DIR));
    }

    public List<File> getInputFiles() {
        return this.inputFiles;
    }

    public void setInputFiles(List<File> inputFiles) {
        this.inputFiles = inputFiles;
    }

    public File getOutDir() {
        return this.outDir;
    }

    public void setOutDir(File outDir) {
        this.outDir = outDir;
    }

    public File getOutDirSrc() {
        return this.outDirSrc;
    }

    public void setOutDirSrc(File outDirSrc) {
        this.outDirSrc = outDirSrc;
    }

    public File getOutDirRes() {
        return this.outDirRes;
    }

    public void setOutDirRes(File outDirRes) {
        this.outDirRes = outDirRes;
    }

    public int getThreadsCount() {
        return this.threadsCount;
    }

    public void setThreadsCount(int threadsCount) {
        this.threadsCount = threadsCount;
    }

    public boolean isCfgOutput() {
        return this.cfgOutput;
    }

    public void setCfgOutput(boolean cfgOutput) {
        this.cfgOutput = cfgOutput;
    }

    public boolean isRawCFGOutput() {
        return this.rawCFGOutput;
    }

    public void setRawCFGOutput(boolean rawCFGOutput) {
        this.rawCFGOutput = rawCFGOutput;
    }

    public boolean isFallbackMode() {
        return this.fallbackMode;
    }

    public void setFallbackMode(boolean fallbackMode) {
        this.fallbackMode = fallbackMode;
    }

    public boolean isShowInconsistentCode() {
        return this.showInconsistentCode;
    }

    public void setShowInconsistentCode(boolean showInconsistentCode) {
        this.showInconsistentCode = showInconsistentCode;
    }

    public boolean isUseImports() {
        return this.useImports;
    }

    public void setUseImports(boolean useImports) {
        this.useImports = useImports;
    }

    public boolean isSkipResources() {
        return this.isSkipResources;
    }

    public void setSkipResources(boolean skipResources) {
        this.isSkipResources = skipResources;
    }

    public boolean isSkipSources() {
        return this.isSkipSources;
    }

    public void setSkipSources(boolean skipSources) {
        this.isSkipSources = skipSources;
    }

    public boolean isDeobfuscationOn() {
        return this.isDeobfuscationOn;
    }

    public void setDeobfuscationOn(boolean deobfuscationOn) {
        this.isDeobfuscationOn = deobfuscationOn;
    }

    public boolean isDeobfuscationForceSave() {
        return this.isDeobfuscationForceSave;
    }

    public void setDeobfuscationForceSave(boolean deobfuscationForceSave) {
        this.isDeobfuscationForceSave = deobfuscationForceSave;
    }

    public boolean isUseSourceNameAsClassAlias() {
        return this.useSourceNameAsClassAlias;
    }

    public void setUseSourceNameAsClassAlias(boolean useSourceNameAsClassAlias) {
        this.useSourceNameAsClassAlias = useSourceNameAsClassAlias;
    }

    public int getDeobfuscationMinLength() {
        return this.deobfuscationMinLength;
    }

    public void setDeobfuscationMinLength(int deobfuscationMinLength) {
        this.deobfuscationMinLength = deobfuscationMinLength;
    }

    public int getDeobfuscationMaxLength() {
        return this.deobfuscationMaxLength;
    }

    public void setDeobfuscationMaxLength(int deobfuscationMaxLength) {
        this.deobfuscationMaxLength = deobfuscationMaxLength;
    }

    public boolean isEscapeUnicode() {
        return this.escapeUnicode;
    }

    public void setEscapeUnicode(boolean escapeUnicode) {
        this.escapeUnicode = escapeUnicode;
    }

    public boolean isReplaceConsts() {
        return this.replaceConsts;
    }

    public void setReplaceConsts(boolean replaceConsts) {
        this.replaceConsts = replaceConsts;
    }

    public boolean isRespectBytecodeAccModifiers() {
        return this.respectBytecodeAccModifiers;
    }

    public void setRespectBytecodeAccModifiers(boolean respectBytecodeAccModifiers) {
        this.respectBytecodeAccModifiers = respectBytecodeAccModifiers;
    }

    public boolean isExportAsGradleProject() {
        return this.exportAsGradleProject;
    }

    public void setExportAsGradleProject(boolean exportAsGradleProject) {
        this.exportAsGradleProject = exportAsGradleProject;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JadxArgs{");
        sb.append("inputFiles=").append(this.inputFiles);
        sb.append(", outDir=").append(this.outDir);
        sb.append(", outDirSrc=").append(this.outDirSrc);
        sb.append(", outDirRes=").append(this.outDirRes);
        sb.append(", threadsCount=").append(this.threadsCount);
        sb.append(", cfgOutput=").append(this.cfgOutput);
        sb.append(", rawCFGOutput=").append(this.rawCFGOutput);
        sb.append(", fallbackMode=").append(this.fallbackMode);
        sb.append(", showInconsistentCode=").append(this.showInconsistentCode);
        sb.append(", useImports=").append(this.useImports);
        sb.append(", isSkipResources=").append(this.isSkipResources);
        sb.append(", isSkipSources=").append(this.isSkipSources);
        sb.append(", isDeobfuscationOn=").append(this.isDeobfuscationOn);
        sb.append(", isDeobfuscationForceSave=").append(this.isDeobfuscationForceSave);
        sb.append(", useSourceNameAsClassAlias=").append(this.useSourceNameAsClassAlias);
        sb.append(", deobfuscationMinLength=").append(this.deobfuscationMinLength);
        sb.append(", deobfuscationMaxLength=").append(this.deobfuscationMaxLength);
        sb.append(", escapeUnicode=").append(this.escapeUnicode);
        sb.append(", replaceConsts=").append(this.replaceConsts);
        sb.append(", respectBytecodeAccModifiers=").append(this.respectBytecodeAccModifiers);
        sb.append(", exportAsGradleProject=").append(this.exportAsGradleProject);
        sb.append('}');
        return sb.toString();
    }
}

