/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocksmaker;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.NamedArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.TryCatchBlock;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InstructionRemover;

public class BlockExceptionHandler
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            BlockExceptionHandler.markExceptionHandlers(block);
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            block.updateCleanSuccessors();
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            BlockExceptionHandler.processExceptionHandlers(mth, block);
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            BlockExceptionHandler.processTryCatchBlocks(block);
        }
    }

    private static void markExceptionHandlers(BlockNode block) {
        InsnNode me;
        ExcHandlerAttr handlerAttr = block.get(AType.EXC_HANDLER);
        if (handlerAttr == null) {
            return;
        }
        ExceptionHandler excHandler = handlerAttr.getHandler();
        ArgType argType = excHandler.getArgType();
        if (!block.getInstructions().isEmpty() && (me = block.getInstructions().get(0)).getType() == InsnType.MOVE_EXCEPTION) {
            RegisterArg resArg = InsnArg.reg(me.getResult().getRegNum(), argType);
            resArg.copyAttributesFrom(me);
            me.setResult(resArg);
            me.add(AFlag.DONT_INLINE);
            excHandler.setArg(resArg);
            return;
        }
        excHandler.setArg(new NamedArg("unused", argType));
    }

    private static void processExceptionHandlers(MethodNode mth, BlockNode block) {
        ExcHandlerAttr handlerAttr = block.get(AType.EXC_HANDLER);
        if (handlerAttr == null) {
            return;
        }
        ExceptionHandler excHandler = handlerAttr.getHandler();
        excHandler.addBlock(block);
        for (BlockNode node : BlockUtils.collectBlocksDominatedBy(block, block)) {
            excHandler.addBlock(node);
        }
        for (BlockNode excBlock : excHandler.getBlocks()) {
            InstructionRemover remover = new InstructionRemover(mth, excBlock);
            for (InsnNode insn : excBlock.getInstructions()) {
                if (insn.getType() == InsnType.MONITOR_ENTER) break;
                if (insn.getType() != InsnType.MONITOR_EXIT) continue;
                remover.add(insn);
            }
            remover.perform();
            for (InsnNode insn : excBlock.getInstructions()) {
                CatchAttr catchAttr = insn.get(AType.CATCH_BLOCK);
                if (catchAttr == null || insn.getType() != InsnType.THROW && !BlockExceptionHandler.onlyAllHandler(catchAttr.getTryBlock())) continue;
                TryCatchBlock handlerBlock = handlerAttr.getTryBlock();
                TryCatchBlock catchBlock = catchAttr.getTryBlock();
                handlerBlock.merge(mth, catchBlock);
            }
        }
    }

    private static boolean onlyAllHandler(TryCatchBlock tryBlock) {
        if (tryBlock.getHandlersCount() == 1) {
            ExceptionHandler eh = tryBlock.getHandlers().iterator().next();
            return eh.isCatchAll() || eh.isFinally();
        }
        return false;
    }

    private static void processTryCatchBlocks(BlockNode block) {
        CatchAttr commonCatchAttr = null;
        for (InsnNode insn : block.getInstructions()) {
            CatchAttr catchAttr = insn.get(AType.CATCH_BLOCK);
            if (catchAttr == null) continue;
            if (commonCatchAttr == null) {
                commonCatchAttr = catchAttr;
                continue;
            }
            if (commonCatchAttr == catchAttr) continue;
            commonCatchAttr = null;
            break;
        }
        if (commonCatchAttr != null) {
            block.addAttr(commonCatchAttr);
        }
    }
}

