ColorPicker.ContrastInfo=class extends Common.Object{constructor(contrastInfo){super();this._isNull=true;this._contrastRatio=null;this._contrastRatioThresholds=null;this._fgColor=null;this._bgColor=null;if(!contrastInfo){return;}
if(!contrastInfo.computedFontSize||!contrastInfo.computedFontWeight||!contrastInfo.backgroundColors||contrastInfo.backgroundColors.length!==1){return;}
this._isNull=false;const isLargeFont=ColorPicker.ContrastInfo.computeIsLargeFont(contrastInfo.computedFontSize,contrastInfo.computedFontWeight);this._contrastRatioThresholds=ColorPicker.ContrastInfo._ContrastThresholds[(isLargeFont?'largeFont':'normalFont')];const bgColorText=contrastInfo.backgroundColors[0];const bgColor=Common.Color.parse(bgColorText);if(bgColor){this._setBgColorInternal(bgColor);}}
isNull(){return this._isNull;}
setColor(fgColor){this._fgColor=fgColor;this._updateContrastRatio();this.dispatchEventToListeners(ColorPicker.ContrastInfo.Events.ContrastInfoUpdated);}
color(){return this._fgColor;}
contrastRatio(){return this._contrastRatio;}
setBgColor(bgColor){this._setBgColorInternal(bgColor);this.dispatchEventToListeners(ColorPicker.ContrastInfo.Events.ContrastInfoUpdated);}
_setBgColorInternal(bgColor){this._bgColor=bgColor;if(!this._fgColor){return;}
const fgRGBA=this._fgColor.rgba();if(bgColor.hasAlpha()){const blendedRGBA=[];Common.Color.blendColors(bgColor.rgba(),fgRGBA,blendedRGBA);this._bgColor=new Common.Color(blendedRGBA,Common.Color.Format.RGBA);}
this._contrastRatio=Common.Color.calculateContrastRatio(fgRGBA,this._bgColor.rgba());}
bgColor(){return this._bgColor;}
_updateContrastRatio(){if(!this._bgColor||!this._fgColor){return;}
this._contrastRatio=Common.Color.calculateContrastRatio(this._fgColor.rgba(),this._bgColor.rgba());}
contrastRatioThreshold(level){if(!this._contrastRatioThresholds){return null;}
return this._contrastRatioThresholds[level];}
static computeIsLargeFont(fontSize,fontWeight){const boldWeights=['bold','bolder','600','700','800','900'];const fontSizePx=parseFloat(fontSize.replace('px',''));const isBold=(boldWeights.indexOf(fontWeight)!==-1);const fontSizePt=fontSizePx*72/96;if(isBold){return fontSizePt>=14;}else{return fontSizePt>=18;}}};ColorPicker.ContrastInfo.Events={ContrastInfoUpdated:Symbol('ContrastInfoUpdated')};ColorPicker.ContrastInfo._ContrastThresholds={largeFont:{aa:3.0,aaa:4.5},normalFont:{aa:4.5,aaa:7.0}};;ColorPicker.ContrastOverlay=class{constructor(contrastInfo,colorElement){this._contrastInfo=contrastInfo;this._visible=false;this._contrastRatioSVG=colorElement.createSVGChild('svg','spectrum-contrast-container fill');this._contrastRatioLines={aa:this._contrastRatioSVG.createSVGChild('path','spectrum-contrast-line'),aaa:this._contrastRatioSVG.createSVGChild('path','spectrum-contrast-line')};this._width=0;this._height=0;this._contrastRatioLineBuilder=new ColorPicker.ContrastRatioLineBuilder(this._contrastInfo);this._contrastRatioLinesThrottler=new Common.Throttler(0);this._drawContrastRatioLinesBound=this._drawContrastRatioLines.bind(this);this._contrastInfo.addEventListener(ColorPicker.ContrastInfo.Events.ContrastInfoUpdated,this._update.bind(this));}
_update(){if(!this._visible||this._contrastInfo.isNull()||!this._contrastInfo.contrastRatio()){return;}
this._contrastRatioLinesThrottler.schedule(this._drawContrastRatioLinesBound);}
setDimensions(width,height){this._width=width;this._height=height;this._update();}
setVisible(visible){this._visible=visible;this._contrastRatioSVG.classList.toggle('hidden',!visible);this._update();}
async _drawContrastRatioLines(){for(const level in this._contrastRatioLines){const path=this._contrastRatioLineBuilder.drawContrastRatioLine(this._width,this._height,level);if(path){this._contrastRatioLines[level].setAttribute('d',path);}else{this._contrastRatioLines[level].removeAttribute('d');}}}};ColorPicker.ContrastRatioLineBuilder=class{constructor(contrastInfo){this._contrastInfo=contrastInfo;}
drawContrastRatioLine(width,height,level){const requiredContrast=this._contrastInfo.contrastRatioThreshold(level);if(!width||!height||!requiredContrast){return null;}
const dS=0.02;const epsilon=0.0002;const H=0;const S=1;const V=2;const A=3;const color=this._contrastInfo.color();const bgColor=this._contrastInfo.bgColor();if(!color||!bgColor){return null;}
const fgRGBA=color.rgba();const fgHSVA=color.hsva();const bgRGBA=bgColor.rgba();const bgLuminance=Common.Color.luminance(bgRGBA);const blendedRGBA=[];Common.Color.blendColors(fgRGBA,bgRGBA,blendedRGBA);const fgLuminance=Common.Color.luminance(blendedRGBA);const fgIsLighter=fgLuminance>bgLuminance;const desiredLuminance=Common.Color.desiredLuminance(bgLuminance,requiredContrast,fgIsLighter);let lastV=fgHSVA[V];let currentSlope=0;const candidateHSVA=[fgHSVA[H],0,0,fgHSVA[A]];let pathBuilder=[];const candidateRGBA=[];Common.Color.hsva2rgba(candidateHSVA,candidateRGBA);Common.Color.blendColors(candidateRGBA,bgRGBA,blendedRGBA);function updateCandidateAndComputeDelta(index,x){candidateHSVA[index]=x;Common.Color.hsva2rgba(candidateHSVA,candidateRGBA);Common.Color.blendColors(candidateRGBA,bgRGBA,blendedRGBA);return Common.Color.luminance(blendedRGBA)-desiredLuminance;}
function approach(index){let x=candidateHSVA[index];let multiplier=1;let dLuminance=updateCandidateAndComputeDelta(index,x);let previousSign=Math.sign(dLuminance);for(let guard=100;guard;guard--){if(Math.abs(dLuminance)<epsilon){return x;}
const sign=Math.sign(dLuminance);if(sign!==previousSign){multiplier/=2;previousSign=sign;}else if(x<0||x>1){return null;}
x+=multiplier*(index===V?-dLuminance:dLuminance);dLuminance=updateCandidateAndComputeDelta(index,x);}
console.error('Loop exited unexpectedly');return null;}
let s;for(s=0;s<1+dS;s+=dS){s=Math.min(1,s);candidateHSVA[S]=s;candidateHSVA[V]=lastV+currentSlope*dS;const v=approach(V);if(v===null){break;}
currentSlope=s===0?0:(v-lastV)/dS;lastV=v;pathBuilder.push(pathBuilder.length?'L':'M');pathBuilder.push((s*width).toFixed(2));pathBuilder.push(((1-v)*height).toFixed(2));}
if(s<1+dS){s-=dS;candidateHSVA[V]=1;s=approach(S);if(s!==null){pathBuilder=pathBuilder.concat(['L',(s*width).toFixed(2),'-0.1']);}}
if(pathBuilder.length===0){return null;}
return pathBuilder.join(' ');}};;ColorPicker.ContrastDetails=class extends Common.Object{constructor(contrastInfo,contentElement,toggleMainColorPickerCallback,expandedChangedCallback){super();this._contrastInfo=contrastInfo;this._element=contentElement.createChild('div','spectrum-contrast-details collapsed');this._toggleMainColorPicker=toggleMainColorPickerCallback;this._expandedChangedCallback=expandedChangedCallback;this._expanded=false;this._passesAA=true;this._contrastUnknown=false;this._visible=false;const contrastValueRow=this._element.createChild('div');contrastValueRow.addEventListener('click',this._topRowClicked.bind(this));const contrastValueRowContents=contrastValueRow.createChild('div','container');contrastValueRowContents.createTextChild(Common.UIString('Contrast ratio'));this._contrastValueBubble=contrastValueRowContents.createChild('span','contrast-details-value');this._contrastValue=this._contrastValueBubble.createChild('span');this._contrastValueBubbleIcons=[];this._contrastValueBubbleIcons.push(this._contrastValueBubble.appendChild(UI.Icon.create('smallicon-checkmark-square')));this._contrastValueBubbleIcons.push(this._contrastValueBubble.appendChild(UI.Icon.create('smallicon-checkmark-behind')));this._contrastValueBubbleIcons.push(this._contrastValueBubble.appendChild(UI.Icon.create('smallicon-no')));this._contrastValueBubbleIcons.forEach(button=>button.addEventListener('click',event=>{ColorPicker.ContrastDetails._showHelp();event.consume(false);}));const expandToolbar=new UI.Toolbar('expand',contrastValueRowContents);this._expandButton=new UI.ToolbarButton(Common.UIString('Show more'),'smallicon-expand-more');this._expandButton.addEventListener(UI.ToolbarButton.Events.Click,this._expandButtonClicked.bind(this));UI.ARIAUtils.setExpanded(this._expandButton.element,false);expandToolbar.appendToolbarItem(this._expandButton);this._expandedDetails=this._element.createChild('div','expanded-details');UI.ARIAUtils.setControls(this._expandButton.element,this._expandedDetails);this._contrastThresholds=this._expandedDetails.createChild('div','contrast-thresholds');this._contrastAA=this._contrastThresholds.createChild('div','contrast-threshold');this._contrastPassFailAA=this._contrastAA.createChild('span','contrast-pass-fail');this._contrastAAA=this._contrastThresholds.createChild('div','contrast-threshold');this._contrastPassFailAAA=this._contrastAAA.createChild('span','contrast-pass-fail');this._chooseBgColor=this._expandedDetails.createChild('div','contrast-choose-bg-color');this._chooseBgColor.textContent=Common.UIString('Pick background color');const bgColorContainer=this._expandedDetails.createChild('div','background-color');const pickerToolbar=new UI.Toolbar('spectrum-eye-dropper',bgColorContainer);this._bgColorPickerButton=new UI.ToolbarToggle(Common.UIString('Toggle background color picker'),'largeicon-eyedropper');this._bgColorPickerButton.addEventListener(UI.ToolbarButton.Events.Click,this._toggleBackgroundColorPicker.bind(this,undefined,true));pickerToolbar.appendToolbarItem(this._bgColorPickerButton);this._bgColorPickedBound=this._bgColorPicked.bind(this);this._bgColorSwatch=new ColorPicker.ContrastDetails.Swatch(bgColorContainer);this._contrastInfo.addEventListener(ColorPicker.ContrastInfo.Events.ContrastInfoUpdated,this._update.bind(this));}
_update(){if(this._contrastInfo.isNull()){this.setVisible(false);return;}
this.setVisible(true);const contrastRatio=this._contrastInfo.contrastRatio();const fgColor=this._contrastInfo.color();const bgColor=this._contrastInfo.bgColor();if(!contrastRatio||!bgColor||!fgColor){this._contrastUnknown=true;this._contrastValue.textContent='';this._contrastValueBubble.classList.add('contrast-unknown');this._chooseBgColor.classList.remove('hidden');this._contrastThresholds.classList.add('hidden');return;}
this._contrastUnknown=false;this._chooseBgColor.classList.add('hidden');this._contrastThresholds.classList.remove('hidden');this._contrastValueBubble.classList.remove('contrast-unknown');this._contrastValue.textContent=contrastRatio.toFixed(2);this._bgColorSwatch.setColors(fgColor,bgColor);const aa=this._contrastInfo.contrastRatioThreshold('aa');this._passesAA=this._contrastInfo.contrastRatio()>=aa;this._contrastPassFailAA.removeChildren();const labelAA=this._contrastPassFailAA.createChild('span','contrast-link-label');labelAA.textContent=Common.UIString('AA');this._contrastPassFailAA.createChild('span').textContent=Common.UIString(': %s',aa.toFixed(1));if(this._passesAA){this._contrastPassFailAA.appendChild(UI.Icon.create('smallicon-checkmark-square'));}else{this._contrastPassFailAA.appendChild(UI.Icon.create('smallicon-no'));}
const aaa=this._contrastInfo.contrastRatioThreshold('aaa');const passesAAA=this._contrastInfo.contrastRatio()>=aaa;this._contrastPassFailAAA.removeChildren();const labelAAA=this._contrastPassFailAAA.createChild('span','contrast-link-label');labelAAA.textContent=Common.UIString('AAA');this._contrastPassFailAAA.createChild('span').textContent=Common.UIString(': %s',aaa.toFixed(1));if(passesAAA){this._contrastPassFailAAA.appendChild(UI.Icon.create('smallicon-checkmark-square'));}else{this._contrastPassFailAAA.appendChild(UI.Icon.create('smallicon-no'));}
[labelAA,labelAAA].forEach(e=>e.addEventListener('click',event=>ColorPicker.ContrastDetails._showHelp()));this._element.classList.toggle('contrast-fail',!this._passesAA);this._contrastValueBubble.classList.toggle('contrast-aa',this._passesAA);this._contrastValueBubble.classList.toggle('contrast-aaa',passesAAA);}
static _showHelp(){Host.InspectorFrontendHost.openInNewTab('https://developers.google.com/web/fundamentals/accessibility/accessible-styles#color_and_contrast');}
setVisible(visible){this._visible=visible;this._element.classList.toggle('hidden',!visible);}
visible(){return this._visible;}
element(){return this._element;}
_expandButtonClicked(event){this._contrastValueBubble.getComponentSelection().empty();this._toggleExpanded();}
_topRowClicked(event){this._contrastValueBubble.getComponentSelection().empty();this._toggleExpanded();event.consume(true);}
_toggleExpanded(){this._expanded=!this._expanded;UI.ARIAUtils.setExpanded(this._expandButton.element,this._expanded);this._element.classList.toggle('collapsed',!this._expanded);if(this._expanded){this._toggleMainColorPicker(false);this._expandButton.setGlyph('smallicon-expand-less');this._expandButton.setTitle(Common.UIString('Show less'));if(this._contrastUnknown){this._toggleBackgroundColorPicker(true);}}else{this._toggleBackgroundColorPicker(false);this._expandButton.setGlyph('smallicon-expand-more');this._expandButton.setTitle(Common.UIString('Show more'));}
this._expandedChangedCallback();}
collapse(){this._element.classList.remove('expanded');this._toggleBackgroundColorPicker(false);this._toggleMainColorPicker(false);}
expanded(){return this._expanded;}
backgroundColorPickerEnabled(){return this._bgColorPickerButton.toggled();}
toggleBackgroundColorPicker(enabled){this._toggleBackgroundColorPicker(enabled,false);}
_toggleBackgroundColorPicker(enabled,shouldTriggerEvent=true){if(enabled===undefined){enabled=!this._bgColorPickerButton.toggled();}
this._bgColorPickerButton.setToggled(enabled);if(shouldTriggerEvent){this.dispatchEventToListeners(ColorPicker.ContrastDetails.Events.BackgroundColorPickerWillBeToggled,enabled);}
Host.InspectorFrontendHost.setEyeDropperActive(enabled);if(enabled){Host.InspectorFrontendHost.events.addEventListener(Host.InspectorFrontendHostAPI.Events.EyeDropperPickedColor,this._bgColorPickedBound);}else{Host.InspectorFrontendHost.events.removeEventListener(Host.InspectorFrontendHostAPI.Events.EyeDropperPickedColor,this._bgColorPickedBound);}}
_bgColorPicked(event){const rgbColor=(event.data);const rgba=[rgbColor.r,rgbColor.g,rgbColor.b,(rgbColor.a/2.55|0)/100];const color=Common.Color.fromRGBA(rgba);this._contrastInfo.setBgColor(color);this._toggleBackgroundColorPicker(false);Host.InspectorFrontendHost.bringToFront();}};ColorPicker.ContrastDetails.Events={BackgroundColorPickerWillBeToggled:Symbol('BackgroundColorPickerWillBeToggled')};ColorPicker.ContrastDetails.Swatch=class{constructor(parentElement){this._parentElement=parentElement;this._swatchElement=parentElement.createChild('span','swatch contrast swatch-inner-white');this._swatchInnerElement=this._swatchElement.createChild('span','swatch-inner');this._textPreview=this._swatchElement.createChild('div','text-preview');this._textPreview.textContent='Aa';}
setColors(fgColor,bgColor){this._textPreview.style.color=(fgColor.asString(Common.Color.Format.RGBA));this._swatchInnerElement.style.backgroundColor=(bgColor.asString(Common.Color.Format.RGBA));this._swatchElement.classList.toggle('swatch-inner-white',bgColor.hsla()[2]>0.9);}};;ColorPicker.Spectrum=class extends UI.VBox{constructor(contrastInfo){function appendSwitcherIcon(parentElement){const icon=parentElement.createSVGChild('svg');icon.setAttribute('height',16);icon.setAttribute('width',16);const path=icon.createSVGChild('path');path.setAttribute('d','M5,6 L11,6 L8,2 Z M5,10 L11,10 L8,14 Z');return icon;}
super(true);this.registerRequiredCSS('color_picker/spectrum.css');this.contentElement.tabIndex=0;this.setDefaultFocusedElement(this.contentElement);this._colorElement=this.contentElement.createChild('div','spectrum-color');this._colorDragElement=this._colorElement.createChild('div','spectrum-sat fill').createChild('div','spectrum-val fill').createChild('div','spectrum-dragger');this._dragX=0;this._dragY=0;const toolsContainer=this.contentElement.createChild('div','spectrum-tools');const toolbar=new UI.Toolbar('spectrum-eye-dropper',toolsContainer);this._colorPickerButton=new UI.ToolbarToggle(Common.UIString('Toggle color picker'),'largeicon-eyedropper');this._colorPickerButton.setToggled(true);this._colorPickerButton.addEventListener(UI.ToolbarButton.Events.Click,this._toggleColorPicker.bind(this,undefined));toolbar.appendToolbarItem(this._colorPickerButton);this._swatch=new ColorPicker.Spectrum.Swatch(toolsContainer);this._hueElement=toolsContainer.createChild('div','spectrum-hue');this._hueSlider=this._hueElement.createChild('div','spectrum-slider');this._alphaElement=toolsContainer.createChild('div','spectrum-alpha');this._alphaElementBackground=this._alphaElement.createChild('div','spectrum-alpha-background');this._alphaSlider=this._alphaElement.createChild('div','spectrum-slider');const displaySwitcher=toolsContainer.createChild('div','spectrum-display-switcher spectrum-switcher');appendSwitcherIcon(displaySwitcher);displaySwitcher.tabIndex=0;self.onInvokeElement(displaySwitcher,event=>{this._formatViewSwitch();event.consume(true);});this._displayContainer=toolsContainer.createChild('div','spectrum-text source-code');this._textValues=[];for(let i=0;i<4;++i){const inputValue=UI.createInput('spectrum-text-value');this._displayContainer.appendChild(inputValue);inputValue.maxLength=4;this._textValues.push(inputValue);inputValue.addEventListener('keydown',this._inputChanged.bind(this),false);inputValue.addEventListener('input',this._inputChanged.bind(this),false);inputValue.addEventListener('mousewheel',this._inputChanged.bind(this),false);}
this._textLabels=this._displayContainer.createChild('div','spectrum-text-label');this._hexContainer=toolsContainer.createChild('div','spectrum-text spectrum-text-hex source-code');this._hexValue=UI.createInput('spectrum-text-value');this._hexContainer.appendChild(this._hexValue);this._hexValue.maxLength=9;this._hexValue.addEventListener('keydown',this._inputChanged.bind(this),false);this._hexValue.addEventListener('input',this._inputChanged.bind(this),false);this._hexValue.addEventListener('mousewheel',this._inputChanged.bind(this),false);const label=this._hexContainer.createChild('div','spectrum-text-label');label.textContent='HEX';UI.installDragHandle(this._hueElement,dragStart.bind(this,positionHue.bind(this)),positionHue.bind(this),null,'pointer','default');UI.installDragHandle(this._alphaElement,dragStart.bind(this,positionAlpha.bind(this)),positionAlpha.bind(this),null,'pointer','default');UI.installDragHandle(this._colorElement,dragStart.bind(this,positionColor.bind(this)),positionColor.bind(this),null,'pointer','default');if(contrastInfo){this._contrastInfo=contrastInfo;this._contrastOverlay=new ColorPicker.ContrastOverlay(this._contrastInfo,this._colorElement);this._contrastDetails=new ColorPicker.ContrastDetails(this._contrastInfo,this.contentElement,this._toggleColorPicker.bind(this),this._contrastPanelExpanded.bind(this));this._contrastDetailsBackgroundColorPickedToggledBound=this._contrastDetailsBackgroundColorPickedToggled.bind(this);}
this.element.classList.add('flex-none');this._palettes=new Map();this._palettePanel=this.contentElement.createChild('div','palette-panel');this._palettePanel.addEventListener('keydown',this._onPalettePanelKeydown.bind(this));this._palettePanelShowing=false;this._paletteSectionContainer=this.contentElement.createChild('div','spectrum-palette-container');this._paletteContainer=this._paletteSectionContainer.createChild('div','spectrum-palette');this._paletteContainer.addEventListener('contextmenu',this._showPaletteColorContextMenu.bind(this,-1));this._shadesContainer=this.contentElement.createChild('div','palette-color-shades hidden');UI.installDragHandle(this._paletteContainer,this._paletteDragStart.bind(this),this._paletteDrag.bind(this),this._paletteDragEnd.bind(this),'default');const paletteSwitcher=this._paletteSectionContainer.createChild('div','spectrum-palette-switcher spectrum-switcher');appendSwitcherIcon(paletteSwitcher);UI.ARIAUtils.markAsButton(paletteSwitcher);UI.ARIAUtils.setAccessibleName(paletteSwitcher,ls`Preview palettes`);paletteSwitcher.tabIndex=0;self.onInvokeElement(paletteSwitcher,event=>{this._togglePalettePanel(true);event.consume(true);});this._deleteIconToolbar=new UI.Toolbar('delete-color-toolbar');this._deleteButton=new UI.ToolbarButton('','largeicon-trash-bin');this._deleteIconToolbar.appendToolbarItem(this._deleteButton);const overlay=this.contentElement.createChild('div','spectrum-overlay fill');overlay.addEventListener('click',this._togglePalettePanel.bind(this,false));this._addColorToolbar=new UI.Toolbar('add-color-toolbar');const addColorButton=new UI.ToolbarButton(Common.UIString('Add to palette'),'largeicon-add');addColorButton.addEventListener(UI.ToolbarButton.Events.Click,this._addColorToCustomPalette,this);this._addColorToolbar.appendToolbarItem(addColorButton);this._colorPickedBound=this._colorPicked.bind(this);this._loadPalettes();new ColorPicker.Spectrum.PaletteGenerator(palette=>{if(palette.colors.length){this.addPalette(palette);}else if(this._selectedColorPalette.get()===palette.title){this._paletteSelected(ColorPicker.Spectrum.MaterialPalette);}});function dragStart(callback,event){this._hueAlphaLeft=this._hueElement.totalOffsetLeft();this._colorOffset=this._colorElement.totalOffset();callback(event);return true;}
function positionHue(event){const hsva=this._hsv.slice();hsva[0]=Number.constrain(1-(event.x-this._hueAlphaLeft)/this._hueAlphaWidth,0,1);this._innerSetColor(hsva,'',undefined,undefined,ColorPicker.Spectrum._ChangeSource.Other);}
function positionAlpha(event){const newAlpha=Math.round((event.x-this._hueAlphaLeft)/this._hueAlphaWidth*100)/100;const hsva=this._hsv.slice();hsva[3]=Number.constrain(newAlpha,0,1);this._innerSetColor(hsva,'',undefined,undefined,ColorPicker.Spectrum._ChangeSource.Other);}
function positionColor(event){const hsva=this._hsv.slice();hsva[1]=Number.constrain((event.x-this._colorOffset.left)/this.dragWidth,0,1);hsva[2]=Number.constrain(1-(event.y-this._colorOffset.top)/this.dragHeight,0,1);this._innerSetColor(hsva,'',undefined,undefined,ColorPicker.Spectrum._ChangeSource.Other);}}
_contrastDetailsBackgroundColorPickedToggled({data:enabled}){if(enabled){this._toggleColorPicker(false);}}
_contrastPanelExpanded(){this._contrastOverlay.setVisible(this._contrastDetails.expanded());this._resizeForSelectedPalette(true);}
_updatePalettePanel(){this._palettePanel.removeChildren();const title=this._palettePanel.createChild('div','palette-title');title.textContent=Common.UIString('Color Palettes');const toolbar=new UI.Toolbar('',this._palettePanel);const closeButton=new UI.ToolbarButton('Return to color picker','largeicon-delete');closeButton.addEventListener(UI.ToolbarButton.Events.Click,this._togglePalettePanel.bind(this,false));toolbar.appendToolbarItem(closeButton);for(const palette of this._palettes.values()){this._palettePanel.appendChild(this._createPreviewPaletteElement(palette));}}
_togglePalettePanel(show){if(this._palettePanelShowing===show){return;}
if(show){this._updatePalettePanel();}
this._palettePanelShowing=show;this.contentElement.classList.toggle('palette-panel-showing',show);this._focus();}
_onPalettePanelKeydown(event){if(isEscKey(event)){this._togglePalettePanel(false);event.consume(true);}}
_focus(){if(!this.isShowing()){return;}
if(this._palettePanelShowing){this._palettePanel.focus({preventScroll:true});}else{this.contentElement.focus();}}
_createPaletteColor(colorText,colorName,animationDelay){const element=createElementWithClass('div','spectrum-palette-color');element.style.background=String.sprintf('linear-gradient(%s, %s), url(Images/checker.png)',colorText,colorText);if(animationDelay){element.animate([{opacity:0},{opacity:1}],{duration:100,delay:animationDelay,fill:'backwards'});}
element.title=colorName||colorText;return element;}
_showPalette(palette,animate,event){this._resizeForSelectedPalette();this._paletteContainer.removeChildren();for(let i=0;i<palette.colors.length;i++){const animationDelay=animate?i*100/palette.colors.length:0;const colorElement=this._createPaletteColor(palette.colors[i],palette.colorNames[i],animationDelay);colorElement.addEventListener('mousedown',this._paletteColorSelected.bind(this,palette.colors[i],palette.colorNames[i],palette.matchUserFormat));colorElement.addEventListener('keydown',this._onPaletteColorKeydown.bind(this,palette.colors[i],palette.colorNames[i],palette.matchUserFormat));if(palette.mutable){colorElement.__mutable=true;colorElement.__color=palette.colors[i];colorElement.addEventListener('contextmenu',this._showPaletteColorContextMenu.bind(this,i));}else if(palette===ColorPicker.Spectrum.MaterialPalette){colorElement.classList.add('has-material-shades');let shadow=colorElement.createChild('div','spectrum-palette-color spectrum-palette-color-shadow');shadow.style.background=palette.colors[i];shadow=colorElement.createChild('div','spectrum-palette-color spectrum-palette-color-shadow');shadow.style.background=palette.colors[i];colorElement.title=ls`${palette.colors[i]}. Long-click to show alternate shades.`;new UI.LongClickController(colorElement,this._showLightnessShades.bind(this,colorElement,palette.colors[i]));}
this._paletteContainer.appendChild(colorElement);}
if(this._paletteContainer.childNodes.length>0){this._paletteContainer.childNodes[0].tabIndex=0;}
this._paletteContainerMutable=palette.mutable;if(palette.mutable){this._paletteContainer.appendChild(this._addColorToolbar.element);this._paletteContainer.appendChild(this._deleteIconToolbar.element);}else{this._addColorToolbar.element.remove();this._deleteIconToolbar.element.remove();}
this._togglePalettePanel(false);this._focus();}
_showLightnessShades(colorElement,colorText,event){function closeLightnessShades(element){this._shadesContainer.classList.add('hidden');element.classList.remove('spectrum-shades-shown');this._shadesContainer.ownerDocument.removeEventListener('mousedown',this._shadesCloseHandler,true);delete this._shadesCloseHandler;}
if(this._shadesCloseHandler){this._shadesCloseHandler();}
this._shadesContainer.classList.remove('hidden');this._shadesContainer.removeChildren();this._shadesContainer.animate([{transform:'scaleY(0)',opacity:'0'},{transform:'scaleY(1)',opacity:'1'}],{duration:200,easing:'cubic-bezier(0.4, 0, 0.2, 1)'});let shadesTop=this._paletteContainer.offsetTop+colorElement.offsetTop+colorElement.parentElement.offsetTop;if(this._contrastDetails){shadesTop+=this._contrastDetails.element().offsetHeight;}
this._shadesContainer.style.top=shadesTop+'px';this._shadesContainer.style.left=colorElement.offsetLeft+'px';colorElement.classList.add('spectrum-shades-shown');const shades=ColorPicker.Spectrum.MaterialPaletteShades[colorText];for(let i=shades.length-1;i>=0;i--){const shadeElement=this._createPaletteColor(shades[i],undefined,i*200/shades.length+100);shadeElement.addEventListener('mousedown',this._paletteColorSelected.bind(this,shades[i],shades[i],false));this._shadesContainer.appendChild(shadeElement);}
this._shadesContainer.focus();this._shadesCloseHandler=closeLightnessShades.bind(this,colorElement);this._shadesContainer.ownerDocument.addEventListener('mousedown',this._shadesCloseHandler,true);}
_slotIndexForEvent(e){const localX=e.pageX-this._paletteContainer.totalOffsetLeft();const localY=e.pageY-this._paletteContainer.totalOffsetTop();const col=Math.min(localX/ColorPicker.Spectrum._colorChipSize|0,ColorPicker.Spectrum._itemsPerPaletteRow-1);const row=(localY/ColorPicker.Spectrum._colorChipSize)|0;return Math.min(row*ColorPicker.Spectrum._itemsPerPaletteRow+col,this._customPaletteSetting.get().colors.length-1);}
_isDraggingToBin(e){return e.pageX>this._deleteIconToolbar.element.totalOffsetLeft();}
_paletteDragStart(e){const element=e.deepElementFromPoint();if(!element||!element.__mutable){return false;}
const index=this._slotIndexForEvent(e);this._dragElement=element;this._dragHotSpotX=e.pageX-(index%ColorPicker.Spectrum._itemsPerPaletteRow)*ColorPicker.Spectrum._colorChipSize;this._dragHotSpotY=e.pageY-(index/ColorPicker.Spectrum._itemsPerPaletteRow|0)*ColorPicker.Spectrum._colorChipSize;return true;}
_paletteDrag(e){if(e.pageX<this._paletteContainer.totalOffsetLeft()||e.pageY<this._paletteContainer.totalOffsetTop()){return;}
const newIndex=this._slotIndexForEvent(e);const offsetX=e.pageX-(newIndex%ColorPicker.Spectrum._itemsPerPaletteRow)*ColorPicker.Spectrum._colorChipSize;const offsetY=e.pageY-(newIndex/ColorPicker.Spectrum._itemsPerPaletteRow|0)*ColorPicker.Spectrum._colorChipSize;const isDeleting=this._isDraggingToBin(e);this._deleteIconToolbar.element.classList.add('dragging');this._deleteIconToolbar.element.classList.toggle('delete-color-toolbar-active',isDeleting);const dragElementTransform='translateX('+(offsetX-this._dragHotSpotX)+'px) translateY('+(offsetY-this._dragHotSpotY)+'px)';this._dragElement.style.transform=isDeleting?dragElementTransform+' scale(0.8)':dragElementTransform;const children=Array.prototype.slice.call(this._paletteContainer.children);const index=children.indexOf(this._dragElement);const swatchOffsets=new Map();for(const swatch of children){swatchOffsets.set(swatch,swatch.totalOffset());}
if(index!==newIndex){this._paletteContainer.insertBefore(this._dragElement,children[newIndex>index?newIndex+1:newIndex]);}
for(const swatch of children){if(swatch===this._dragElement){continue;}
const before=swatchOffsets.get(swatch);const after=swatch.totalOffset();if(before.left!==after.left||before.top!==after.top){swatch.animate([{transform:'translateX('+(before.left-after.left)+'px) translateY('+(before.top-after.top)+'px)'},{transform:'none'}],{duration:100,easing:'cubic-bezier(0, 0, 0.2, 1)'});}}}
_paletteDragEnd(e){if(this._isDraggingToBin(e)){this._dragElement.remove();}
this._dragElement.style.removeProperty('transform');const children=this._paletteContainer.children;const colors=[];for(let i=0;i<children.length;++i){if(children[i].__color){colors.push(children[i].__color);}}
const palette=this._customPaletteSetting.get();palette.colors=colors;this._customPaletteSetting.set(palette);this._showPalette(this._customPaletteSetting.get(),false);this._deleteIconToolbar.element.classList.remove('dragging');this._deleteIconToolbar.element.classList.remove('delete-color-toolbar-active');}
_loadPalettes(){this._palettes.set(ColorPicker.Spectrum.MaterialPalette.title,ColorPicker.Spectrum.MaterialPalette);const defaultCustomPalette={title:'Custom',colors:[],colorNames:[],mutable:true};this._customPaletteSetting=Common.settings.createSetting('customColorPalette',defaultCustomPalette);const customPalette=this._customPaletteSetting.get();customPalette.colorNames=customPalette.colorNames||[];this._palettes.set(customPalette.title,customPalette);this._selectedColorPalette=Common.settings.createSetting('selectedColorPalette',ColorPicker.Spectrum.GeneratedPaletteTitle);const palette=this._palettes.get(this._selectedColorPalette.get());if(palette){this._showPalette(palette,true);}}
addPalette(palette){this._palettes.set(palette.title,palette);if(this._selectedColorPalette.get()===palette.title){this._showPalette(palette,true);}}
_createPreviewPaletteElement(palette){const colorsPerPreviewRow=5;const previewElement=createElementWithClass('div','palette-preview');UI.ARIAUtils.markAsButton(previewElement);previewElement.tabIndex=0;const titleElement=previewElement.createChild('div','palette-preview-title');titleElement.textContent=palette.title;let i;for(i=0;i<colorsPerPreviewRow&&i<palette.colors.length;i++){previewElement.appendChild(this._createPaletteColor(palette.colors[i],palette.colorNames[i]));}
for(;i<colorsPerPreviewRow;i++){previewElement.createChild('div','spectrum-palette-color empty-color');}
self.onInvokeElement(previewElement,event=>{this._paletteSelected(palette);event.consume(true);});return previewElement;}
_paletteSelected(palette){this._selectedColorPalette.set(palette.title);this._showPalette(palette,true);}
_resizeForSelectedPalette(force){const palette=this._palettes.get(this._selectedColorPalette.get());if(!palette){return;}
let numColors=palette.colors.length;if(palette===this._customPaletteSetting.get()){numColors++;}
const rowsNeeded=Math.max(1,Math.ceil(numColors/ColorPicker.Spectrum._itemsPerPaletteRow));if(this._numPaletteRowsShown===rowsNeeded&&!force){return;}
this._numPaletteRowsShown=rowsNeeded;const paletteColorHeight=12;const paletteMargin=12;let paletteTop=236;if(this._contrastDetails){if(this._contrastDetails.expanded()){paletteTop+=78;}else{paletteTop+=36;}}
this.element.style.height=(paletteTop+paletteMargin+(paletteColorHeight+paletteMargin)*rowsNeeded)+'px';this.dispatchEventToListeners(ColorPicker.Spectrum.Events.SizeChanged);}
_paletteColorSelected(colorText,colorName,matchUserFormat){const color=Common.Color.parse(colorText);if(!color){return;}
this._innerSetColor(color.hsva(),colorText,colorName,matchUserFormat?this._colorFormat:color.format(),ColorPicker.Spectrum._ChangeSource.Other);}
_onPaletteColorKeydown(colorText,colorName,matchUserFormat,event){if(isEnterOrSpaceKey(event)){this._paletteColorSelected(colorText,colorName,matchUserFormat);event.stopPropagation();}else if(event.key==='ArrowLeft'&&event.target.previousElementSibling){event.target.previousElementSibling.focus();event.consume(true);}else if(event.key==='ArrowRight'&&event.target.nextElementSibling){event.target.nextElementSibling.focus();event.consume(true);}}
_addColorToCustomPalette(event){const palette=this._customPaletteSetting.get();palette.colors.push(this.colorString());this._customPaletteSetting.set(palette);this._showPalette(this._customPaletteSetting.get(),false);}
_showPaletteColorContextMenu(colorIndex,event){if(!this._paletteContainerMutable){return;}
const contextMenu=new UI.ContextMenu(event);if(colorIndex!==-1){contextMenu.defaultSection().appendItem(Common.UIString('Remove color'),this._deletePaletteColors.bind(this,colorIndex,false));contextMenu.defaultSection().appendItem(Common.UIString('Remove all to the right'),this._deletePaletteColors.bind(this,colorIndex,true));}
contextMenu.defaultSection().appendItem(Common.UIString('Clear palette'),this._deletePaletteColors.bind(this,-1,true));contextMenu.show();}
_deletePaletteColors(colorIndex,toRight){const palette=this._customPaletteSetting.get();if(toRight){palette.colors.splice(colorIndex+1,palette.colors.length-colorIndex-1);}else{palette.colors.splice(colorIndex,1);}
this._customPaletteSetting.set(palette);this._showPalette(this._customPaletteSetting.get(),false);}
setColor(color,colorFormat){this._originalFormat=colorFormat;this._innerSetColor(color.hsva(),'',undefined,colorFormat,ColorPicker.Spectrum._ChangeSource.Model);}
_innerSetColor(hsva,colorString,colorName,colorFormat,changeSource){if(hsva!==undefined){this._hsv=hsva;}
this._colorName=colorName;if(colorString!==undefined){this._colorString=colorString;}
if(colorFormat!==undefined){const cf=Common.Color.Format;console.assert(colorFormat!==cf.Original,'Spectrum\'s color format cannot be Original');if(colorFormat===cf.RGBA){colorFormat=cf.RGB;}else if(colorFormat===cf.HSLA){colorFormat=cf.HSL;}else if(colorFormat===cf.HEXA){colorFormat=cf.HEX;}else if(colorFormat===cf.ShortHEXA){colorFormat=cf.ShortHEX;}
this._colorFormat=colorFormat;}
if(hsva&&this._contrastInfo){this._contrastInfo.setColor(Common.Color.fromHSVA(hsva));}
this._updateHelperLocations();this._updateUI();if(changeSource!==ColorPicker.Spectrum._ChangeSource.Input){this._updateInput();}
if(changeSource!==ColorPicker.Spectrum._ChangeSource.Model){this.dispatchEventToListeners(ColorPicker.Spectrum.Events.ColorChanged,this.colorString());}}
_color(){return Common.Color.fromHSVA(this._hsv);}
colorName(){return this._colorName;}
colorString(){if(this._colorString){return this._colorString;}
const cf=Common.Color.Format;const color=this._color();let colorString=color.asString(this._colorFormat);if(colorString){return colorString;}
if(this._colorFormat===cf.Nickname){colorString=color.asString(color.hasAlpha()?cf.HEXA:cf.HEX);}else if(this._colorFormat===cf.ShortHEX){colorString=color.asString(color.detectHEXFormat());}else if(this._colorFormat===cf.HEX){colorString=color.asString(cf.HEXA);}else if(this._colorFormat===cf.HSL){colorString=color.asString(cf.HSLA);}else{colorString=color.asString(cf.RGBA);}
console.assert(colorString);return colorString||'';}
_updateHelperLocations(){const h=this._hsv[0];const s=this._hsv[1];const v=this._hsv[2];const alpha=this._hsv[3];this._dragX=s*this.dragWidth;this._dragY=this.dragHeight-(v*this.dragHeight);const dragX=Math.max(-this._colorDragElementHeight,Math.min(this.dragWidth-this._colorDragElementHeight,this._dragX-this._colorDragElementHeight));const dragY=Math.max(-this._colorDragElementHeight,Math.min(this.dragHeight-this._colorDragElementHeight,this._dragY-this._colorDragElementHeight));this._colorDragElement.positionAt(dragX,dragY);const hueSlideX=(1-h)*this._hueAlphaWidth-this.slideHelperWidth;this._hueSlider.style.left=hueSlideX+'px';const alphaSlideX=alpha*this._hueAlphaWidth-this.slideHelperWidth;this._alphaSlider.style.left=alphaSlideX+'px';}
_updateInput(){const cf=Common.Color.Format;if(this._colorFormat===cf.HEX||this._colorFormat===cf.ShortHEX||this._colorFormat===cf.Nickname){this._hexContainer.hidden=false;this._displayContainer.hidden=true;if(this._colorFormat===cf.ShortHEX){this._hexValue.value=this._color().asString(this._color().detectHEXFormat());}else{this._hexValue.value=this._color().asString(this._color().hasAlpha()?cf.HEXA:cf.HEX);}}else{this._hexContainer.hidden=true;this._displayContainer.hidden=false;const isRgb=this._colorFormat===cf.RGB;this._textLabels.textContent=isRgb?'RGBA':'HSLA';const colorValues=isRgb?this._color().canonicalRGBA():this._color().canonicalHSLA();for(let i=0;i<3;++i){this._textValues[i].value=colorValues[i];if(!isRgb&&(i===1||i===2)){this._textValues[i].value+='%';}}
this._textValues[3].value=Math.round(colorValues[3]*100)/100;}}
_updateUI(){const h=Common.Color.fromHSVA([this._hsv[0],1,1,1]);this._colorElement.style.backgroundColor=(h.asString(Common.Color.Format.RGB));if(this._contrastOverlay){this._contrastOverlay.setDimensions(this.dragWidth,this.dragHeight);}
this._swatch.setColor(this._color(),this.colorString());this._colorDragElement.style.backgroundColor=(this._color().asString(Common.Color.Format.RGBA));const noAlpha=Common.Color.fromHSVA(this._hsv.slice(0,3).concat(1));this._alphaElementBackground.style.backgroundImage=String.sprintf('linear-gradient(to right, rgba(0,0,0,0), %s)',noAlpha.asString(Common.Color.Format.RGB));}
_formatViewSwitch(){const cf=Common.Color.Format;let format=cf.RGB;if(this._colorFormat===cf.RGB){format=cf.HSL;}else if(this._colorFormat===cf.HSL){format=(this._originalFormat===cf.ShortHEX||this._originalFormat===cf.ShortHEXA)?cf.ShortHEX:cf.HEX;}
this._innerSetColor(undefined,'',undefined,format,ColorPicker.Spectrum._ChangeSource.Other);}
_inputChanged(event){function elementValue(element){return element.value;}
const inputElement=(event.currentTarget);const newValue=UI.createReplacementString(inputElement.value,event);if(newValue){inputElement.value=newValue;inputElement.selectionStart=0;inputElement.selectionEnd=newValue.length;event.consume(true);}
const cf=Common.Color.Format;let colorString;if(this._colorFormat===cf.Nickname||this._colorFormat===cf.HEX||this._colorFormat===cf.ShortHEX){colorString=this._hexValue.value;}else{const format=this._colorFormat===cf.RGB?'rgba':'hsla';const values=this._textValues.map(elementValue).join(', ');colorString=String.sprintf('%s(%s)',format,values);}
const color=Common.Color.parse(colorString);if(!color){return;}
let colorFormat=undefined;if(this._colorFormat===cf.HEX||this._colorFormat===cf.ShortHEX){colorFormat=color.detectHEXFormat();}
this._innerSetColor(color.hsva(),colorString,undefined,colorFormat,ColorPicker.Spectrum._ChangeSource.Input);}
wasShown(){this._hueAlphaWidth=this._hueElement.offsetWidth;this.slideHelperWidth=this._hueSlider.offsetWidth/2;this.dragWidth=this._colorElement.offsetWidth;this.dragHeight=this._colorElement.offsetHeight;this._colorDragElementHeight=this._colorDragElement.offsetHeight/2;this._innerSetColor(undefined,undefined,undefined,undefined,ColorPicker.Spectrum._ChangeSource.Model);this._toggleColorPicker(true);if(this._contrastDetails){this._contrastDetails.addEventListener(ColorPicker.ContrastDetails.Events.BackgroundColorPickerWillBeToggled,this._contrastDetailsBackgroundColorPickedToggledBound);}}
willHide(){this._toggleColorPicker(false);if(this._contrastDetails){this._contrastDetails.removeEventListener(ColorPicker.ContrastDetails.Events.BackgroundColorPickerWillBeToggled,this._contrastDetailsBackgroundColorPickedToggledBound);}}
_toggleColorPicker(enabled,event){if(enabled===undefined){enabled=!this._colorPickerButton.toggled();}
this._colorPickerButton.setToggled(enabled);if(this._contrastDetails&&enabled&&this._contrastDetails.backgroundColorPickerEnabled()){this._contrastDetails.toggleBackgroundColorPicker(false);}
Host.InspectorFrontendHost.setEyeDropperActive(enabled);if(enabled){Host.InspectorFrontendHost.events.addEventListener(Host.InspectorFrontendHostAPI.Events.EyeDropperPickedColor,this._colorPickedBound);}else{Host.InspectorFrontendHost.events.removeEventListener(Host.InspectorFrontendHostAPI.Events.EyeDropperPickedColor,this._colorPickedBound);}}
_colorPicked(event){const rgbColor=(event.data);const rgba=[rgbColor.r,rgbColor.g,rgbColor.b,(rgbColor.a/2.55|0)/100];const color=Common.Color.fromRGBA(rgba);this._innerSetColor(color.hsva(),'',undefined,undefined,ColorPicker.Spectrum._ChangeSource.Other);Host.InspectorFrontendHost.bringToFront();}};ColorPicker.Spectrum._ChangeSource={Input:'Input',Model:'Model',Other:'Other'};ColorPicker.Spectrum.Events={ColorChanged:Symbol('ColorChanged'),SizeChanged:Symbol('SizeChanged')};ColorPicker.Spectrum._colorChipSize=24;ColorPicker.Spectrum._itemsPerPaletteRow=8;ColorPicker.Spectrum.Palette;ColorPicker.Spectrum.GeneratedPaletteTitle='Page colors';ColorPicker.Spectrum.PaletteGenerator=class{constructor(callback){this._callback=callback;this._frequencyMap=new Map();const stylesheetPromises=[];for(const cssModel of SDK.targetManager.models(SDK.CSSModel)){for(const stylesheet of cssModel.allStyleSheets()){stylesheetPromises.push(this._processStylesheet(stylesheet));}}
Promise.all(stylesheetPromises).catchException(null).then(this._finish.bind(this));}
_frequencyComparator(a,b){return this._frequencyMap.get(b)-this._frequencyMap.get(a);}
_finish(){function hueComparator(a,b){const hsva=paletteColors.get(a).hsva();const hsvb=paletteColors.get(b).hsva();if(hsvb[1]<0.12&&hsva[1]<0.12){return hsvb[2]*hsvb[3]-hsva[2]*hsva[3];}
if(hsvb[1]<0.12){return-1;}
if(hsva[1]<0.12){return 1;}
if(hsvb[0]===hsva[0]){return hsvb[1]*hsvb[3]-hsva[1]*hsva[3];}
return(hsvb[0]+0.94)%1-(hsva[0]+0.94)%1;}
let colors=this._frequencyMap.keysArray();colors=colors.sort(this._frequencyComparator.bind(this));const paletteColors=new Map();const colorsPerRow=24;while(paletteColors.size<colorsPerRow&&colors.length){const colorText=colors.shift();const color=Common.Color.parse(colorText);if(!color||color.nickname()==='white'||color.nickname()==='black'){continue;}
paletteColors.set(colorText,color);}
this._callback({title:ColorPicker.Spectrum.GeneratedPaletteTitle,colors:paletteColors.keysArray().sort(hueComparator),colorNames:[],mutable:false});}
async _processStylesheet(stylesheet){let text=(await stylesheet.requestContent()).content||'';text=text.toLowerCase();const regexResult=text.match(/((?:rgb|hsl)a?\([^)]+\)|#[0-9a-f]{6}|#[0-9a-f]{3})/g)||[];for(const c of regexResult){let frequency=this._frequencyMap.get(c)||0;this._frequencyMap.set(c,++frequency);}}};ColorPicker.Spectrum.MaterialPaletteShades={'#F44336':['#FFEBEE','#FFCDD2','#EF9A9A','#E57373','#EF5350','#F44336','#E53935','#D32F2F','#C62828','#B71C1C'],'#E91E63':['#FCE4EC','#F8BBD0','#F48FB1','#F06292','#EC407A','#E91E63','#D81B60','#C2185B','#AD1457','#880E4F'],'#9C27B0':['#F3E5F5','#E1BEE7','#CE93D8','#BA68C8','#AB47BC','#9C27B0','#8E24AA','#7B1FA2','#6A1B9A','#4A148C'],'#673AB7':['#EDE7F6','#D1C4E9','#B39DDB','#9575CD','#7E57C2','#673AB7','#5E35B1','#512DA8','#4527A0','#311B92'],'#3F51B5':['#E8EAF6','#C5CAE9','#9FA8DA','#7986CB','#5C6BC0','#3F51B5','#3949AB','#303F9F','#283593','#1A237E'],'#2196F3':['#E3F2FD','#BBDEFB','#90CAF9','#64B5F6','#42A5F5','#2196F3','#1E88E5','#1976D2','#1565C0','#0D47A1'],'#03A9F4':['#E1F5FE','#B3E5FC','#81D4FA','#4FC3F7','#29B6F6','#03A9F4','#039BE5','#0288D1','#0277BD','#01579B'],'#00BCD4':['#E0F7FA','#B2EBF2','#80DEEA','#4DD0E1','#26C6DA','#00BCD4','#00ACC1','#0097A7','#00838F','#006064'],'#009688':['#E0F2F1','#B2DFDB','#80CBC4','#4DB6AC','#26A69A','#009688','#00897B','#00796B','#00695C','#004D40'],'#4CAF50':['#E8F5E9','#C8E6C9','#A5D6A7','#81C784','#66BB6A','#4CAF50','#43A047','#388E3C','#2E7D32','#1B5E20'],'#8BC34A':['#F1F8E9','#DCEDC8','#C5E1A5','#AED581','#9CCC65','#8BC34A','#7CB342','#689F38','#558B2F','#33691E'],'#CDDC39':['#F9FBE7','#F0F4C3','#E6EE9C','#DCE775','#D4E157','#CDDC39','#C0CA33','#AFB42B','#9E9D24','#827717'],'#FFEB3B':['#FFFDE7','#FFF9C4','#FFF59D','#FFF176','#FFEE58','#FFEB3B','#FDD835','#FBC02D','#F9A825','#F57F17'],'#FFC107':['#FFF8E1','#FFECB3','#FFE082','#FFD54F','#FFCA28','#FFC107','#FFB300','#FFA000','#FF8F00','#FF6F00'],'#FF9800':['#FFF3E0','#FFE0B2','#FFCC80','#FFB74D','#FFA726','#FF9800','#FB8C00','#F57C00','#EF6C00','#E65100'],'#FF5722':['#FBE9E7','#FFCCBC','#FFAB91','#FF8A65','#FF7043','#FF5722','#F4511E','#E64A19','#D84315','#BF360C'],'#795548':['#EFEBE9','#D7CCC8','#BCAAA4','#A1887F','#8D6E63','#795548','#6D4C41','#5D4037','#4E342E','#3E2723'],'#9E9E9E':['#FAFAFA','#F5F5F5','#EEEEEE','#E0E0E0','#BDBDBD','#9E9E9E','#757575','#616161','#424242','#212121'],'#607D8B':['#ECEFF1','#CFD8DC','#B0BEC5','#90A4AE','#78909C','#607D8B','#546E7A','#455A64','#37474F','#263238']};ColorPicker.Spectrum.MaterialPalette={title:'Material',mutable:false,matchUserFormat:true,colors:Object.keys(ColorPicker.Spectrum.MaterialPaletteShades),colorNames:[]};ColorPicker.Spectrum.Swatch=class{constructor(parentElement){this._colorString;const swatchElement=parentElement.createChild('span','swatch');this._swatchInnerElement=swatchElement.createChild('span','swatch-inner');this._swatchOverlayElement=swatchElement.createChild('span','swatch-overlay');UI.ARIAUtils.markAsButton(this._swatchOverlayElement);UI.ARIAUtils.setPressed(this._swatchOverlayElement,false);this._swatchOverlayElement.tabIndex=0;self.onInvokeElement(this._swatchOverlayElement,this._onCopyText.bind(this));this._swatchOverlayElement.addEventListener('mouseout',this._onCopyIconMouseout.bind(this));this._swatchOverlayElement.addEventListener('blur',this._onCopyIconMouseout.bind(this));this._swatchCopyIcon=UI.Icon.create('largeicon-copy','copy-color-icon');this._swatchCopyIcon.title=ls`Copy color to clipboard`;this._swatchOverlayElement.appendChild(this._swatchCopyIcon);UI.ARIAUtils.setAccessibleName(this._swatchOverlayElement,this._swatchCopyIcon.title);}
setColor(color,colorString){this._swatchInnerElement.style.backgroundColor=(color.asString(Common.Color.Format.RGBA));this._swatchInnerElement.classList.toggle('swatch-inner-white',color.hsla()[2]>0.9);this._colorString=colorString||null;if(colorString){this._swatchOverlayElement.hidden=false;}else{this._swatchOverlayElement.hidden=true;}}
_onCopyText(event){this._swatchCopyIcon.setIconType('largeicon-checkmark');Host.InspectorFrontendHost.copyText(this._colorString);UI.ARIAUtils.setPressed(this._swatchOverlayElement,true);event.consume();}
_onCopyIconMouseout(){this._swatchCopyIcon.setIconType('largeicon-copy');UI.ARIAUtils.setPressed(this._swatchOverlayElement,false);}};;Root.Runtime.cachedResources["color_picker/spectrum.css"]="/* https://github.com/bgrins/spectrum */\n:host {\n    width: 232px;\n    height: 319px;\n    -webkit-user-select: none;\n    overflow: hidden;\n}\n\n:selection {\n    background-color: blue;\n    color: white;\n}\n\n.spectrum-color {\n    position: relative;\n    width: 232px;\n    height: 124px;\n    border-radius: 2px 2px 0 0;\n    overflow: hidden;\n    flex: none;\n}\n\n.spectrum-tools {\n    position: relative;\n    height: 111px;\n    width: 100%;\n    flex: none;\n}\n\n.spectrum-hue {\n    top: 16px;\n}\n\n.spectrum-alpha {\n    top: 35px;\n    background-image: url(Images/checker.png);\n    background-size: 12px 11px;\n}\n\n.spectrum-alpha-background {\n    height: 100%;\n    border-radius: 2px;\n}\n\n.spectrum-hue, .spectrum-alpha {\n    position: absolute;\n    left: 86px;\n    width: 130px;\n    height: 11px;\n    border-radius: 2px;\n}\n\n.spectrum-dragger,\n.spectrum-slider {\n    -webkit-user-select: none;\n}\n\n.spectrum-sat,\n.-theme-preserve {\n    background-image: linear-gradient(to right, white, rgba(204, 154, 129, 0));\n}\n\n.spectrum-val,\n.-theme-preserve {\n    background-image: linear-gradient(to top, black, rgba(204, 154, 129, 0));\n}\n\n.spectrum-hue {\n    background: linear-gradient(to left, #ff0000 0%, #ffff00 17%, #00ff00 33%, #00ffff 50%, #0000ff 67%, #ff00ff 83%, #ff0000 100%);\n}\n\n.spectrum-dragger {\n    border-radius: 12px;\n    height: 12px;\n    width: 12px;\n    border: 1px solid white;\n    cursor: pointer;\n    position: absolute;\n    top: 0;\n    left: 0;\n    background: black;\n    box-shadow: 0 0 2px 0px rgba(0, 0, 0, 0.24);\n}\n\n.spectrum-slider {\n    position: absolute;\n    top: -1px;\n    cursor: pointer;\n    width: 13px;\n    height: 13px;\n    border-radius: 13px;\n    background-color: rgb(248, 248, 248);\n    box-shadow: 0 1px 4px 0 rgba(0, 0, 0, 0.37);\n}\n\n.spectrum-contrast-details {\n    position: relative;\n    background-color: white;\n    width: 100%;\n    height: 111px;\n    top: 0;\n    font-size: 13px;\n    color: #333;\n    border-top: var(--divider-border);\n    line-height: initial;\n    overflow: hidden;\n    flex: none;\n}\n\n.spectrum-contrast-details {\n    height: 78px;\n    flex: none;\n}\n\n.spectrum-contrast-details.collapsed {\n    height: 36px;\n    flex: none;\n}\n\n.spectrum-contrast-details div.toolbar.expand {\n    position: absolute;\n    right: 6px;\n    top: 6px;\n    margin: 0;\n}\n\n.spectrum-contrast-details .toolbar-state-on [is=ui-icon] {\n    background-color: rgb(110, 110, 110);\n}\n\n.spectrum-contrast-details.visible {\n    display: initial;\n}\n\n.spectrum-contrast-details div.container {\n    margin: 10px;\n}\n\n.spectrum-contrast-details.collapsed .expanded-details {\n    display: none;\n}\n\n.spectrum-contrast-details .expanded-details {\n    display: flex;\n    margin: 12px 12px 0 4px;\n}\n\n.contrast-pass-fail {\n    margin-left: 0.5em;\n}\n\n.spectrum-contrast-details .contrast-choose-bg-color,\n.spectrum-contrast-details .contrast-thresholds {\n    width: 145px;\n}\n\n.contrast-choose-bg-color {\n    margin: 8px 0 0 5px;\n    font-style: italic;\n}\n\n.contrast-link-label {\n    cursor: pointer;\n}\n\n.contrast-link-label:hover {\n    text-decoration: underline;\n}\n\n.spectrum-contrast-details .background-color {\n    position: absolute;\n    flex: none;\n    right: 12px;\n}\n\n.spectrum-contrast-details .spectrum-eye-dropper {\n    top: 2px;\n    right: 34px;\n    position: absolute;\n    left: auto;\n}\n\n.contrast-details-value {\n    color: #333;\n    margin: 1px 5px;\n    user-select: text;\n}\n\n.contrast-details-value [is=ui-icon] {\n    display: none;\n    margin-left: 5px;\n    background-color: #333;\n}\n\n[is=ui-icon].smallicon-no {\n    background-color: red;\n}\n\n.contrast-pass-fail span[is=ui-icon] {\n    margin-left: 5px;\n}\n\n[is=ui-icon].smallicon-checkmark-square,\n[is=ui-icon].smallicon-checkmark-behind {\n    background-color: #00b06f;\n}\n\n.spectrum-contrast-details .contrast-details-value.contrast-unknown {\n    background-color: white;\n    color: #333;\n    width: 3em;\n    text-align: center;\n}\n\n.contrast-details-value .smallicon-checkmark-behind {\n    margin-left: -6px;\n}\n\n.spectrum-contrast-details.contrast-fail .contrast-details-value .smallicon-no,\n.contrast-details-value.contrast-aa .smallicon-checkmark-square,\n.contrast-details-value.contrast-aaa .smallicon-checkmark-behind {\n    display: inline-block;\n}\n\n\n.contrast-details-value .smallicon-no,\n.contrast-details-value .smallicon-checkmark-square,\n.contrast-details-value .smallicon-checkmark-behind {\n    cursor: pointer;\n}\n\n.swatch {\n    width: 32px;\n    height: 32px;\n    margin: 0;\n    position: absolute;\n    top: 15px;\n    left: 44px;\n    background-image: url(Images/checker.png);\n    border-radius: 16px;\n}\n\n.swatch-inner,\n.swatch-overlay {\n    position: absolute;\n    width: 100%;\n    height: 100%;\n    display: inline-block;\n    border-radius: 16px;\n}\n\n.swatch-inner-white {\n    border: 1px solid #ddd;\n}\n\n.swatch-overlay {\n    cursor: pointer;\n    opacity: 0;\n    padding: 4px;\n}\n\n.swatch-overlay:hover,\n.swatch-overlay[data-keyboard-focus=\"true\"]:focus {\n    background-color: rgba(0, 0, 0, .3);\n    opacity: 1;\n}\n\n.swatch-overlay:active {\n    background-color: rgba(0, 0, 0, .5);\n}\n\n[is=ui-icon].icon-mask.copy-color-icon {\n    background-color: white;\n}\n\n.spectrum-text {\n    position: absolute;\n    top: 60px;\n    left: 16px;\n}\n\n.spectrum-text-value {\n    display: inline-block;\n    width: 40px;\n    overflow: hidden;\n    text-align: center;\n    margin-right: 6px;\n    line-height: 20px;\n    padding: 0;\n    color: #333;\n    white-space: nowrap;\n    box-shadow: var(--focus-ring-inactive-shadow);\n}\n\n.spectrum-text-label {\n    letter-spacing: 39.5px;\n    margin-top: 8px;\n    display: block;\n    color: #969696;\n    margin-left: 16px;\n    width: 174px;\n}\n\n.spectrum-text-hex > .spectrum-text-value {\n    width: 178px;\n}\n\n.spectrum-text-hex > .spectrum-text-label {\n    letter-spacing: normal;\n    margin-left: 0px;\n    text-align: center;\n}\n\n.spectrum-switcher {\n    border-radius: 2px;\n    height: 20px;\n    width: 20px;\n    padding: 2px;\n}\n\n:host-context(.-theme-with-dark-background) .spectrum-switcher {\n    -webkit-filter: invert(60%);\n}\n\n.spectrum-display-switcher {\n    top: 72px;\n    position: absolute;\n    right: 10px;\n}\n\n.spectrum-switcher:hover {\n    background-color: #EEEEEE;\n}\n\n.spectrum-switcher[data-keyboard-focus=\"true\"]:focus {\n  background-color: var(--focus-bg-color);\n}\n\n.spectrum-eye-dropper {\n    width: 32px;\n    height: 24px;\n    position: relative;\n    left: 8px;\n    top: 17px;\n    cursor: pointer;\n}\n\n.spectrum-palette-container {\n    border-top: var(--divider-border);\n    position: relative;\n    width: 100%;\n    padding: 6px 24px 6px 6px;\n    display: flex;\n    flex-wrap: wrap;\n}\n\n.spectrum-palette {\n    display: flex;\n    flex-wrap: wrap;\n    width: 198px;\n}\n\n.spectrum-palette-color {\n    width: 12px;\n    height: 12px;\n    flex: 0 0 12px;\n    border-radius: 2px;\n    margin: 6px;\n    cursor: pointer;\n    position: relative;\n    border: 1px solid rgba(0, 0, 0, 0.1);\n    background-position: -1px !important;\n    z-index: 14;\n}\n\n.spectrum-palette-color:hover:not(.spectrum-shades-shown) > .spectrum-palette-color-shadow,\n.spectrum-palette-color:focus:not(.spectrum-shades-shown) > .spectrum-palette-color-shadow {\n    opacity: 0.2;\n}\n\n.spectrum-palette-color:hover:not(.spectrum-shades-shown) > .spectrum-palette-color-shadow:first-child,\n.spectrum-palette-color:focus:not(.spectrum-shades-shown) > .spectrum-palette-color-shadow:first-child {\n    opacity: 0.6;\n    top: -3px;\n    left: 1px;\n}\n\n.spectrum-palette-color-shadow {\n    position: absolute;\n    opacity: 0;\n    margin: 0;\n    top: -5px;\n    left: 3px;\n}\n\n.palette-color-shades {\n    position: absolute;\n    background-color: white;\n    height: 228px;\n    width: 28px;\n    box-shadow: 0 4px 5px 0 rgba(0, 0, 0, 0.14), 0 1px 10px 0 rgba(0, 0, 0, 0.12), 0 2px 4px -1px rgba(0, 0, 0, 0.4);\n    z-index: 14;\n    border-radius: 2px;\n    transform-origin: 0px 228px;\n    margin-top: 16px;\n    margin-left: -8px;\n}\n\n.spectrum-palette > .spectrum-palette-color.spectrum-shades-shown {\n    z-index: 15;\n}\n\n.palette-color-shades > .spectrum-palette-color {\n    margin: 8px 0 0 0;\n    margin-left: 8px;\n    width: 12px;\n}\n\n.spectrum-palette > .spectrum-palette-color {\n    transition: transform 100ms cubic-bezier(0, 0, 0.2, 1);\n    will-change: transform;\n    z-index: 13;\n}\n\n.spectrum-palette > .spectrum-palette-color.empty-color {\n    border-color: transparent;\n}\n\n.spectrum-palette > .spectrum-palette-color:not(.empty-color):not(.has-material-shades):hover,\n.palette-color-shades > .spectrum-palette-color:not(.empty-color):hover {\n    transform: scale(1.15);\n}\n\n.add-color-toolbar {\n    margin-left: -3px;\n    margin-top: -1px;\n}\n\n.spectrum-palette-switcher {\n    right: 10px;\n    top: 0;\n    margin-top: 9px;\n    position: absolute;\n}\n\n.palette-panel {\n    width: 100%;\n    height: 100%;\n    position: absolute;\n    top: 100%;\n    display: flex;\n    flex-direction: column;\n    background-color: white;\n    z-index: 14;\n    transition: transform 200ms cubic-bezier(0, 0, 0.2, 1), visibility 0s 200ms;\n    border-top: var(--divider-border);\n    visibility: hidden;\n}\n\n.palette-panel-showing > .palette-panel {\n    transform: translateY(calc(-100% + 104px));\n    transition-delay: 0s;\n    visibility: visible;\n}\n\n.palette-panel > div.toolbar {\n    position: absolute;\n    right: 6px;\n    top: 6px;\n}\n\n.palette-panel > div:not(.toolbar) {\n    flex: 0 0 38px;\n    border-bottom: var(--divider-border);\n    padding: 12px;\n    line-height: 14px;\n    color: #333;\n}\n\n.palette-panel > div.palette-title {\n    font-size: 14px;\n    line-height: 16px;\n    color: #333;\n    flex-basis: 40px;\n}\n\ndiv.palette-preview {\n    display: flex;\n    cursor: pointer;\n}\n\n.palette-preview-title {\n    flex: 0 0 84px;\n}\n\n.palette-preview > .spectrum-palette-color {\n    margin-top: 1px;\n}\n\n.palette-preview[data-keyboard-focus=\"true\"]:focus,\n.palette-preview:hover {\n    background-color: #eee;\n}\n\n.spectrum-overlay {\n    z-index: 13;\n    visibility: hidden;\n    background-color: hsla(0, 0%, 0%, 0.5);\n    opacity: 0;\n    transition: opacity 100ms cubic-bezier(0, 0, 0.2, 1), visibility 0s 100ms;\n}\n\n.palette-panel-showing > .spectrum-overlay {\n    transition-delay: 0s;\n    visibility: visible;\n    opacity: 1;\n}\n\n.spectrum-contrast-container {\n    width: 100%;\n    height: 100%;\n}\n\n.spectrum-contrast-line,\n:host-context(.-theme-with-dark-background) .spectrum-contrast-line {\n    fill: none;\n    stroke: white;\n    opacity: 0.7;\n    stroke-width: 1.5px;\n}\n\n.delete-color-toolbar {\n    position: absolute;\n    right: 0;\n    top: 0;\n    background-color: #EFEFEF;\n    visibility: hidden;\n    z-index: 3;\n    width: 36px;\n    display: flex;\n    align-items: center;\n    padding-left: 4px;\n    bottom: 2px;\n    border-bottom-right-radius: 2px;\n}\n\n@keyframes showDeleteToolbar {\n    from {\n        opacity: 0;\n    }\n    to {\n        opacity: 1;\n    }\n}\n\n.delete-color-toolbar.dragging {\n    visibility: visible;\n    animation: showDeleteToolbar 100ms 150ms cubic-bezier(0, 0, 0.2, 1) backwards;\n}\n\n.delete-color-toolbar-active {\n    background-color: #ddd;\n    color: white;\n}\n\n.swatch.contrast {\n    width: 30px;\n    height: 30px;\n    position: absolute;\n    top: 0px;\n    right: 0;\n    left: auto;\n    background-image: url(Images/checker.png);\n    border-radius: 15px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.swatch.contrast .swatch-overlay {\n    padding: 0;\n}\n\n.background-color .text-preview {\n    color: black;\n    font-size: 16px;\n    position: relative;\n    padding-bottom: 2px;\n}\n\n.swatch.contrast [is=ui-icon] {\n    margin: -2px;\n}\n\n/*# sourceURL=color_picker/spectrum.css */";