/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.AbstractPlacer;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenLabel;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.EditLabelAction;
import ca.sqlpower.object.SPLabel;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.DataEntryPanel;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;

public class CreateLabelAction
extends AbstractArchitectAction {
    public CreateLabelAction(ArchitectFrame frame) {
        super(frame, "New Label...", "New Label", "label");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PlayPen playpen = this.getPlaypen();
        playpen.fireCancel();
        ArchitectLabel spLabel = new ArchitectLabel();
        spLabel.setName("label");
        PlayPenLabel ppLabel = new PlayPenLabel(spLabel, "label");
        LabelPlacer labelPlacer = new LabelPlacer(playpen, ppLabel);
        labelPlacer.dirtyup();
    }

    private class LabelPlacer
    extends AbstractPlacer {
        private final PlayPenLabel label;

        LabelPlacer(PlayPen pp, PlayPenLabel label) {
            super(pp);
            this.label = label;
        }

        @Override
        protected String getEditDialogTitle() {
            return "Label Properties";
        }

        @Override
        public DataEntryPanel place(final Point p) throws SQLObjectException {
            this.label.setLocation(p);
            EditLabelAction editLabelAction = CreateLabelAction.this.frame.getEditLabelAction();
            editLabelAction.getClass();
            EditLabelAction.PlayPenLabelEditorPanel editPanel = new EditLabelAction.PlayPenLabelEditorPanel(editLabelAction, this.label.getLabel(), false, true){
                {
                    EditLabelAction editLabelAction = x0;
                    editLabelAction.getClass();
                    super(editLabelAction, x1, x2, x3);
                }

                public boolean applyChanges() {
                    ArchitectSwingSession session = CreateLabelAction.this.getSession();
                    try {
                        session.getWorkspace().begin("Creating a PlayPenLabel");
                        if (super.applyChanges()) {
                            LabelPlacer.this.playpen.selectNone();
                            LabelPlacer.this.playpen.addLabel(LabelPlacer.this.label, p);
                            LabelPlacer.this.label.setSelected(true, 4);
                            session.getWorkspace().commit();
                            return true;
                        }
                        session.getWorkspace().rollback("Error creating label");
                        return false;
                    }
                    catch (Throwable t) {
                        session.getWorkspace().rollback("Error creating label");
                        throw new RuntimeException(t);
                    }
                }
            };
            return editPanel;
        }
    }

    public static final class ArchitectLabel
    extends SPLabel {
        public Font getFont() {
            return null;
        }

        public void setFont(Font font) {
        }
    }
}

