/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.SystemReader;

public class BaseRepositoryBuilder<B extends BaseRepositoryBuilder, R extends Repository> {
    private FS fs;
    private File gitDir;
    private File objectDirectory;
    private List<File> alternateObjectDirectories;
    private File indexFile;
    private File workTree;
    private List<File> ceilingDirectories;
    private boolean bare;
    private boolean mustExist;
    private Config config;

    private static boolean isSymRef(byte[] ref2) {
        if (ref2.length < 9) {
            return false;
        }
        return ref2[0] == 103 && ref2[1] == 105 && ref2[2] == 116 && ref2[3] == 100 && ref2[4] == 105 && ref2[5] == 114 && ref2[6] == 58 && ref2[7] == 32;
    }

    private static File getSymRef(File workTree, File dotGit, FS fs) throws IOException {
        byte[] content = IO.readFully(dotGit);
        if (!BaseRepositoryBuilder.isSymRef(content)) {
            throw new IOException(MessageFormat.format(JGitText.get().invalidGitdirRef, dotGit.getAbsolutePath()));
        }
        int pathStart = 8;
        int lineEnd = RawParseUtils.nextLF(content, pathStart);
        while (content[lineEnd - 1] == 10 || content[lineEnd - 1] == 13 && SystemReader.getInstance().isWindows()) {
            --lineEnd;
        }
        if (lineEnd == pathStart) {
            throw new IOException(MessageFormat.format(JGitText.get().invalidGitdirRef, dotGit.getAbsolutePath()));
        }
        String gitdirPath = RawParseUtils.decode(content, pathStart, lineEnd);
        File gitdirFile = fs.resolve(workTree, gitdirPath);
        if (gitdirFile.isAbsolute()) {
            return gitdirFile;
        }
        return new File(workTree, gitdirPath).getCanonicalFile();
    }

    public B setFS(FS fs) {
        this.fs = fs;
        return this.self();
    }

    public FS getFS() {
        return this.fs;
    }

    public B setGitDir(File gitDir) {
        this.gitDir = gitDir;
        this.config = null;
        return this.self();
    }

    public File getGitDir() {
        return this.gitDir;
    }

    public B setObjectDirectory(File objectDirectory) {
        this.objectDirectory = objectDirectory;
        return this.self();
    }

    public File getObjectDirectory() {
        return this.objectDirectory;
    }

    public B addAlternateObjectDirectory(File other) {
        if (other != null) {
            if (this.alternateObjectDirectories == null) {
                this.alternateObjectDirectories = new LinkedList<File>();
            }
            this.alternateObjectDirectories.add(other);
        }
        return this.self();
    }

    public B addAlternateObjectDirectories(Collection<File> inList) {
        if (inList != null) {
            for (File path2 : inList) {
                this.addAlternateObjectDirectory(path2);
            }
        }
        return this.self();
    }

    public B addAlternateObjectDirectories(File[] inList) {
        if (inList != null) {
            for (File path2 : inList) {
                this.addAlternateObjectDirectory(path2);
            }
        }
        return this.self();
    }

    public File[] getAlternateObjectDirectories() {
        List<File> alts2 = this.alternateObjectDirectories;
        if (alts2 == null) {
            return null;
        }
        return alts2.toArray(new File[alts2.size()]);
    }

    public B setBare() {
        this.setIndexFile(null);
        this.setWorkTree(null);
        this.bare = true;
        return this.self();
    }

    public boolean isBare() {
        return this.bare;
    }

    public B setMustExist(boolean mustExist) {
        this.mustExist = mustExist;
        return this.self();
    }

    public boolean isMustExist() {
        return this.mustExist;
    }

    public B setWorkTree(File workTree) {
        this.workTree = workTree;
        return this.self();
    }

    public File getWorkTree() {
        return this.workTree;
    }

    public B setIndexFile(File indexFile) {
        this.indexFile = indexFile;
        return this.self();
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    public B readEnvironment() {
        return this.readEnvironment(SystemReader.getInstance());
    }

    public B readEnvironment(SystemReader sr) {
        String val2;
        if (this.getGitDir() == null && (val2 = sr.getenv("GIT_DIR")) != null) {
            this.setGitDir(new File(val2));
        }
        if (this.getObjectDirectory() == null && (val2 = sr.getenv("GIT_OBJECT_DIRECTORY")) != null) {
            this.setObjectDirectory(new File(val2));
        }
        if (this.getAlternateObjectDirectories() == null && (val2 = sr.getenv("GIT_ALTERNATE_OBJECT_DIRECTORIES")) != null) {
            for (String path2 : val2.split(File.pathSeparator)) {
                this.addAlternateObjectDirectory(new File(path2));
            }
        }
        if (this.getWorkTree() == null && (val2 = sr.getenv("GIT_WORK_TREE")) != null) {
            this.setWorkTree(new File(val2));
        }
        if (this.getIndexFile() == null && (val2 = sr.getenv("GIT_INDEX_FILE")) != null) {
            this.setIndexFile(new File(val2));
        }
        if (this.ceilingDirectories == null && (val2 = sr.getenv("GIT_CEILING_DIRECTORIES")) != null) {
            for (String path2 : val2.split(File.pathSeparator)) {
                this.addCeilingDirectory(new File(path2));
            }
        }
        return this.self();
    }

    public B addCeilingDirectory(File root2) {
        if (root2 != null) {
            if (this.ceilingDirectories == null) {
                this.ceilingDirectories = new LinkedList<File>();
            }
            this.ceilingDirectories.add(root2);
        }
        return this.self();
    }

    public B addCeilingDirectories(Collection<File> inList) {
        if (inList != null) {
            for (File path2 : inList) {
                this.addCeilingDirectory(path2);
            }
        }
        return this.self();
    }

    public B addCeilingDirectories(File[] inList) {
        if (inList != null) {
            for (File path2 : inList) {
                this.addCeilingDirectory(path2);
            }
        }
        return this.self();
    }

    public B findGitDir() {
        if (this.getGitDir() == null) {
            this.findGitDir(new File("").getAbsoluteFile());
        }
        return this.self();
    }

    public B findGitDir(File current) {
        if (this.getGitDir() == null) {
            FS tryFS = this.safeFS();
            while (current != null) {
                File dir2 = new File(current, ".git");
                if (RepositoryCache.FileKey.isGitRepository(dir2, tryFS)) {
                    this.setGitDir(dir2);
                    break;
                }
                if (dir2.isFile()) {
                    try {
                        this.setGitDir(BaseRepositoryBuilder.getSymRef(current, dir2, tryFS));
                        break;
                    }
                    catch (IOException iOException) {
                    }
                } else if (RepositoryCache.FileKey.isGitRepository(current, tryFS)) {
                    this.setGitDir(current);
                    break;
                }
                if ((current = current.getParentFile()) == null || this.ceilingDirectories == null || !this.ceilingDirectories.contains(current)) continue;
                break;
            }
        }
        return this.self();
    }

    public B setup() throws IllegalArgumentException, IOException {
        this.requireGitDirOrWorkTree();
        this.setupGitDir();
        this.setupWorkTree();
        this.setupInternals();
        return this.self();
    }

    public R build() throws IOException {
        FileRepository repo = new FileRepository((BaseRepositoryBuilder)this.setup());
        if (this.isMustExist() && !((Repository)repo).getObjectDatabase().exists()) {
            throw new RepositoryNotFoundException(this.getGitDir());
        }
        return (R)repo;
    }

    protected void requireGitDirOrWorkTree() {
        if (this.getGitDir() == null && this.getWorkTree() == null) {
            throw new IllegalArgumentException(JGitText.get().eitherGitDirOrWorkTreeRequired);
        }
    }

    protected void setupGitDir() throws IOException {
        if (this.getGitDir() == null && this.getWorkTree() != null) {
            File dotGit = new File(this.getWorkTree(), ".git");
            if (!dotGit.isFile()) {
                this.setGitDir(dotGit);
            } else {
                this.setGitDir(BaseRepositoryBuilder.getSymRef(this.getWorkTree(), dotGit, this.safeFS()));
            }
        }
    }

    protected void setupWorkTree() throws IOException {
        if (this.getFS() == null) {
            this.setFS(FS.DETECTED);
        }
        if (!this.isBare() && this.getWorkTree() == null) {
            this.setWorkTree(this.guessWorkTreeOrFail());
        }
        if (!this.isBare()) {
            if (this.getGitDir() == null) {
                this.setGitDir(this.getWorkTree().getParentFile());
            }
            if (this.getIndexFile() == null) {
                this.setIndexFile(new File(this.getGitDir(), "index"));
            }
        }
    }

    protected void setupInternals() throws IOException {
        if (this.getObjectDirectory() == null && this.getGitDir() != null) {
            this.setObjectDirectory(this.safeFS().resolve(this.getGitDir(), "objects"));
        }
    }

    protected Config getConfig() throws IOException {
        if (this.config == null) {
            this.config = this.loadConfig();
        }
        return this.config;
    }

    protected Config loadConfig() throws IOException {
        if (this.getGitDir() != null) {
            File path2 = this.safeFS().resolve(this.getGitDir(), "config");
            FileBasedConfig cfg = new FileBasedConfig(path2, this.safeFS());
            try {
                cfg.load();
            }
            catch (ConfigInvalidException err) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().repositoryConfigFileInvalid, path2.getAbsolutePath(), err.getMessage()));
            }
            return cfg;
        }
        return new Config();
    }

    private File guessWorkTreeOrFail() throws IOException {
        Config cfg = this.getConfig();
        String path2 = cfg.getString("core", null, "worktree");
        if (path2 != null) {
            return this.safeFS().resolve(this.getGitDir(), path2).getCanonicalFile();
        }
        if (cfg.getString("core", null, "bare") != null) {
            if (cfg.getBoolean("core", "bare", true)) {
                this.setBare();
                return null;
            }
            return this.getGitDir().getParentFile();
        }
        if (this.getGitDir().getName().equals(".git")) {
            return this.getGitDir().getParentFile();
        }
        this.setBare();
        return null;
    }

    protected FS safeFS() {
        return this.getFS() != null ? this.getFS() : FS.DETECTED;
    }

    protected final B self() {
        return (B)this;
    }
}

