/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.util.Arrays;
import org.apache.lucene.search.intervals.ConjunctionIntervalsSource;
import org.apache.lucene.search.intervals.DifferenceIntervalFunction;
import org.apache.lucene.search.intervals.DifferenceIntervalsSource;
import org.apache.lucene.search.intervals.DisjunctionIntervalsSource;
import org.apache.lucene.search.intervals.IntervalFunction;
import org.apache.lucene.search.intervals.IntervalsSource;
import org.apache.lucene.search.intervals.LowpassIntervalsSource;
import org.apache.lucene.search.intervals.MinimizingConjunctionIntervalsSource;
import org.apache.lucene.search.intervals.TermIntervalsSource;
import org.apache.lucene.util.BytesRef;

public final class Intervals {
    private Intervals() {
    }

    public static IntervalsSource term(BytesRef term) {
        return new TermIntervalsSource(term);
    }

    public static IntervalsSource term(String term) {
        return new TermIntervalsSource(new BytesRef((CharSequence)term));
    }

    public static IntervalsSource phrase(String ... terms) {
        IntervalsSource[] sources = new IntervalsSource[terms.length];
        int i = 0;
        for (String term : terms) {
            sources[i] = Intervals.term(term);
            ++i;
        }
        return Intervals.phrase(sources);
    }

    public static IntervalsSource phrase(IntervalsSource ... subSources) {
        return new ConjunctionIntervalsSource(Arrays.asList(subSources), IntervalFunction.BLOCK);
    }

    public static IntervalsSource or(IntervalsSource ... subSources) {
        if (subSources.length == 1) {
            return subSources[0];
        }
        return new DisjunctionIntervalsSource(Arrays.asList(subSources));
    }

    public static IntervalsSource maxwidth(int width, IntervalsSource subSource) {
        return new LowpassIntervalsSource(subSource, width);
    }

    public static IntervalsSource ordered(IntervalsSource ... subSources) {
        return new MinimizingConjunctionIntervalsSource(Arrays.asList(subSources), IntervalFunction.ORDERED);
    }

    public static IntervalsSource unordered(IntervalsSource ... subSources) {
        return Intervals.unordered(true, subSources);
    }

    public static IntervalsSource unordered(boolean allowOverlaps, IntervalsSource ... subSources) {
        return new MinimizingConjunctionIntervalsSource(Arrays.asList(subSources), allowOverlaps ? IntervalFunction.UNORDERED : IntervalFunction.UNORDERED_NO_OVERLAP);
    }

    public static IntervalsSource nonOverlapping(IntervalsSource minuend, IntervalsSource subtrahend) {
        return new DifferenceIntervalsSource(minuend, subtrahend, DifferenceIntervalFunction.NON_OVERLAPPING);
    }

    public static IntervalsSource notWithin(IntervalsSource minuend, int positions, IntervalsSource subtrahend) {
        return new DifferenceIntervalsSource(minuend, subtrahend, new DifferenceIntervalFunction.NotWithinFunction(positions));
    }

    public static IntervalsSource notContaining(IntervalsSource minuend, IntervalsSource subtrahend) {
        return new DifferenceIntervalsSource(minuend, subtrahend, DifferenceIntervalFunction.NOT_CONTAINING);
    }

    public static IntervalsSource containing(IntervalsSource big, IntervalsSource small) {
        return new ConjunctionIntervalsSource(Arrays.asList(big, small), IntervalFunction.CONTAINING);
    }

    public static IntervalsSource notContainedBy(IntervalsSource small, IntervalsSource big) {
        return new DifferenceIntervalsSource(small, big, DifferenceIntervalFunction.NOT_CONTAINED_BY);
    }

    public static IntervalsSource containedBy(IntervalsSource small, IntervalsSource big) {
        return new ConjunctionIntervalsSource(Arrays.asList(small, big), IntervalFunction.CONTAINED_BY);
    }
}

