#
# Command specific completions for the node command.
# These completions were generated from the commands
# man page by the make_completions.py script, but has
# been hand edited since.
#

# the four main options, each with a short & long flag
complete -x -c node -s v -n '__fish_not_contain_opt -s p -s i -s e eval print interactive' -l version -d "Print node's version"
complete -c node -n '__fish_not_contain_opt -s v -s p -s i version print interactive' -r -s e -l eval -d 'Evaluate script'
complete -c node -n '__fish_not_contain_opt -s v -s e -s i version eval interactive' -r -s p -l print -d 'Print result of --eval'
complete -c node -n '__fish_not_contain_opt -s v -s p -s e version print eval' -s i -l interactive -d 'Always enter the REPL even if stdin does not appear to be a terminal'

# longer options related to V8, ES5, logging, etc.
complete -c node -l no-deprecation -d 'Silence deprecation warnings'
complete -c node -l trace-deprecation -d 'Show stack traces on deprecations'
complete -c node -l throw-deprecation -d 'Throw errors on deprecations'
complete -c node -l v8-options -d 'Print v8 command line options'
complete -c node -l max-stack-size -d 'Set max v8 stack size (bytes)'
complete -c node -l use_strict -d 'enforce strict mode. type: bool default: false'
complete -c node -l  es5_readonly -d 'activate correct semantics for inheriting readonliness. type: bool default: false'
complete -c node -l  es52_globals -d 'activate new semantics for global var declarations. type: bool default: false'
complete -c node -l  harmony_typeof -d 'enable harmony semantics for typeof. type: bool default: false'
complete -c node -l  harmony_scoping -d 'enable harmony block scoping. type: bool default: false'
complete -c node -l  harmony_modules -d 'enable harmony modules (implies block scoping). type: bool default: false'
complete -c node -l  harmony_proxies -d 'enable harmony proxies. type: bool default: false'
complete -c node -l  harmony_collections -d 'enable harmony collections (sets, maps, and weak maps). type: bool default: false'
complete -c node -l  harmony -d 'enable all harmony features (except typeof). type: bool default: false'
complete -c node -l  packed_arrays -d 'optimizes arrays that have no holes. type: bool default: false'
complete -c node -l  smi_only_arrays -d 'tracks arrays with only smi values. type: bool default: true'
complete -c node -l  clever_optimizations -d 'Optimize object size, Array shift, DOM strings and string +. type: bool default: true'
complete -c node -l  unbox_double_arrays -d 'automatically unbox arrays of doubles. type: bool default: true'
complete -c node -l  string_slices -d 'use string slices. type: bool default: true'
complete -c node -l  crankshaft -d 'use crankshaft. type: bool default: true'
complete -c node -l  hydrogen_filter -d 'optimization filter. type: string default:'
complete -c node -l  use_range -d 'use hydrogen range analysis. type: bool default: true'
complete -c node -l  eliminate_dead_phis -d 'eliminate dead phis. type: bool default: true'
complete -c node -l  use_gvn -d 'use hydrogen global value numbering. type: bool default: true'
complete -c node -l  use_canonicalizing -d 'use hydrogen instruction canonicalizing. type: bool default: true'
complete -c node -l  use_inlining -d 'use function inlining. type: bool default: true'
complete -c node -l  max_inlined_source_size -d 'maximum source size in bytes considered for a single inlining. type: int default: 600'
complete -c node -l  max_inlined_nodes -d 'maximum number of AST nodes considered for a single inlining. type: int default: 196'
complete -c node -l  max_inlined_nodes_cumulative -d 'maximum cumulative number of AST nodes considered for inlining. type: int default: 196'
complete -c node -l  loop_invariant_code_motion -d 'loop invariant code motion. type: bool default: true'
complete -c node -l  collect_megamorphic_maps_from_stub_cache -d 'crankshaft harvests type feedback from stub cache. type: bool default: true'
complete -c node -l  hydrogen_stats -d 'print statistics for hydrogen. type: bool default: false'
complete -c node -l  trace_hydrogen -d 'trace generated hydrogen to file. type: bool default: false'
complete -c node -l  trace_phase -d 'trace generated IR for specified phases. type: string default: Z'
complete -c node -l  trace_inlining -d 'trace inlining decisions. type: bool default: false'
complete -c node -l  trace_alloc -d 'trace register allocator. type: bool default: false'
complete -c node -l  trace_all_uses -d 'trace all use positions. type: bool default: false'
complete -c node -l  trace_range -d 'trace range analysis. type: bool default: false'
complete -c node -l  trace_gvn -d 'trace global value numbering. type: bool default: false'
complete -c node -l  trace_representation -d 'trace representation types. type: bool default: false'
complete -c node -l  stress_pointer_maps -d 'pointer map for every instruction. type: bool default: false'
complete -c node -l  stress_environments -d 'environment for every instruction. type: bool default: false'
complete -c node -l  deopt_every_n_times -d 'deoptimize every n times a deopt point is passed. type: int default: 0'
complete -c node -l  trap_on_deopt -d 'put a break point before deoptimizing. type: bool default: false'
complete -c node -l  deoptimize_uncommon_cases -d 'deoptimize uncommon cases. type: bool default: true'
complete -c node -l  polymorphic_inlining -d 'polymorphic inlining. type: bool default: true'
complete -c node -l  use_osr -d 'use on-stack replacement. type: bool default: true'
complete -c node -l  array_bounds_checks_elimination -d 'perform array bounds checks elimination. type: bool default: false'
complete -c node -l  array_index_dehoisting -d 'perform array index dehoisting. type: bool default: false'
complete -c node -l  trace_osr -d 'trace on-stack replacement. type: bool default: false'
complete -c node -l  stress_runs -d 'number of stress runs. type: int default: 0'
complete -c node -l  optimize_closures -d 'optimize closures. type: bool default: true'
complete -c node -l  inline_construct -d 'inline constructor calls. type: bool default: true'
complete -c node -l  inline_arguments -d 'inline functions with arguments object. type: bool default: true'
complete -c node -l  loop_weight -d 'loop weight for representation inference. type: int default: 1'
complete -c node -l  optimize_for_in -d 'optimize functions containing for-in loops. type: bool default: true'
complete -c node -l  experimental_profiler -d 'enable all profiler experiments. type: bool default: true'
complete -c node -l  watch_ic_patching -d 'profiler considers IC stability. type: bool default: false'
complete -c node -l  frame_count -d 'number of stack frames inspected by the profiler. type: int default: 1'
complete -c node -l  self_optimization -d 'primitive functions trigger their own optimization. type: bool default: false'
complete -c node -l  direct_self_opt -d 'call recompile stub directly when self-optimizing. type: bool default: false'
complete -c node -l  retry_self_opt -d 're-try self-optimization if it failed. type: bool default: false'
complete -c node -l  count_based_interrupts -d 'trigger profiler ticks based on counting instead of timing. type: bool default: false'
complete -c node -l  interrupt_at_exit -d 'insert an interrupt check at function exit. type: bool default: false'
complete -c node -l  weighted_back_edges -d 'weight back edges by jump distance for interrupt triggering. type: bool default: false'
complete -c node -l  interrupt_budget -d 'execution budget before interrupt is triggered. type: int default: 5900'
complete -c node -l  type_info_threshold -d 'percentage of ICs that must have type info to allow optimization. type: int default: 15'
complete -c node -l  self_opt_count -d 'call count before self-optimization. type: int default: 130'
complete -c node -l  trace_opt_verbose -d 'extra verbose compilation tracing. type: bool default: false'
complete -c node -l  debug_code -d 'generate extra code (assertions) for debugging. type: bool default: false'
complete -c node -l  code_comments -d 'emit comments in code disassembly. type: bool default: false'
complete -c node -l  enable_sse2 -d 'enable use of SSE2 instructions if available. type: bool default: true'
complete -c node -l  enable_sse3 -d 'enable use of SSE3 instructions if available. type: bool default: true'
complete -c node -l  enable_sse4_1 -d 'enable use of SSE4'
complete -c node -l enable_cmov -d 'enable use of CMOV instruction if available. type: bool default: true'
complete -c node -l  enable_rdtsc -d 'enable use of RDTSC instruction if available. type: bool default: true'
complete -c node -l  enable_sahf -d 'enable use of SAHF instruction if available (X64 only). type: bool default: true'
complete -c node -l  enable_vfp3 -d 'enable use of VFP3 instructions if available - this implies enabling ARMv7 instructions (ARM only). type: bool default: true'
complete -c node -l  enable_armv7 -d 'enable use of ARMv7 instructions if available (ARM only). type: bool default: true'
complete -c node -l  enable_fpu -d 'enable use of MIPS FPU instructions if available (MIPS only). type: bool default: true'
complete -c node -l  expose_natives_as -d 'expose natives in global object. type: string default: NULL'
complete -c node -l  expose_debug_as -d 'expose debug in global object. type: string default: NULL'
complete -c node -l  expose_gc -d 'expose gc extension. type: bool default: false'
complete -c node -l  expose_externalize_string -d 'expose externalize string extension. type: bool default: false'
complete -c node -l  stack_trace_limit -d 'number of stack frames to capture. type: int default: 10'
complete -c node -l  builtins_in_stack_traces -d 'show built-in functions in stack traces. type: bool default: false'
complete -c node -l  disable_native_files -d 'disable builtin natives files. type: bool default: false'
complete -c node -l  inline_new -d 'use fast inline allocation. type: bool default: true'
complete -c node -l  stack_trace_on_abort -d 'print a stack trace if an assertion failure occurs. type: bool default: true'
complete -c node -l  trace -d 'trace function calls. type: bool default: false'
complete -c node -l  mask_constants_with_cookie -d 'use random jit cookie to mask large constants. type: bool default: true'
complete -c node -l  lazy -d 'use lazy compilation. type: bool default: true'
complete -c node -l  trace_opt -d 'trace lazy optimization. type: bool default: false'
complete -c node -l  trace_opt_stats -d 'trace lazy optimization statistics. type: bool default: false'
complete -c node -l  opt -d 'use adaptive optimizations. type: bool default: true'
complete -c node -l  always_opt -d 'always try to optimize functions. type: bool default: false'
complete -c node -l  prepare_always_opt -d 'prepare for turning on always opt. type: bool default: false'
complete -c node -l  trace_deopt -d 'trace deoptimization. type: bool default: false'
complete -c node -l  min_preparse_length -d 'minimum length for automatic enable preparsing. type: int default: 1024'
complete -c node -l  always_full_compiler -d 'try to use the dedicated run-once backend for all code. type: bool default: false'
complete -c node -l  trace_bailout -d 'print reasons for falling back to using the classic V8 backend. type: bool default: false'
complete -c node -l  compilation_cache -d 'enable compilation cache. type: bool default: true'
complete -c node -l  cache_prototype_transitions -d 'cache prototype transitions. type: bool default: true'
complete -c node -l  trace_debug_json -d 'trace debugging JSON request/response. type: bool default: false'
complete -c node -l  debugger_auto_break -d 'automatically set the debug break flag when debugger commands are in the queue. type: bool default: true'
complete -c node -l  enable_liveedit -d 'enable liveedit experimental feature. type: bool default: true'
complete -c node -l  break_on_abort -d 'always cause a debug break before aborting. type: bool default: true'
complete -c node -l  stack_size -d 'default size of stack region v8 is allowed to use (in kBytes). type: int default: 984'
complete -c node -l  max_stack_trace_source_length -d 'maximum length of function source code printed in a stack trace'
complete -c node -l always_inline_smi_code -d 'always inline smi code in non-opt code. type: bool default: false'
complete -c node -l  max_new_space_size -d 'max size of the new generation (in kBytes). type: int default: 0'
complete -c node -l  max_old_space_size -d 'max size of the old generation (in Mbytes). type: int default: 0'
complete -c node -l  max_executable_size -d 'max size of executable memory (in Mbytes). type: int default: 0'
complete -c node -l  gc_global -d 'always perform global GCs. type: bool default: false'
complete -c node -l  gc_interval -d 'garbage collect after <n> allocations. type: int default: -1'
complete -c node -l  trace_gc -d 'print one trace line following each garbage collection. type: bool default: false'
complete -c node -l  trace_gc_nvp -d 'print one detailed trace line in name=value format after each garbage collection. type: bool default: false'
complete -c node -l  print_cumulative_gc_stat -d 'print cumulative GC statistics in name=value format on exit. type: bool default: false'
complete -c node -l  trace_gc_verbose -d 'print more details following each garbage collection. type: bool default: false'
complete -c node -l  trace_fragmentation -d 'report fragmentation for old pointer and data pages. type: bool default: false'
complete -c node -l  collect_maps -d 'garbage collect maps from which no objects can be reached. type: bool default: true'
complete -c node -l  flush_code -d 'flush code that we expect not to use again before full gc. type: bool default: true'
complete -c node -l  incremental_marking -d 'use incremental marking. type: bool default: true'
complete -c node -l  incremental_marking_steps -d 'do incremental marking steps. type: bool default: true'
complete -c node -l  trace_incremental_marking -d 'trace progress of the incremental marking. type: bool default: false'
complete -c node -l  use_idle_notification -d 'Use idle notification to reduce memory footprint'
complete -c node -l send_idle_notification -d 'Send idle notification between stress runs'
complete -c node -l use_ic -d 'use inline caching. type: bool default: true'
complete -c node -l  native_code_counters -d 'generate extra code for manipulating stats counters. type: bool default: false'
complete -c node -l  always_compact -d 'Perform compaction on every full GC. type: bool default: false'
complete -c node -l  lazy_sweeping -d 'Use lazy sweeping for old pointer and data spaces. type: bool default: true'
complete -c node -l  never_compact -d 'Never perform compaction on full GC - testing only. type: bool default: false'
complete -c node -l  compact_code_space -d 'Compact code space on full non-incremental collections. type: bool default: true'
complete -c node -l  cleanup_code_caches_at_gc -d 'Flush inline caches prior to mark compact collection and flush code caches in maps during mark compact cycle'
complete -c node -l random_seed -d 'Default seed for initializing random generator (0, the default, means to use system random)'
complete -c node -l use_verbose_printer -d 'allows verbose printing. type: bool default: true'
complete -c node -l  allow_natives_syntax -d 'allow natives syntax. type: bool default: false'
complete -c node -l  trace_sim -d 'Trace simulator execution. type: bool default: false'
complete -c node -l  check_icache -d 'Check icache flushes in ARM and MIPS simulator. type: bool default: false'
complete -c node -l  stop_sim_at -d 'Simulator stop after x number of instructions. type: int default: 0'
complete -c node -l  sim_stack_alignment -d 'Stack alignment in bytes in simulator (4 or 8, 8 is default). type: int default: 8'
complete -c node -l  trace_exception -d 'print stack trace when throwing exceptions. type: bool default: false'
complete -c node -l  preallocate_message_memory -d 'preallocate some memory to build stack traces'
complete -c node -l randomize_hashes -d 'randomize hashes to avoid predictable hash collisions (with snapshots this option cannot override the baked-in seed). type: bool default: true'
complete -c node -l  hash_seed -d 'Fixed seed to use to hash property keys (0 means random) (with snapshots this option cannot override the baked-in seed). type: int default: 0'
complete -c node -l  preemption -d 'activate a 100ms timer that switches between V8 threads. type: bool default: false'
complete -c node -l  regexp_optimization -d 'generate optimized regexp code. type: bool default: true'
complete -c node -l  testing_bool_flag -d 'testing_bool_flag. type: bool default: true'
complete -c node -l  testing_int_flag -d 'testing_int_flag. type: int default: 13'
complete -c node -l  testing_float_flag -d 'float-flag. type: float default: 2'
complete -c node -l testing_string_flag -d 'string-flag. type: string default: Hello, world!'
complete -c node -l  testing_prng_seed -d 'Seed used for threading test randomness. type: int default: 42'
complete -c node -l  testing_serialization_file -d 'file in which to serialize heap. type: string default: /tmp/serdes'
complete -c node -l  help -d 'Print usage message, including flags, on console. type: bool default: true'
complete -c node -l  dump_counters -d 'Dump counters on exit. type: bool default: false'
complete -c node -l  debugger -d 'Enable JavaScript debugger. type: bool default: false'
complete -c node -l  remote_debugger -d 'Connect JavaScript debugger to the debugger agent in another process. type: bool default: false'
complete -c node -l  debugger_agent -d 'Enable debugger agent. type: bool default: false'
complete -c node -l  debugger_port -d 'Port to use for remote debugging. type: int default: 5858'
complete -c node -l  map_counters -d 'Map counters to a file. type: string default:'
complete -c node -l  js_arguments -d 'Pass all remaining arguments to the script'
complete -c node -l debug_compile_events -d 'Enable debugger compile events. type: bool default: true'
complete -c node -l  debug_script_collected_events -d 'Enable debugger script collected events. type: bool default: true'
complete -c node -l  gdbjit -d 'enable GDBJIT interface (disables compacting GC). type: bool default: false'
complete -c node -l  gdbjit_full -d 'enable GDBJIT interface for all code objects. type: bool default: false'
complete -c node -l  gdbjit_dump -d 'dump elf objects with debug info to disk. type: bool default: false'
complete -c node -l  gdbjit_dump_filter -d 'dump only objects containing this substring. type: string default:'
complete -c node -l  force_marking_deque_overflows -d 'force overflows of marking deque by reducing its size to 64 words. type: bool default: false'
complete -c node -l  stress_compaction -d 'stress the GC compactor to flush out bugs (implies --force_marking_deque_overflows). type: bool default: false'
complete -c node -l  log -d 'Minimal logging (no API, code, GC, suspect, or handles samples)'
complete -c node -l log_all -d 'Log all events to the log file'
complete -c node -l log_runtime -d 'Activate runtime system %Log call'
complete -c node -l log_api -d 'Log API events to the log file'
complete -c node -l log_code -d 'Log code events to the log file without profiling'
complete -c node -l log_gc -d 'Log heap samples on garbage collection for the hp2ps tool'
complete -c node -l log_handles -d 'Log global handle events'
complete -c node -l log_snapshot_positions -d 'log positions of (de)serialized objects in the snapshot'
complete -c node -l log_suspect -d 'Log suspect operations'
complete -c node -l prof -d 'Log statistical profiling information (implies --log-code)'
complete -c node -l prof_auto -d 'Used with --prof, starts profiling automatically) type: bool default: true'
complete -c node -l  prof_lazy -d 'Used with --prof, only does sampling and logging when profiler is active (implies --noprof_auto)'
complete -c node -l prof_browser_mode -d 'Used with --prof, turns on browser-compatible mode for profiling'
complete -c node -l log_regexp -d 'Log regular expression execution'
complete -c node -l sliding_state_window -d 'Update sliding state window counters'
complete -c node -l logfile -d 'Specify the name of the log file'
complete -c node -l ll_prof -d 'Enable low-level linux profiler'
