/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.BuildExecutionAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.internal.InternalListener;

public class SelectedTaskExecutionAction
implements BuildExecutionAction {
    @Override
    public void execute(BuildExecutionContext context, Collection<? super Throwable> taskFailures) {
        GradleInternal gradle = context.getGradle();
        TaskExecutionGraphInternal taskGraph = gradle.getTaskGraph();
        if (gradle.getStartParameter().isContinueOnFailure()) {
            taskGraph.setContinueOnFailure(true);
        }
        taskGraph.addTaskExecutionGraphListener(new BindAllReferencesOfProjectsToExecuteListener());
        taskGraph.execute(taskFailures);
    }

    private static class BindAllReferencesOfProjectsToExecuteListener
    implements TaskExecutionGraphListener,
    InternalListener {
        private BindAllReferencesOfProjectsToExecuteListener() {
        }

        public void graphPopulated(TaskExecutionGraph graph) {
            HashSet seen = Sets.newHashSet();
            for (Task task : graph.getAllTasks()) {
                if (!seen.add(task.getProject())) continue;
                ProjectInternal projectInternal = (ProjectInternal)task.getProject();
                projectInternal.bindAllModelRules();
            }
        }
    }
}

