/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.fileloader;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import org.jd.gui.api.API;
import org.jd.gui.service.extension.ExtensionService;
import org.jd.gui.spi.FileLoader;

public class FileLoaderService {
    protected static final FileLoaderService FILE_LOADER_SERVICE = new FileLoaderService();
    protected final Collection<FileLoader> providers = ExtensionService.getInstance().load(FileLoader.class);
    protected HashMap<String, FileLoader> mapProviders = new HashMap();

    public static FileLoaderService getInstance() {
        return FILE_LOADER_SERVICE;
    }

    protected FileLoaderService() {
        for (FileLoader provider : this.providers) {
            for (String extension : provider.getExtensions()) {
                this.mapProviders.put(extension, provider);
            }
        }
    }

    public FileLoader get(API api, File file) {
        String name = file.getName();
        int lastDot = name.lastIndexOf(46);
        String extension = name.substring(lastDot + 1);
        FileLoader provider = this.mapProviders.get(extension);
        return provider;
    }

    public HashMap<String, FileLoader> getMapProviders() {
        return this.mapProviders;
    }
}

