/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.CheckEmptyTagInspection;
import com.intellij.xml.util.CollapseTagIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckTagEmptyBodyInspection
extends XmlSuppressableInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CheckTagEmptyBodyInspection.$$$reportNull$$$0(0);
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                ASTNode node;
                ASTNode child;
                if (!CheckEmptyTagInspection.isTagWithEmptyEndNotAllowed(tag) && (child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode())) != null && (node = child.getTreeNext()) != null && node.getElementType() == XmlTokenType.XML_END_TAG_START) {
                    holder.registerProblem((PsiElement)tag, XmlBundle.message((String)"xml.inspections.tag.empty.body", (Object[])new Object[0]), new LocalQuickFix[]{CheckTagEmptyBodyInspection.isCollapsibleTag(tag) ? new Fix(tag) : null});
                }
            }
        };
        if (xmlElementVisitor == null) {
            CheckTagEmptyBodyInspection.$$$reportNull$$$0(1);
        }
        return xmlElementVisitor;
    }

    static boolean isCollapsibleTag(XmlTag tag) {
        String name = StringUtil.toLowerCase((String)tag.getName());
        return tag.getLanguage() == XMLLanguage.INSTANCE || "link".equals(name) || "br".equals(name) || "meta".equals(name) || "img".equals(name) || "input".equals(name) || "hr".equals(name) || XmlExtension.isCollapsible(tag);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.XML_INSPECTIONS;
        if (string == null) {
            CheckTagEmptyBodyInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"xml.inspections.check.tag.empty.body", (Object[])new Object[0]);
        if (string == null) {
            CheckTagEmptyBodyInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("CheckTagEmptyBody" == null) {
            CheckTagEmptyBodyInspection.$$$reportNull$$$0(4);
        }
        return "CheckTagEmptyBody";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/CheckTagEmptyBodyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/CheckTagEmptyBodyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Fix
    extends CollapseTagIntention {
        private final SmartPsiElementPointer<XmlTag> myPointer;

        public Fix(XmlTag tag) {
            this.myPointer = SmartPointerManager.getInstance((Project)tag.getProject()).createSmartPsiElementPointer((PsiElement)tag);
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            XmlTag tag;
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if ((tag = (XmlTag)this.myPointer.getElement()) == null) {
                return;
            }
            Fix.applyFix(project, (PsiElement)tag);
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                Fix.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/xml/util/CheckTagEmptyBodyInspection$Fix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invoke";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

