/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.ui;

import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.ui.ImageComponent;

public class ImageComponentUI
extends ComponentUI {
    private BufferedImage pattern;

    public ImageComponentUI(JComponent c) {
        c.addPropertyChangeListener(evt -> {
            String name = evt.getPropertyName();
            if ("TransparencyChessboard.blackColor".equals(name) || "TransparencyChessboard.whiteColor".equals(name) || "TransparencyChessboard.cellSize".equals(name)) {
                this.pattern = null;
            }
        });
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        ImageDocument document;
        BufferedImage image;
        ImageComponent ic = (ImageComponent)c;
        if (ic != null && (image = (document = ic.getDocument()).getValue(ic.getZoomFactor())) != null) {
            if (ic.isFileSizeVisible()) {
                ImageComponentUI.paintBorder(g, ic);
            }
            Dimension size = ic.getCanvasSize();
            Graphics igc = g.create(2, 2, size.width, size.height);
            if (ic.isTransparencyChessboardVisible() && image.getTransparency() != 1) {
                this.paintChessboard(igc, ic);
            }
            ImageComponentUI.paintImage(igc, ic);
            if (ic.isGridVisible()) {
                ImageComponentUI.paintGrid(igc, ic);
            }
            igc.dispose();
        }
    }

    private static void paintBorder(Graphics g, ImageComponent ic) {
        Dimension size = ic.getSize();
        g.setColor(ic.getTransparencyChessboardBlackColor());
        g.drawRect(0, 0, size.width - 1, size.height - 1);
    }

    private void paintChessboard(Graphics g, ImageComponent ic) {
        Dimension size = ic.getCanvasSize();
        int cellSize = ic.getTransparencyChessboardCellSize();
        int patternSize = 2 * cellSize;
        if (this.pattern == null) {
            this.pattern = UIUtil.createImage((Graphics)g, (int)patternSize, (int)patternSize, (int)2);
            Graphics imageGraphics = this.pattern.getGraphics();
            imageGraphics.setColor(ic.getTransparencyChessboardWhiteColor());
            imageGraphics.fillRect(0, 0, patternSize, patternSize);
            imageGraphics.setColor(ic.getTransparencyChessboardBlackColor());
            imageGraphics.fillRect(0, cellSize, cellSize, cellSize);
            imageGraphics.fillRect(cellSize, 0, cellSize, cellSize);
        }
        ((Graphics2D)g).setPaint(new TexturePaint(this.pattern, new Rectangle(0, 0, patternSize, patternSize)));
        g.fillRect(0, 0, size.width, size.height);
    }

    private static void paintImage(Graphics g, ImageComponent ic) {
        ImageDocument document = ic.getDocument();
        Dimension size = ic.getCanvasSize();
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints oldHints = g2d.getRenderingHints();
        BufferedImage image = document.getValue(ic.getZoomFactor());
        if (image == null) {
            return;
        }
        if (size.width > image.getWidth() && size.height > image.getHeight()) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        StartupUiUtil.drawImage((Graphics)g, (Image)image, (Rectangle)new Rectangle(0, 0, size.width, size.height), (ImageObserver)ic);
        g2d.setRenderingHints(oldHints);
    }

    private static void paintGrid(Graphics g, ImageComponent ic) {
        int imageHeight;
        double zoomY;
        Dimension size = ic.getCanvasSize();
        BufferedImage image = ic.getDocument().getValue();
        int imageWidth = image.getWidth();
        double zoomX = (double)size.width / (double)imageWidth;
        double zoomFactor = (zoomX + (zoomY = (double)size.height / (double)(imageHeight = image.getHeight()))) / 2.0;
        if (zoomFactor >= (double)ic.getGridLineZoomFactor()) {
            int ls;
            g.setColor(ic.getGridLineColor());
            for (int dx = ls = ic.getGridLineSpan(); dx < imageWidth; dx += ls) {
                UIUtil.drawLine((Graphics)g, (int)((int)((double)dx * zoomX)), (int)0, (int)((int)((double)dx * zoomX)), (int)size.height);
            }
            for (int dy = ls; dy < imageHeight; dy += ls) {
                UIUtil.drawLine((Graphics)g, (int)0, (int)((int)((double)dy * zoomY)), (int)size.width, (int)((int)((double)dy * zoomY)));
            }
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new ImageComponentUI(c);
    }
}

