/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalTabCloseListener;
import org.jetbrains.plugins.terminal.action.MoveTerminalToolwindowTabLeftRightAction;
import org.jetbrains.plugins.terminal.action.TerminalSessionContextMenuActionBase;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u000f\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\"\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/action/MoveTerminalToolwindowTabLeftRightAction;", "Lorg/jetbrains/plugins/terminal/action/TerminalSessionContextMenuActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "moveLeft", "", "(Z)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "content", "Lcom/intellij/ui/content/Content;", "isAvailable", "move", "project", "Lcom/intellij/openapi/project/Project;", "update", "activeToolWindow", "selectedContent", "intellij.terminal"})
public class MoveTerminalToolwindowTabLeftRightAction
extends TerminalSessionContextMenuActionBase
implements DumbAware {
    private final boolean moveLeft;

    public void actionPerformed(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow, @Nullable Content content) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)toolWindow, (String)"toolWindow");
        this.move(content, e.getProject());
    }

    @Override
    public void update(@NotNull AnActionEvent e, @NotNull ToolWindow activeToolWindow, @Nullable Content selectedContent) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)activeToolWindow, (String)"activeToolWindow");
        super.update(e, activeToolWindow, selectedContent);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        if (presentation.isEnabledAndVisible()) {
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
            presentation2.setEnabled(this.isAvailable(selectedContent) && e.getProject() != null);
        }
    }

    public final boolean isAvailable(@Nullable Content content) {
        Content content2 = content;
        if (content2 == null || (content2 = content2.getManager()) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"content?.manager ?: return false");
        Content manager = content2;
        int ind = manager.getIndexOfContent(content);
        return this.moveLeft ? ind > 0 : ind >= 0 && ind < manager.getContentCount() - 1;
    }

    public final void move(@Nullable Content content, @Nullable Project project) {
        int otherInd;
        Content content2 = content;
        if (content2 == null || (content2 = content2.getManager()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"content?.manager ?: return");
        Content manager = content2;
        int ind = manager.getIndexOfContent(content);
        int n = otherInd = this.moveLeft ? ind - 1 : ind + 1;
        if (ind >= 0 && otherInd >= 0 && otherInd < manager.getContentCount() && project != null) {
            Content content3 = manager.getContent(otherInd);
            if (content3 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)content3, (String)"manager.getContent(otherInd)!!");
            Content otherContent = content3;
            TerminalTabCloseListener.Companion.executeContentOperationSilently(otherContent, (Function0<Unit>)((Function0)new Function0<Unit>((ContentManager)manager, otherContent, ind, project){
                final /* synthetic */ ContentManager $manager;
                final /* synthetic */ Content $otherContent;
                final /* synthetic */ int $ind;
                final /* synthetic */ Project $project;

                public final void invoke() {
                    this.$manager.removeContent(this.$otherContent, false, false, false).doWhenDone(new Runnable(this){
                        final /* synthetic */ move.1 this$0;

                        public final void run() {
                            this.this$0.$manager.addContent(this.this$0.$otherContent, this.this$0.$ind);
                            new TerminalTabCloseListener(this.this$0.$otherContent, this.this$0.$project);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.$manager = contentManager;
                    this.$otherContent = content;
                    this.$ind = n;
                    this.$project = project;
                    super(0);
                }
            }));
        }
    }

    public MoveTerminalToolwindowTabLeftRightAction(boolean moveLeft) {
        this.moveLeft = moveLeft;
    }
}

