/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsShelveUtils;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.openapi.vcs.impl.LocalChangesUnderRoots;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsShelveChangesSaver {
    private static final Logger LOG = Logger.getInstance(VcsShelveChangesSaver.class);
    private final Project myProject;
    private final String myStashMessage;
    private final ShelveChangesManager myShelveManager;
    private final ChangeListManagerEx myChangeManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final ProgressIndicator myProgressIndicator;
    private Map<String, ShelvedChangeList> myShelvedLists;

    public VcsShelveChangesSaver(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull String stashMessage) {
        if (project == null) {
            VcsShelveChangesSaver.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            VcsShelveChangesSaver.$$$reportNull$$$0(1);
        }
        if (stashMessage == null) {
            VcsShelveChangesSaver.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myShelveManager = ShelveChangesManager.getInstance(project);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myChangeManager = ChangeListManagerImpl.getInstanceImpl(project);
        this.myProgressIndicator = indicator;
        this.myStashMessage = stashMessage;
    }

    @Nullable
    public Map<String, ShelvedChangeList> getShelvedLists() {
        return this.myShelvedLists;
    }

    public void save(@NotNull Collection<? extends VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null) {
            VcsShelveChangesSaver.$$$reportNull$$$0(3);
        }
        LOG.info("save " + rootsToSave);
        Map<String, Map<VirtualFile, Collection<Change>>> lists = new LocalChangesUnderRoots(this.myChangeManager, this.myVcsManager).getChangesByLists(rootsToSave);
        String oldProgressTitle = this.myProgressIndicator.getText();
        this.myProgressIndicator.setText(VcsBundle.getString((String)"vcs.shelving.changes"));
        ArrayList exceptions = new ArrayList(1);
        this.myShelvedLists = new HashMap<String, ShelvedChangeList>();
        for (Map.Entry<String, Map<VirtualFile, Collection<Change>>> entry : lists.entrySet()) {
            Map<VirtualFile, Collection<Change>> map2 = entry.getValue();
            HashSet<Change> changes2 = new HashSet<Change>();
            for (Collection<Change> changeCollection : map2.values()) {
                changes2.addAll(changeCollection);
            }
            if (changes2.isEmpty()) continue;
            ShelvedChangeList list = VcsShelveUtils.shelveChanges(this.myProject, this.myShelveManager, changes2, ChangeListUtil.createSystemShelvedChangeListName(this.myStashMessage, entry.getKey()), exceptions, false, true);
            this.myShelvedLists.put(entry.getKey(), list);
        }
        if (!exceptions.isEmpty()) {
            LOG.info("save " + exceptions, (Throwable)exceptions.get(0));
            this.myShelvedLists = null;
            throw (VcsException)((Object)exceptions.get(0));
        }
        this.doRollback(rootsToSave);
        this.myProgressIndicator.setText(oldProgressTitle);
    }

    public void load() {
        if (this.myShelvedLists != null) {
            LOG.info("load ");
            String oldProgressTitle = this.myProgressIndicator.getText();
            this.myProgressIndicator.setText(VcsBundle.getString((String)"vcs.unshelving.changes"));
            for (Map.Entry<String, ShelvedChangeList> listEntry : this.myShelvedLists.entrySet()) {
                VcsShelveUtils.doSystemUnshelve(this.myProject, listEntry.getValue(), this.myChangeManager.findChangeList(listEntry.getKey()), this.myShelveManager, VcsBundle.getString((String)"vcs.unshelving.conflict.left"), VcsBundle.getString((String)"vcs.unshelving.conflict.right"));
            }
            this.myProgressIndicator.setText(oldProgressTitle);
        }
    }

    protected void doRollback(@NotNull Collection<? extends VirtualFile> rootsToSave) {
        if (rootsToSave == null) {
            VcsShelveChangesSaver.$$$reportNull$$$0(4);
        }
        HashSet<? extends VirtualFile> rootsSet = new HashSet<VirtualFile>(rootsToSave);
        List changes4Rollback = ContainerUtil.filter((Collection)this.myChangeManager.getAllChanges(), change -> rootsSet.contains(this.myVcsManager.getVcsRootFor(ChangesUtil.getFilePath((Change)change))));
        new RollbackWorker(this.myProject, this.myStashMessage, true).doRollback(changes4Rollback, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stashMessage";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsShelveChangesSaver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doRollback";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

